<?php

defined('BASEPATH') or exit('No direct script access allowed');
require_once('SuperCtrl.php');

class home extends SuperCtrl
{

    public function __construct()
    {
        parent::__construct();
        $this->load->library('session');

    }

    public function index()
    {
        $this->preparePageBy('view_content_home');
    }

    public function logout()
    {
        $this->destroySession();
        $this->pageLoadBy('view_login');
    }

    public function logs()
    {
        $dirPath = 'application/logs/';

        // Get all files in the directory
        $files = glob($dirPath . '*');

        // Initialize variables to store information about the most recent file
        $mostRecentFile = null;
        $mostRecentTimestamp = 0;

        // Loop through each file to find the most recent one
        foreach ($files as $file) {
            if (is_file($file)) {
                $timestamp = filemtime($file); // Get last modified timestamp
                if ($timestamp > $mostRecentTimestamp) {
                    $mostRecentTimestamp = $timestamp;
                    $mostRecentFile = $file;
                }
            }
        }

        // Check if a most recent file was found
        if ($mostRecentFile) {
            // Output the last modified time of the most recent file
            echo "<center><h2>Error Log</h2></center><br>";
            echo "<b>Last modified file</b>: $mostRecentFile<br>";
            echo "<b>Last modified time:</b> " . date('Y-m-d H:i:s', $mostRecentTimestamp) . "<br>";

            // Optionally, display the contents of the most recent file
            $fileContents = file_get_contents($mostRecentFile);
            echo '<pre>';
            echo htmlspecialchars($fileContents);
            echo '</pre>';
        } else {
            echo "No files found in directory: $dirPath";
        }
    }


    public function viewdb()
    {
        //$dirPath = './DatabaseBackup';

        $dirPath = 'application/DatabaseBackup/';
        
       // echo "Resolved path: " . $dirPath . "<br>";

        if (!$dirPath || !is_dir($dirPath)) {
            die("Directory does not exist: " . $dirPath);
        }

        $files = [];
        if ($dir = opendir($dirPath)) {
            while (($file = readdir($dir)) !== false) {
                if ($file != '.' && $file != '..') {
                    $files[] = $file;
                }
            }
            closedir($dir);
        }

        $response['data'] = $files;
        $this->pageLoadBy('view_database', $response);
    }


    public function deleteDb()
    {
        $fileName = $this->input->get('file');

        // Define the path to the Databasebackup folder
       // $directory = './Databasebackup';

       $directory = 'application/DatabaseBackup/';

        // Construct the full path to the file
        $filePath = $directory . '/' . $fileName;

        // Check if the file exists
        if (file_exists($filePath)) {
            // Attempt to delete the file
            if (unlink($filePath)) {
                $this->session->set_flashdata('message', "File '$fileName' has been deleted.");
            } else {
                $this->session->set_flashdata('message', "Error: Could not delete the file.");
            }
        } else {
            $this->session->set_flashdata('message', "Error: File does not exist.");
        }

        // Redirect to the page where you want to display the message
        redirect('home/viewdb');
    }

    public function downloadDb()
    {
        // Get the filename from the query parameter
        $fileName = $this->input->get('file');

        // Define the path to the Databasebackup folder
     //   $directory = './Databasebackup';

     $directory = 'application/DatabaseBackup/';

        // Construct the full path to the file
        $filePath = $directory . '/' . $fileName;

        // Check if the file exists
        if (file_exists($filePath)) {
            // Set headers to initiate file download
            header('Content-Description: File Transfer');
            header('Content-Type: application/octet-stream');
            header('Content-Disposition: attachment; filename="' . basename($filePath) . '"');
            header('Expires: 0');
            header('Cache-Control: must-revalidate');
            header('Pragma: public');
            header('Content-Length: ' . filesize($filePath));

            // Clear output buffer
            ob_clean();
            flush();

            // Read the file and send it to the output buffer
            readfile($filePath);

            // Exit to prevent further script execution
            exit;
        } else {
            // Set flash data message if the file does not exist
            $this->session->set_flashdata('message', "Error: File does not exist.");

            // Redirect to the page where you want to display the message
            redirect('home/viewdb');
        }
    }
}
