<?php
defined('BASEPATH') or exit('No direct script access allowed');
require_once('SuperCtrl.php');
ini_set('memory_limit', '-1');

class MobileAPI extends SuperCtrl
{

    private $apiKey = "PSSZPaQtTewL3wSntlszqfcmEk6Ujxnp"; // Replace with your Gofile API Key

    public function __construct()
    {
        parent::__construct();
        $this->load->model('model_mobileapi');
    }

    public function checkConnection()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            if (isset($_POST['code'])) {
                $response["success"] = 1;
                $response["message"] = "Connection Ready !!";
                echo json_encode($response);
            } else {
                $response["success"] = 0;
                $response["message"] = "Required field(s) is missing";
                echo json_encode($response);
            }
        } else {
            $response["success"] = 0;
            $response["message"] = "Something went wrong";

            //   // Capture the last PHP error if any
//         $error = error_get_last();
//          if ($error) {
//             $response["error_log"] = $error["message"];
//             } else {
//            $response["error_log"] = "No system error captured.";
//           }

            echo json_encode($response);
        }
    }

    public function userLogin()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            if (isset($_POST["username"]) and isset($_POST["password"]) and $userInfo = $this->model_mobileapi->varifyAppUser($_POST["username"], $_POST["password"])) {
                $response["products"] = array();
                // $this->log_gen("hjhh");
                if ($userInfo["Success"] == 1) {
                    $product = array();
                    $product["Name"] = $userInfo["Name"];
                    $product["Code"] = $userInfo["Code"];
                    $product["cnt"] = $userInfo["cnt"];
                    $product["Success"] = $userInfo["Success"];
                    $product["BillNo"] = $userInfo["BillNo"];
                    $product["NewBillNo"] = $userInfo["NewBillNo"];
                    array_push($response["products"], $product);
                    $response["success"] = 1;
                    echo json_encode($response);
                } else {
                    $product["cnt"] = $userInfo["cnt"];
                    $product["Success"] = $userInfo["Success"];
                    $response["success"] = 0;
                    echo json_encode($response);
                }
            } else {
                $response["success"] = 0;
                $response["message"] = "Required field(s) is missing";
                echo json_encode($response);
            }
        } else {
            $response["success"] = 0;
            $response["message"] = "Something went wrong";
            echo json_encode($response);
        }
    }


    public function log_gen($data)
    {
        $logFile = 'logfile.txt';

        // Get the current date and time
        $currentTime = date('Y-m-d H:i:s');
        $logEntry = "$currentTime - $data";

        // Create or open the log file for writing
        $fileHandle = fopen($logFile, 'a');

        // Write the date into the log file
        fwrite($fileHandle, $logEntry . PHP_EOL);

        // Close the log file
        fclose($fileHandle);
    }

    public function userLoginJewellery()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            if (isset($_POST["username"]) and isset($_POST["password"])) {
                $pass = $_POST["password"];
                $userInfo = $this->model_mobileapi->JewelleryLogin($_POST["username"]);
                // print_r("$pass"."  $userInfo");
                if ($userInfo == $pass) {
                    $response["success"] = 1;
                    $response["message"] = "Password Matched";
                    echo json_encode($response);
                } else {
                    $response["success"] = 0;
                    $response["message"] = "Incorrect Password..";
                    $response["pass"] = $pass;
                    $response["userInfo "] = $userInfo;
                    echo json_encode($response);
                }
            } else {
                $response["success"] = 0;
                $response["message"] = "Required field(s) is missing";
                echo json_encode($response);
            }
        } else {
            $response["success"] = 0;
            $response["message"] = "Something went wrong";
            echo json_encode($response);
        }
    }


    public function getParty()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            if (isset($_POST['code']) or 1 == 1) {
                $username = $_POST['username'];
                $users = $this->model_mobileapi->getPartyWithBalance();

                //
                //   print_r($users);
                // if ($users != false) {
                //     $no_of_users = count($users);
                // } else {
                //     $no_of_users = 0;
                // }
                if (!empty($users)) {
                    $response["products"] = array();
                    foreach ($users as $key => $row) {
                        $product = array();
                        $product["name"] = $row["Name"];
                        $product["code"] = $row["Code"];
                        $product["balance"] = $row["Opening"];
                        $product["mobileno"] = $row["Ph"];
                        $product["cst_no"] = $row["CstNo"];
                        $product["gst_no"] = $row["TinNo"];
                        $product["party_type"] = $row["party_type"];
                        $product["address1"] = $row["Address1"];
                        $product["address2"] = $row["Address2"];
                        $product["emp"] = $row["emp"];
                        $product["outlet"] = $row["outlet"];
                        $product["credit_limit"] = $row["credit_limit"];
                        $product["location"] = $row["location"];
                        $product["second_name"] = $row["second_name"];
                        array_push($response["products"], $product);
                    }
                    $response["success"] = 1;
                    echo json_encode($response);
                } else {
                    $response["success"] = 0;
                    $response["message"] = "No party found";
                    echo json_encode($response);
                }
            } else {
                $response["success"] = 0;
                $response["message"] = "No party found";
                echo json_encode($response);
            }
        } else {
            $response["success"] = 0;
            $response["message"] = "Something went wrong";
            echo json_encode($response);
        }
    }



    public function getPurchase()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            if (isset($_POST['code']) or 1 == 1) {
                $username = $_POST['username'];
                //  $users = $this->model_mobileapi->getPurchaseFortakeStock($username);

                $data["success"] = 1;
                $data["response"] = $this->model_mobileapi->getPurchaseFortakeStock($username);
                echo json_encode($data);
            } else {
                $response["success"] = 0;
                $response["message"] = "No party found";
                echo json_encode($response);
            }
        } else {
            $response["success"] = 0;
            $response["message"] = "Something went wrong";
            echo json_encode($response);
        }
    }

    public function getPartyWiseSalesDtls()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $partyname = $_POST['partyname'];
            $item = $_POST['item'];
            $unit = $_POST['unit'];


            $data["success"] = 1;
            $data["response"] = $this->model_mobileapi->setpartywiseSales($partyname, $item, $unit);
            echo json_encode($data);
        } else {
            $response["success"] = 0;
            $response["message"] = "No party wise Data found";
            echo json_encode($response);
        }
    }



    public function getcompanydtls()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $data["success"] = 1;
            $data["response"] = $this->model_mobileapi->setcomapnydtls();
            echo json_encode($data);
        } else {
            $response["success"] = 0;
            $response["message"] = "Something went wrong";
            echo json_encode($response);
        }
    }


    public function getProducts()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            if (isset($_POST['code']) or 1 == 1) {
                $username = $_POST['username'];

                $product_fetching_typ = isset($_POST["product_fetching_typ"]) ? $_POST["product_fetching_typ"] : "NIL";
                if ($product_fetching_typ === "product_gd_wise") {
                    $users = $this->model_mobileapi->getProductsGodown($username);
                } else {
                    $users = $this->model_mobileapi->getProducts();
                }
                //     $users = $this->model_mobileapi->getProducts();
                $users1 = $this->model_mobileapi->getGodownStock($username);
                if ($users != false) {
                    $no_of_users = count($users);
                } else {
                    $no_of_users = 0;
                }
                if ($users1 != false) {
                    $no_of_users1 = count($users1);
                } else {
                    $no_of_users1 = 0;
                }
                if ($no_of_users > 0) {
                    $response["products"] = array();
                    for ($i = 0; $i < count($users); $i++) {
                        $product = array();
                        $product["itemname"] = $users[$i]["ItemNameTextField"];
                        $product["itemcode"] = $users[$i]["ItemC"];
                        $product["Cost"] = $users[$i]["Cost"];
                        $product["SecCostRate"] = $users[$i]["SecCostRate"];
                        $product["stock"] = $users[$i]["curr_stock"];
                        $product["base_rate"] = $users[$i]["Rate1"];
                        $product["sec_rate"] = $users[$i]["SecRetailRate"];
                        $product["base_unit"] = $users[$i]["Typ"];
                        $product["sec_unit"] = $users[$i]["SecUnit"];
                        $product["category"] = $users[$i]["Size"];
                        $product["tax"] = $users[$i]["Tax1"];
                        $product["img"] = "noimage";
                        $product["base_rate_retail"] = $users[$i]["Rate1"];
                        $product["base_rate_wholesale"] = $users[$i]["Rate2"];
                        $product["sec_rate_retail"] = $users[$i]["SecRetailRate"];
                        $product["sec_rate_wholesale"] = $users[$i]["SecRate2"] ?? "0";
                        $product["RatePerInch"] = $users[$i]["RatePerInch"];
                        $product["qty_in_pack"] = $users[$i]["Pack"];
                        $product["Company"] = $users[$i]["Company"];
                        $product["ArabicName"] = $users[$i]["ArabicName"];
                        $product["ThirdUnit"] = $users[$i]["ThirdUnit"];
                        $product["ThirdCost"] = $users[$i]["ThirdCost"];
                        $product["ThirdRate1"] = $users[$i]["ThirdRate1"];
                        $product["ThirdRate2"] = $users[$i]["ThirdRate2"] ?? "0";
                        $product["ThirdPack"] = $users[$i]["ThirdPack"];
                        $product["newitemcode"] = $users[$i]["NewItemCode"];
                        $product["secbarcode"] = $users[$i]["SecBarcode"] ?? "0";
                        $product["thirdbarcode"] = $users[$i]["ThirdBarcode"] ?? "0";
                        $product["CostRs"] = $users[$i]["CostRs"];

                        array_push($response["products"], $product);
                    }
                    if ($no_of_users1 > 0) {
                        $response["godown"] = array();
                        for ($j = 0; $j < count($users1); $j++) {
                            $product1 = array();
                            $product1["itemname"] = $users1[$j]["Item"];
                            $product1["stock"] = $users1[$j]["qty"];
                            $product1["godown"] = $users1[$j]["godown"];
                            $product1["cst"] = $users1[$j]["cst"];
                            $product1["it_unit"] = $users1[$j]["it_unit"];
                            $product1["it_pack"] = $users1[$j]["it_pack"];
                            array_push($response["godown"], $product1);
                            $response["success_godown"] = 1;
                        }
                    } else {
                        $response["success_godown"] = 0;
                    }
                    $response["success"] = 1;
                    echo json_encode($response);
                } else {
                    $response["success"] = 0;
                    $response["message"] = "No Products found";
                    echo json_encode($response);
                }
            } else {
                $response["success"] = "0";
                $response["message"] = "Required field(s) is missing";
                echo json_encode($response);
            }
        } else {
            $response["success"] = "0";
            $response["message"] = "Something went wrong";
            echo json_encode($response);
        }
    }

    public function getPrevilage()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            if (isset($_POST["username"])) {
                $users = $this->model_mobileapi->getUserPrevilage($_POST['username']);
                if ($users != false) {
                    $no_of_users = count($users);
                } else {
                    $no_of_users = 0;
                }
                if ($no_of_users > 0) {
                    $response["privilage"] = array();
                    for ($i = 0; $i < count($users); $i++) {
                        $privilage = array();
                        $privilage["sales"] = $users[$i]["sales"];
                        $privilage["purchase"] = $users[$i]["purchase"];
                        $privilage["sales_ret"] = $users[$i]["sales_ret"];
                        $privilage["purch_ret"] = $users[$i]["purch_ret"];
                        $privilage["salesitem"] = $users[$i]["salesitem"];
                        $privilage["ledger"] = $users[$i]["ledger"];
                        $privilage["warehouse"] = $users[$i]["warehouse"];
                        $privilage["waretrans"] = $users[$i]["waretrans"];
                        $privilage["reports"] = $users[$i]["reports"];
                        $privilage["receipt"] = $users[$i]["receipt"];
                        $privilage["reports_sec"] = $users[$i]["reports_sec"];
                        array_push($response["privilage"], $privilage);
                    }
                    $response["success"] = 1;
                    echo json_encode($response);
                } else {
                    $response["success"] = 0;
                    $response["message"] = "No Privilage found";
                    echo json_encode($response);
                }
            } else {
                $response["success"] = 0;
                $response["message"] = "Required field(s) is missing";
                echo json_encode($response);
            }
        } else {
            $response["success"] = 0;
            $response["message"] = "Something went wrong";
            echo json_encode($response);
        }
    }


    public function getMaxValue()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            if (isset($_POST["username"])) {
                $users = $this->model_mobileapi->getUserPrevilage($_POST['username']);
                if ($users != false) {
                    $no_of_users = count($users);
                } else {
                    $no_of_users = 0;
                }
                if ($no_of_users > 0) {
                    $response["privilage"] = array();
                    for ($i = 0; $i < count($users); $i++) {
                        $privilage = array();
                        $privilage["sales"] = $users[$i]["sales"];
                        $privilage["purchase"] = $users[$i]["purchase"];
                        $privilage["sales_ret"] = $users[$i]["sales_ret"];
                        $privilage["purch_ret"] = $users[$i]["purch_ret"];
                        $privilage["salesitem"] = $users[$i]["salesitem"];
                        $privilage["ledger"] = $users[$i]["ledger"];
                        $privilage["warehouse"] = $users[$i]["warehouse"];
                        $privilage["waretrans"] = $users[$i]["waretrans"];
                        $privilage["reports"] = $users[$i]["reports"];
                        $privilage["receipt"] = $users[$i]["receipt"];
                        $privilage["reports_sec"] = $users[$i]["reports_sec"];
                        array_push($response["privilage"], $privilage);
                    }
                    $response["success"] = 1;
                    echo json_encode($response);
                } else {
                    $response["success"] = 0;
                    $response["message"] = "No Privilage found";
                    echo json_encode($response);
                }
            } else {
                $response["success"] = 0;
                $response["message"] = "Required field(s) is missing";
                echo json_encode($response);
            }
        } else {
            $response["success"] = 0;
            $response["message"] = "Something went wrong";
            echo json_encode($response);
        }
    }

    public function getEmployeeName()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            if (isset($_POST['code'])) {
                $users = $this->model_mobileapi->getEmployeeName();
                if ($users != false) {
                    $no_of_users = count($users);
                } else {
                    $no_of_users = 0;
                }
                if ($no_of_users > 0) {
                    $response["products"] = array();
                    for ($i = 0; $i < count($users); $i++) {
                        $product = array();
                        $product["empName"] = $users[$i]["Name"];
                        array_push($response["products"], $product);
                    }
                    $response["success"] = 1;
                    echo json_encode($response);
                } else {
                    $response["success"] = 0;
                    $response["message"] = "No data found";
                    echo json_encode($response);
                }
            } else {
                $response["success"] = 0;
                $response["message"] = "Required field(s) is missing";
                echo json_encode($response);
            }
        } else {
            $response["success"] = 0;
            $response["message"] = "Something went wrong";
            echo json_encode($response);
        }
    }

    public function getEmployeeLocationStatus()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            if (isset($_POST['code']) and isset($_POST['date1']) and isset($_POST['date2']) and isset($_POST['employeeName'])) {
                $date1 = $_POST['date1'];
                $date2 = $_POST['date2'];
                $employeeName = $_POST['employeeName'];
                $users = $this->model_mobileapi->getLocatioInfo($date1, $date2, $employeeName);
                if ($users != false) {
                    $no_of_users = count($users);
                } else {
                    $no_of_users = 0;
                }
                if ($no_of_users > 0) {
                    $response["products"] = array();
                    for ($i = 0; $i < count($users); $i++) {
                        $product = array();
                        $product["latitude"] = $users[$i]["latitude"];
                        $product["longitude"] = $users[$i]["longitude"];
                        array_push($response["products"], $product);
                    }
                    $response["success"] = 1;
                    echo json_encode($response);
                } else {
                    $response["success"] = 0;
                    $response["message"] = "No party found";
                    echo json_encode($response);
                }
            } else {
                $response["success"] = 0;
                $response["message"] = "Required field(s) is missing";
                echo json_encode($response);
            }
        } else {
            $response["success"] = 0;
            $response["message"] = "Something went wrong";
            echo json_encode($response);
        }
    }

    public function getReports()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $reportType = isset($_POST["reportType"]) ? $_POST["reportType"] : "";
            $empName = isset($_POST["empName"]) ? $_POST["empName"] : "";
            $partyName = isset($_POST["partyName"]) ? $_POST["partyName"] : "";
            $date1 = isset($_POST["date1"]) ? $_POST["date1"] : "";
            $date2 = isset($_POST["date2"]) ? $_POST["date2"] : "";
            $billNumber = isset($_POST["billNo"]) ? $_POST["billNo"] : "";
            $itemName = isset($_POST["itemName"]) ? $_POST["itemName"] : "";
            $barcode = isset($_POST["brcode"]) ? $_POST["brcode"] : "";
            $barcode2 = isset($_POST["datas"]) ? $_POST["datas"] : "";
            $br = json_decode($barcode2);

            $data = array();
            $data["response"] = array();
            if ($reportType === "employeeWiseSalesReportEdit") {
                $data["success"] = 1;
                $data["response"] = $this->model_mobileapi->employeeWiseSalesReportEdit($billNumber, $empName);
                echo json_encode($data);
            } else if ($reportType === "employeeWiseSalesReportEditMaster") {
                $data["success"] = 1;
                $data["response"] = $this->model_mobileapi->employeeWiseSalesReportEditMaster($billNumber);
                echo json_encode($data);
            } else if ($reportType === "updateDebitReport") {
                $data["success"] = 1;
                $data["response"] = $this->model_mobileapi->updateDebitReport($billNumber, $empName);
                echo json_encode($data);
            } else if ($reportType === "employeeWiseSalesReportEditCollection") {
                $data["success"] = 1;
                $data["response"] = $this->model_mobileapi->employeeWiseSalesReportEditCollection($billNumber);
                echo json_encode($data);
            } else if ($reportType === "employeeWiseSalesReport") {
                $data["success"] = 1;
                $data["response"] = $this->model_mobileapi->employeeWiseSalesReport($date1, $date2, $empName);
                echo json_encode($data);
            } else if ($reportType === "collectionReportEmployeeWise") {
                $data["success"] = 1;
                $data["response"] = $this->model_mobileapi->collectionReportEmployeeWise($date1, $date2, $empName);
                echo json_encode($data);
            } else if ($reportType === "collectionReport") {
                $data["success"] = 1;
                $data["response"] = $this->model_mobileapi->collectionReport($date1, $date2);
                echo json_encode($data);
            } else if ($reportType === "expenseReport") {
                $data["success"] = 1;
                $data["response"] = $this->model_mobileapi->expenseReport($date1, $date2, $empName);
                echo json_encode($data);
            } else if ($reportType === "paymentReport") {
                $data["success"] = 1;
                $data["response"] = $this->model_mobileapi->paymentReport($date1, $date2, $empName);
                echo json_encode($data);
            } else if ($reportType === "openingReport") {
                $data["success"] = 1;
                $data["response"] = $this->model_mobileapi->openingReport($date1);
                echo json_encode($data);
            } else if ($reportType === "cashBookReport") {
                $data["success"] = 1;
                $data["response"] = $this->model_mobileapi->cashBookReport($date1, $date2);
                echo json_encode($data);
            } else if ($reportType === "purchaseReport") {
                $data["success"] = 1;
                $data["response"] = $this->model_mobileapi->purchaseReport($date1, $date2, $empName);
                echo json_encode($data);
            } else if ($reportType === "salesReport") {
                $data["success"] = 1;
                $data["response"] = $this->model_mobileapi->salesReport($date1, $date2);
                echo json_encode($data);
            } else if ($reportType === "orderReport") {
                $data["success"] = 1;
                $data["response"] = $this->model_mobileapi->orderReport($date1, $date2);
                echo json_encode($data);
            } else if ($reportType === "ledger") {
                $data["success"] = 1;
                $data["response"] = $this->model_mobileapi->ledger($date1, $date2, $partyName);
                echo json_encode($data);
            } else if ($reportType === "currentStockReport") {
                $data["success"] = 1;
                $data["response"] = $this->model_mobileapi->currentStockReport($_POST["empName"]);
                echo json_encode($data);
            } else if ($reportType === "currentStockReportEMPWise") {
                $data["success"] = 1;
                $data["response"] = $this->model_mobileapi->currentStockReportEMPWise($_POST["empName"]);
                echo json_encode($data);
            } else if ($reportType === "currentStockReportSalesItem") {
                $data["success"] = 1;
                $data["response"] = $this->model_mobileapi->currentStockReportSalesItem($_POST["empName"]);
                echo json_encode($data);
            } else if ($reportType === "salesReportBillNoWise") {
                $data["success"] = 1;
                $data["response"] = $this->model_mobileapi->getSalesDetailsForBillno($billNumber);
                echo json_encode($data);
            } else if ($reportType === "itemwiseSalesReport") {
                $data["success"] = 1;
                $data["response"] = $this->model_mobileapi->getItemWiseSalesReport($date1, $date2);
                echo json_encode($data);
            } else if ($reportType === "CashBookData") {
                $data["success"] = 1;
                $data["response"] = $this->model_mobileapi->CashBookData($empName, $date1, $date2);
                echo json_encode($data);
            } else if ($reportType === "CashBookDataOpening") {
                $data["success"] = 1;
                $data["response"] = $this->model_mobileapi->CashBookDataOpening($empName, $date1, $date2);
                echo json_encode($data);
            } else if ($reportType === "orderReportEMPWise") {
                $data["success"] = 1;
                $data["response"] = $this->model_mobileapi->employeeWiseorderReport($date1, $date2, $empName);
                echo json_encode($data);
            } else if ($reportType === "auditingReport") {
                $data["success"] = 1;
                $data["response"] = $this->model_mobileapi->employeeWiseAuditingReport($empName);
                echo json_encode($data);
            } else if ($reportType === "intransReport") {
                $data["success"] = 1;
                $data["response"] = $this->model_mobileapi->intransReport($date1, $date2);
                echo json_encode($data);
            } else if ($reportType === "employeeWiseSalesReportBtoc") {
                $data["success"] = 1;
                $data["response"] = $this->model_mobileapi->employeeWiseSalesReportBtoc($date1, $date2, $empName);
                echo json_encode($data);
            } else if ($reportType === "intransReportEdit") {
                $data["success"] = 1;
                $data["response"] = $this->model_mobileapi->intransReportEdit($billNumber, $partyName);
                echo json_encode($data);
            } else if ($reportType === "intransLedgerReport") {
                $data["success"] = 1;
                $data["response"] = $this->model_mobileapi->intransLedgerReport($date1, $date2, $partyName);
                echo json_encode($data);
            } else if ($reportType === "cashparty") {
                $data["success"] = 1;
                $data["response"] = $this->model_mobileapi->getCashparty();
                echo json_encode($data);
            } else if ($reportType === "SalesManWiseReport") {
                $data["success"] = 1;
                $data["response"] = $this->model_mobileapi->SaleMansReport($date1, $date2, $empName);
                echo json_encode($data);
            } else if ($reportType === "EnquiryReport") {
                $data["success"] = 1;
                $data["response"] = $this->model_mobileapi->EnquiryReport($date1, $date2, $empName);
                echo json_encode($data);
            } else if ($reportType === "getBarcodeStock") {
                $data["success"] = 1;
                $data["response"] = $this->model_mobileapi->getBarcodeStock($barcode, $empName);
                echo json_encode($data);
            } else if ($reportType === "getTakeStockData") {
                $data["success"] = 1;
                $data["response"] = $this->model_mobileapi->getBarcodeStockForTakeStock($barcode2);
                // $data["success2"] = $barcode2;
                echo json_encode($data);
            } else if ($reportType === "getEnquiryDescription") {
                $data["success"] = 1;
                $data["response"] = $this->model_mobileapi->getEnquiryDescription($itemName, $billNumber);
                echo json_encode($data);
            } else if ($reportType === "getBarcode") {
                if ($data["response"] = $this->model_mobileapi->getPurchaseBarcode($barcode)) {
                    $data["success"] = 1;
                    $data["message"] = 1;
                    echo json_encode($data);
                } else if ($data["response"] = $this->model_mobileapi->getBaseBarcode($barcode)) {
                    $data["success"] = 1;
                    $data["message"] = 2;
                    echo json_encode($data);
                } else if ($data["response"] = $this->model_mobileapi->getSecBarcode($barcode)) {
                    $data["success"] = 1;
                    $data["message"] = 3;
                    echo json_encode($data);
                } else if ($data["response"] = $this->model_mobileapi->getThirdBarcode($barcode)) {
                    $data["success"] = 1;
                    $data["message"] = 4;
                    echo json_encode($data);
                } else if ($reportType === "getBarcode") {
                    if ($data["response"] = $this->model_mobileapi->getPurchaseBarcode($barcode)) {
                        $data["success"] = 1;
                        $data["message"] = 1;
                        echo json_encode($data);
                    } else if ($data["response"] = $this->model_mobileapi->getBaseBarcode($barcode)) {
                        $data["success"] = 1;
                        $data["message"] = 2;
                        echo json_encode($data);
                    } else if ($data["response"] = $this->model_mobileapi->getSecBarcode($barcode)) {
                        $data["success"] = 1;
                        $data["message"] = 3;
                        echo json_encode($data);
                    } else if ($data["response"] = $this->model_mobileapi->getThirdBarcode($barcode)) {
                        $data["success"] = 1;
                        $data["message"] = 4;
                        echo json_encode($data);
                    } else {
                        $data["success"] = 0;
                        $data["message"] = "no Barcode found";
                        echo json_encode($data);
                    }
                } else {
                    $data["success"] = 0;
                    $data["message"] = "no Barcode found";
                    echo json_encode($data);
                }
            } else if ($reportType === "getSalesReturnReport") {
                $data["success"] = 1;
                $data["response"] = $this->model_mobileapi->salesReturnReport($date1, $date2, $empName);
                echo json_encode($data);
            } else if ($reportType === "salesreturntoedit") {
                $data["success"] = 1;
                $data["response"] = $this->model_mobileapi->employeeWiseSalesReturnEdit($billNumber);
                echo json_encode($data);
            } else if ($reportType === "employeeWiseSalesReportEditSRMasterdetails") {
                $data["success"] = 1;
                $data["response"] = $this->model_mobileapi->employeeWiseSalesReturnEditMaster($billNumber);
                echo json_encode($data);
            } else if ($reportType === "employeeWiseSalesReturnEditCollection") {
                $data["success"] = 1;
                $data["response"] = $this->model_mobileapi->employeeWiseSalesReturnEditCollection($billNumber);
                echo json_encode($data);
            } else if ($reportType === "salesReportBtoc") {
                $data["success"] = 1;
                $data["response"] = $this->model_mobileapi->salesReportBtoc($date1, $date2);
                echo json_encode($data);
            } else {
                $response["success"] = $reportType;
                $response["message"] = "No value found";
                echo json_encode($response);
            }
        } else {
            $response["success"] = 0;
            $response["message"] = "Something went wrong";
            echo json_encode($response);
        }
    }



    public function getReports2()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            // Initialize response data
            $data = array();
            $data["response"] = array();

            // Retrieve POST parameters
            $reportType = isset($_POST["reportType"]) ? $_POST["reportType"] : "";
            $empName = isset($_POST["empName"]) ? $_POST["empName"] : "";
            $partyName = isset($_POST["partyName"]) ? $_POST["partyName"] : "";
            $item = isset($_POST["item"]) ? $_POST["item"] : "";
            $date1 = isset($_POST["date1"]) ? $_POST["date1"] : "";
            $date2 = isset($_POST["date2"]) ? $_POST["date2"] : "";
            $billNumber = isset($_POST["billNo"]) ? $_POST["billNo"] : "";
            $bill_typ = isset($_POST["BillType"]) ? $_POST["BillType"] : "";
            $bill_form = isset($_POST["bill_form"]) ? $_POST["bill_form"] : "";
            // Handle different report types
            switch ($reportType) {
                case "SalesHoldData":
                    $data["success"] = 1;
                    $data["response"] = $this->model_mobileapi->salesHolReport($date1, $date2);
                    break;

                case "getotherstate":
                    $data["success"] = 1;
                    $data["response"] = $this->model_mobileapi->getothertableData();
                    break;

                case "getitem_all":
                    $data["success"] = 1;
                    $data["response"] = $this->model_mobileapi->Item_Report($date1, $date2, $empName);
                    break;

                case "getitem_wise":
                    $data["success"] = 1;
                    $data["response"] = $this->model_mobileapi->Item_wise_Data($date1, $date2, $item, $empName);
                    break;

                case "LoadSalesData":
                    $data["success"] = 1;
                    $data["response"] = $this->model_mobileapi->SalesData($billNumber, $bill_typ, $empName);
                    break;

                case "Profit_Loss":
                    $data["success"] = 1;
                    $data["response"] = $this->model_mobileapi->setpnlrpt($date1, $date2, $empName);
                    break;


                case "get_status_table":
                    $data["success"] = 1;
                    $data["response"] = $this->model_mobileapi->get_status_table_Data();
                    break;

                case "Load_order_items":
                    $data["success"] = 1;
                    $data["response"] = $this->model_mobileapi->get_order_items($billNumber, $bill_typ, $empName);
                    break;

                case "b2c_print_edit":
                    $data["success"] = 1;
                    $data["response"] = $this->model_mobileapi->get_b2c_print_items($billNumber, $bill_typ, $empName);
                    break;

                case "zatca_b2c_print":
                    $data["success"] = 1;
                    $data["response"] = $this->model_mobileapi->get_b2c_zatca_print_items($billNumber, $empName, $bill_form);
                    break;

                case "zatca_b2b_print":
                    $data["success"] = 1;
                    $data["response"] = $this->model_mobileapi->get_b2b_zatca_print_items($billNumber, $empName, $bill_form);
                    break;

                case "get_srt_print_items_emp":
                    $data["success"] = 1;
                    $data["response"] = $this->model_mobileapi->get_srt_print($billNumber, $empName);
                    break;

                case "zatca_srt_print":
                    $data["success"] = 1;
                    $data["response"] = $this->model_mobileapi->get_srt_zatca_print($billNumber, $empName, $bill_form);
                    break;

                case "purchase_return_report":
                    $data["success"] = 1;
                    $data["response"] = $this->model_mobileapi->purchaseReturnReport($date1, $date2, $empName);
                    break;

                default:
                    // Handle unrecognized report type
                    $data["success"] = 0;
                    $data["message"] = "Invalid report type: " . htmlspecialchars($reportType);
                    echo json_encode($data);
                    return; // Stop execution
            }

            // On success, prepare the response
            if (empty($data["response"])) {
                $data["success"] = 0;
                $data["message"] = "No data found";
            } else {
                $data["success"] = 1;
                $data["message"] = "Data retrieved successfully";
            }

            // Return the response as JSON
            echo json_encode($data);
        } else {
            // Handle invalid request method
            $response = array("success" => 0, "message" => "Invalid request method");
            echo json_encode($response);
        }
    }



    public function SaveEnquiry()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            if (isset($_POST['code']) and isset($_POST["enquiry_data"])) {
                $EnquiryData = $_POST["enquiry_data"];
                $data = json_decode($EnquiryData, true);
                $a = array();
                $b = array();
                //   $data = $_POST["enquiry_data"];

                // print_r($data);
                $billNo = $this->model_mobileapi->getEnqNo();

                for ($i = 0; $i < count($data); $i++) { // count($data)
                    // $bin = base64_decode($data[$i]["image"]);
                    // $im = imageCreateFromString($bin);
                    //   $a = $data[$i]["image"];
                    //  $im=$this->base64_to_jpeg($a,"PNG");

                    // print_r($a);
                    //   list($type, $datas) = explode(';', $a);
                    //   list(, $datas)      = explode(',', $datas);
                    //   print_r($datas);
                    //   $datas = base64_decode($a);
                    //  print_r($datas);


                    //               $imageData = base64_decode($a);
                    // $source = imagecreatefromstring($imageData);
                    //   print_r($source);
                    // print_r('here '.$im);
                    //  $SliderimgData=$this->do_image_upload($datas,"gif|jpg|png|jpeg");
                    // print_r($SliderimgData);
                    //   $imagePath = $SliderimgData["path"];
                    // print_r($imagePath);

                    $res = $this->model_mobileapi->storeEnquiry($billNo, $data[$i]["product"], $data[$i]["enq_date"], $data[$i]["description"], $data[$i]["image"], $data[$i]["diamondwt"], $data[$i]["grosswt"], $data[$i]["qty"], $data[$i]["counter_name"]);
                    if ($res) {


                        //  $count++;
                        //   $b["bill_no"] = $billNo;
                        $b["success"] = '1';
                        // $b["status"] = 'uploaded';
                        // $b["previlage"] = '1';
                        // $b["count"] = $cnt;
                        array_push($a, $b);
                    } else {
                        //  $b["bill_no"] = $billNo;
                        $b["success"] = '0';
                        // $b["status"] = 'pending';
                        // $b["previlage"] = '1';
                        //     $b["count"] = $cnt;
                        array_push($a, $b);
                    }
                    echo json_encode($a);
                }
            } else {
                $response["success"] = 0;
                $response["message"] = "Something went wrong";
                echo json_encode($response);
            }
        } else {
            $response["success"] = 0;
            $response["message"] = "Something went wrong";
            echo json_encode($response);
        }
    }



    public function do_image_upload($fileInputFieldName, $type)
    { //$type gif|jpg|png
        $uploadfolder = date("Y-m");
        $uploadpath = 'jr_files' . DIRECTORY_SEPARATOR;
        if (!is_dir($uploadpath . $uploadfolder)) {
            // creating month-year folder to upload item  image 
            mkdir($uploadpath . $uploadfolder, 0777, TRUE);
        }
        $fullPath = $uploadpath . DIRECTORY_SEPARATOR . $uploadfolder;

        $config['upload_path'] = $fullPath;
        $config['allowed_types'] = $type;
        $config['max_size'] = 5024;
        $config['max_width'] = 5024;
        $config['max_height'] = 5024;
        $config['overwrite'] = TRUE;
        $this->load->library('upload', $config);

        if (!$this->upload->do_upload($fileInputFieldName)) {
            $error = array('error' => $this->upload->display_errors());
            //            $this->load->view('upload_form', $error);
            print_r($error);
            return 0;
        } else {
            $data = array('upload_data' => $this->upload->data());
            $fileDetails['path'] = DIRECTORY_SEPARATOR . "jr_files" . DIRECTORY_SEPARATOR . $uploadfolder . DIRECTORY_SEPARATOR . $data['upload_data']['file_name'];
            $fileDetails['extension'] = $file_ext = pathinfo($fileDetails['path'], PATHINFO_EXTENSION);
            return $fileDetails;
        }
    }

    function base64_to_jpeg($base64_string, $output_file)
    {
        // open the output file for writing
        $ifp = fopen($output_file, 'wb');

        // split the string on commas
        // $data[ 0 ] == "data:image/png;base64"
        // $data[ 1 ] == <actual base64 string>
        $data = explode(',', $base64_string);

        // we could add validation here with ensuring count( $data ) > 1
        fwrite($ifp, base64_decode($data[1]));

        // clean up the file resource
        fclose($ifp);

        return $output_file;
    }

    public function saveInvoiceOld()
    { //saveInvoice
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            if (isset($_POST['code']) and isset($_POST["salesBillItems"]) and isset($_POST["salesBillMasterDetails"])) {
                $salesBillItemsData = $_POST["salesBillItems"];
                $masterDetailsData = $_POST["salesBillMasterDetails"];
                $salesBillCollectionBank = $_POST["salesBillCollectionBank"];
                //    if (get_magic_quotes_gpc()) {
                //        $salesBillItemsData = stripslashes($salesBillItemsData);
                //        $masterDetailsData = stripslashes($masterDetailsData);
                //    }

                $data = json_decode($salesBillItemsData, true);
                $masterDetails = json_decode($masterDetailsData, true);
                $bankData = json_decode($salesBillCollectionBank, true);
                $cnt = 0;
                if ($_POST['code'] == 1) {
                    $previlage = $this->model_mobileapi->getSynPrevilage($_POST['user']);
                    if ($previlage == 1) {
                        $a = array();
                        $b = array();
                        $count = 0;
                        for ($z = 0; $z < count($masterDetails); $z++) {
                            $cnt++;
                            $billNo = $this->model_mobileapi->getBillNo();
                            $sino = $this->model_mobileapi->getSiNo();
                            $masterDetails[$z]["BillNo"] = $billNo;
                            $masterDetails[$z]["sino"] = $sino;

                            //
                            if ($masterDetails[$z]["advance"] == 0) {
                                $masterDetails[$z]["sino"] = 0;
                            }
                            //
                            $this->model_mobileapi->deleteFromMasterDetailsByBillNo($masterDetails[$z]["local_app_user_entry_id"], $billNo);
                            $this->model_mobileapi->getQuery("MasterDetails", $masterDetails[$z]);
                            $sino = $this->model_mobileapi->getSiNo();
                            for ($i = 0; $i < count($bankData); $i++) {
                                if ($bankData[$i]["local_app_user"] != $masterDetails[$z]["local_app_user_entry_id"]) {
                                    continue;
                                } else {
                                    $this->model_mobileapi->saveCollectionBank($billNo, $bankData[$z]["TransactionType"], $sino, $bankData[$z]["Date"], $bankData[$z]["PartyName"], $bankData[$z]["NetTotal"], $bankData[$z]["Type"], $bankData[$z]["CashFlow"], $bankData[$z]["local_app_user"], $bankData[$z]["Narration"]);
                                }
                            }

                            for ($i = 0; $i < count($data); $i++) {
                                if ($data[$i]["local_app_user_entry_id"] != $masterDetails[$z]["local_app_user_entry_id"]) {
                                    continue;
                                } else {
                                    $res = $this->model_mobileapi->storeUser($data[$i]["itemname"], $data[$i]["price"], $data[$i]["qty"], $data[$i]["unit"], $data[$i]["party"], $data[$i]["godown"], $data[$i]["employee"], $data[$i]["date1"], $data[$i]["invno"], $data[$i]["local_app_user_entry_id"], $billNo, $data[$i]["serial_no"], $data[$i]["taxAmount"], $data[$i]["taxPercentage"], $data[$i]["itemcode"], $data[$i]["qty_in_pack"], $data[$i]["cost"], $data[$i]["disc"], $data[$i]["sqft"], $data[$i]["taxtype"], $data[$i]["NetV"]);
                                    if ($res) {
                                        $count++;
                                        $b["bill_no"] = $billNo;
                                        $b["id"] = $data[$i]["local_app_user_entry_id"];
                                        $b["status"] = 'uploaded';
                                        $b["previlage"] = '1';
                                        $b["count"] = $cnt;
                                        array_push($a, $b);
                                    } else {

                                        $this->model_mobileapi->deleteFromMasterDetailsToSalesBillDelete($billNo, $_POST['user']);
                                        $this->model_mobileapi->deleteFromCollectionToSaleBillDelete($billNo);
                                        $b["bill_no"] = $billNo;
                                        $b["id"] = $data[$i]["local_app_user_entry_id"];
                                        $b["status"] = 'pending';
                                        $b["previlage"] = '1';
                                        $b["count"] = $cnt;
                                        array_push($a, $b);
                                        session_start();
                                        $this->log_gen($_SESSION['error']);
                                    }
                                }
                            }
                        }
                        $this->model_mobileapi->updateSyncActivationStatus($_POST['user']);
                    } else {
                        $a = array();
                        $b = array();
                        $b["bill_no"] = '0';
                        $b["id"] = '0';
                        $b["status"] = 'Update user sync sales bill Privilage !!';
                        $b["previlage"] = '-1';
                        array_push($a, $b);
                    }
                    echo json_encode($a);
                } else {
                    $a = array();
                    $b = array();
                    for ($z = 0; $z < count($masterDetails); $z++) {
                        $cnt++;
                        $billNo = $this->model_mobileapi->getBillNo();
                        $sino = $this->model_mobileapi->getSiNo();
                        $masterDetails[$z]["BillNo"] = $billNo;
                        $masterDetails[$z]["sino"] = $sino;
                        if ($masterDetails[$z]["advance"] == 0) {
                            $masterDetails[$z]["sino"] = 0;
                        }
                        $this->model_mobileapi->deleteFromMasterDetailsByBillNo($masterDetails[$z]["local_app_user_entry_id"], $billNo);
                        $this->model_mobileapi->getQuery("MasterDetails", $masterDetails[$z]);
                        // $cnt =  $this->model_mobileapi->getQuerymasterdetails("MasterDetails", $masterDetails[$z]);
                        $sino = $this->model_mobileapi->getSiNo();
                        for ($i = 0; $i < count($bankData); $i++) {
                            if ($bankData[$i]["local_app_user"] != $masterDetails[$z]["local_app_user_entry_id"]) {
                                continue;
                            } else {
                                $this->model_mobileapi->saveCollectionBank($billNo, $bankData[$z]["TransactionType"], $sino, $bankData[$z]["Date"], $bankData[$z]["PartyName"], $bankData[$z]["NetTotal"], $bankData[$z]["Type"], $bankData[$z]["CashFlow"], $bankData[$z]["local_app_user"], $bankData[$z]["Narration"]);
                            }
                        }

                        for ($i = 0; $i < count($data); $i++) {
                            if ($data[$i]["local_app_user_entry_id"] != $masterDetails[$z]["local_app_user_entry_id"]) {
                                continue;
                            } else {
                                try {
                                    $res = $this->model_mobileapi->storeUser($data[$i]["itemname"], $data[$i]["price"], $data[$i]["qty"], $data[$i]["unit"], $data[$i]["party"], $data[$i]["godown"], $data[$i]["employee"], $data[$i]["date1"], $data[$i]["invno"], $data[$i]["local_app_user_entry_id"], $billNo, $data[$i]["serial_no"], $data[$i]["taxAmount"], $data[$i]["taxPercentage"], $data[$i]["itemcode"], $data[$i]["qty_in_pack"], $data[$i]["cost"], $data[$i]["disc"], $data[$i]["sqft"], $data[$i]["taxtype"], $data[$i]["NetV"]);
                                } catch (Exception $e) {
                                    print_r('-------------------------------------');
                                }
                                // $res = $this->model_mobileapi->storeUser($data[$i]["itemname"], $data[$i]["price"], $data[$i]["qty"], $data[$i]["unit"], $data[$i]["party"], $data[$i]["godown"], $data[$i]["employee"], $data[$i]["date1"], $data[$i]["invno"], $data[$i]["local_app_user_entry_id"], $billNo, $data[$i]["serial_no"], $data[$i]["taxAmount"], $data[$i]["taxPercentage"], $data[$i]["itemcode"], $data[$i]["qty_in_pack"], $data[$i]["cost"], $data[$i]["disc"], $data[$i]["sqft"],$data[$i]["taxtype"]);
                                if ($res === true) {
                                    $b["bill_no"] = $billNo;
                                    $b["id"] = $data[$i]["local_app_user_entry_id"];
                                    $b["status"] = 'uploaded';
                                    $b["previlage"] = '1';
                                    $b["count"] = $cnt;
                                    $b["count"] = $cnt;
                                    array_push($a, $b);
                                } else {
                                    $this->model_mobileapi->deleteFromMasterDetailsToSalesBillDelete($billNo, $_POST['user']);
                                    $this->model_mobileapi->deleteFromCollectionToSaleBillDelete($billNo);
                                    $b["bill_no"] = $billNo;
                                    $b["id"] = $data[$i]["local_app_user_entry_id"];
                                    $b["status"] = 'pending';
                                    $b["previlage"] = '1';
                                    $b["count"] = $cnt;
                                    $b["err"] = error_get_last();
                                    array_push($a, $b);
                                }
                            }
                        }
                    }

                    echo json_encode($a);
                }
            } else {
                $response["success"] = 0;
                $response["message"] = "Required field(s) is missing";
                echo json_encode($response);
            }
        } else {
            $response["success"] = 0;
            $response["message"] = "Something went wrong";
            echo json_encode($response);
        }
    }

    public function savetest()
    {
        $masterDetailsData = $_POST["salesBillMasterDetails"];
        $masterDetails = json_decode($masterDetailsData, true);
        $this->model_mobileapi->deleteFromMasterDetailsByBillNo($masterDetails[$z]["local_app_user_entry_id"], 118);
    }

    //-------------------------------------------------------------------------------
    public function saveInvoice2() //old some issues in zatca uploding to change this 23-10-25
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            if (isset($_POST['code']) and isset($_POST["salesBillItems"]) and isset($_POST["salesBillMasterDetails"])) {
                try {
                    // Start the transaction
                    $this->model_mobileapi->beginTransaction();

                    $salesBillItemsData = $_POST["salesBillItems"];
                    $masterDetailsData = $_POST["salesBillMasterDetails"];
                    $salesBillCollectionBank = $_POST["salesBillCollectionBank"];
                    $prefix = isset($_POST['prefix']) ? $_POST['prefix'] : "";

                    $data = json_decode($salesBillItemsData, true);
                    $masterDetails = json_decode($masterDetailsData, true);
                    $bankData = json_decode($salesBillCollectionBank, true);

                    $cnt = 0;
                    //   if ($_POST['code'] == 1) {
                    //   $previlage = $this->model_mobileapi->getSynPrevilage($_POST['user']);
                    //  if ($previlage == 1) {

                    $a = array();
                    $b = array();
                    $count = 0;
                    $fin_year = $this->model_mobileapi->getFinYear();
                    for ($z = 0; $z < count($masterDetails); $z++) {
                        $cnt++;
                        $billNo = $this->model_mobileapi->getBillNo();
                        $sino = $this->model_mobileapi->getSiNo();
                        $TaxBillNo = $this->model_mobileapi->getB2B_TAXBillNo();

                        $masterDetails[$z]["BillNo"] = $billNo;
                        $masterDetails[$z]["sino"] = $sino;
                        $masterDetails[$z]["fin_year"] = $fin_year;
                        $masterDetails[$z]["TaxBillNo"] = $TaxBillNo;


                        if ($prefix != "") {
                            $masterDetails[$z]["NewBillNo"] = $prefix . $billNo;
                        }

                        if ($masterDetails[$z]["advance"] == 0) {
                            $masterDetails[$z]["sino"] = 0;
                        }
                        $this->model_mobileapi->deleteFromMasterDetailsByBillNo($masterDetails[$z]["local_app_user_entry_id"], $billNo);

                        // $this->model_mobileapi->deleteFromMasterDetailsByBillNo('19-07-2024 08:26:25MANOOS', '6714');
                        // ... (your existing code)

                        // Execute the first query within the transaction
                        $this->model_mobileapi->getQuery("MasterDetails", $masterDetails[$z]);

                        $stat = isset($_POST['stat']) ? $_POST['stat'] : 0;   // ZATCA_EINV_STAT

                        if ($stat == 1) {
                            if (!isset($_POST["zatca_einv_stat_items"])) {
                                die("ZATCA data not provided.");
                            }

                            $zatca_bill_dtls = $_POST["zatca_einv_stat_items"];
                            $zatca_datas = json_decode($zatca_bill_dtls, true);

                            if (json_last_error() !== JSON_ERROR_NONE) {
                                die("Invalid JSON in zatca_einv_stat_items: " . json_last_error_msg());
                            }

                            if (!empty($zatca_datas)) {
                                foreach ($zatca_datas as $zd) {
                                    $zt_sino = $this->model_mobileapi->getMax_SiNoZtca();
                                    $zd["sino"] = $zt_sino;
                                    $zd["bill_no"] = $billNo;

                                    $this->model_mobileapi->getQueryZatca_Einv_Table("zatca_einv_stat", $zd);
                                }
                            }
                        }



                        $sino = $this->model_mobileapi->getSiNo();
                        for ($i = 0; $i < count($bankData); $i++) {
                            if ($bankData[$i]["local_app_user"] != $masterDetails[$z]["local_app_user_entry_id"]) {
                                continue;
                            } else {
                                $this->model_mobileapi->saveCollectionBank($billNo, $bankData[$z]["TransactionType"], $sino, $bankData[$z]["Date"], $bankData[$z]["PartyName"], $bankData[$z]["NetTotal"], $bankData[$z]["Type"], $bankData[$z]["CashFlow"], $bankData[$z]["local_app_user"], $bankData[$z]["Narration"]);
                            }
                        }


                        // Execute the second query within the transaction
                        for ($i = 0; $i < count($data); $i++) {
                            // ... (your existing code)


                            if ($data[$i]["local_app_user_entry_id"] != $masterDetails[$z]["local_app_user_entry_id"]) {
                                continue;
                            } else {
                                $res = $this->model_mobileapi->storeUser($data[$i]["itemname"], $data[$i]["price"], $data[$i]["qty"], $data[$i]["unit"], $data[$i]["party"], $data[$i]["godown"], $data[$i]["employee"], $data[$i]["date1"], $data[$i]["invno"], $data[$i]["local_app_user_entry_id"], $billNo, $data[$i]["serial_no"], $data[$i]["taxAmount"], $data[$i]["taxPercentage"], $data[$i]["itemcode"], $data[$i]["qty_in_pack"], $data[$i]["cost"], $data[$i]["disc"], $data[$i]["sqft"], $data[$i]["taxtype"], $data[$i]["NetV"]);
                                if (!$res) {
                                    $this->model_mobileapi->rollBack(); //newly added in 7/19/24
                                    $b["bill_no"] = $billNo;
                                    $b["id"] = $data[$i]["local_app_user_entry_id"];
                                    $b["status"] = 'pending';
                                    $b["previlage"] = '1';
                                    $b["count"] = $cnt;
                                    $b["err"] = error_get_last();
                                    array_push($a, $b);
                                    // If an error occurs, throw an exception to roll back the transaction
                                    throw new Exception("Error in storeUser");
                                } else {
                                    $b["bill_no"] = $billNo;
                                    $b["id"] = $data[$i]["local_app_user_entry_id"];
                                    $b["status"] = 'uploaded';
                                    $b["previlage"] = '1';
                                    $b["count"] = $cnt;
                                    array_push($a, $b);
                                }
                            }
                        }



                        // Commit the changes for this iteration of the loop
                        $this->model_mobileapi->commit();
                        // echo json_encode($a);
                    }

                    // Commit the entire transaction
                    $this->model_mobileapi->commit();

                    $this->model_mobileapi->updateSyncActivationStatus($_POST['user']);
                    // }else{
                    //     $a = array();
                    //     $b = array();
                    //     $b["bill_no"] = '0';
                    //     $b["id"] = '0';
                    //     $b["status"] = 'Update user sync sales bill Privilage !!';
                    //     $b["previlage"] = '-1';
                    //     array_push($a, $b);
                    // }
                    echo json_encode($a);
                    //     }//post code
                } catch (Exception $e) {
                    // An error occurred, roll back the transaction
                    $this->model_mobileapi->rollBack();

                    // Handle the exception or log the error
                    $b["bill_no"] = $billNo;
                    $b["id"] = $data[$i]["local_app_user_entry_id"];
                    $b["status"] = 'pending';
                    $b["previlage"] = '1';
                    $b["count"] = $cnt;
                    $b["err"] = error_get_last();
                    array_push($a, $b);
                    echo json_encode($a);
                }
            } else {
                $response["success"] = 0;
                $response["message"] = "Required field(s) is missing";
                echo json_encode($response);
            }
        } else {
            $response["success"] = 0;
            $response["message"] = "Something went wrong";
            echo json_encode($response);
        }
    }

    //-------------------------------------------------------------------------------

    //----------------------------------------------------------------------------------



    public function saveInvoice()
    {
        // ✅ Initialize early so it’s always defined (prevents array_push null warning)
        $a = array();
        $b = array();

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            if (isset($_POST['code']) && isset($_POST["salesBillItems"]) && isset($_POST["salesBillMasterDetails"])) {
                try {
                    // ✅ Start transaction
                    $this->model_mobileapi->beginTransaction();

                    // ✅ Decode incoming JSON
                    $salesBillItemsData = $_POST["salesBillItems"];
                    $masterDetailsData = $_POST["salesBillMasterDetails"];
                    $salesBillCollectionBank = isset($_POST["salesBillCollectionBank"]) ? $_POST["salesBillCollectionBank"] : "[]";
                    $prefix = isset($_POST['prefix']) ? $_POST['prefix'] : "";
                    $stat = isset($_POST['stat']) ? $_POST['stat'] : 0; // ZATCA_EINV_STAT flag

                    $data = json_decode($salesBillItemsData, true);
                    $masterDetails = json_decode($masterDetailsData, true);
                    $bankData = json_decode($salesBillCollectionBank, true);

                    // ✅ Validate JSON
                    if (json_last_error() !== JSON_ERROR_NONE) {
                        throw new Exception("❌ Invalid JSON received in request.");
                    }

                    // ✅ Global validation: No SalesBillItems → Stop everything
                    if (empty($data)) {
                        throw new Exception("❌ No SalesBillItems found. Cannot insert empty bill.");
                    }

                    $cnt = 0;
                    $fin_year = $this->model_mobileapi->getFinYear();

                    // ✅ Loop through master bills
                    for ($z = 0; $z < count($masterDetails); $z++) {
                        $cnt++;

                        // Generate bill references
                        $billNo = $this->model_mobileapi->getBillNo();
                        $sino = $this->model_mobileapi->getSiNo();
                        $TaxBillNo = $this->model_mobileapi->getB2B_TAXBillNo();

                        // Fill dynamic master details fields
                        $masterDetails[$z]["BillNo"] = $billNo;
                        $masterDetails[$z]["sino"] = $sino;
                        $masterDetails[$z]["fin_year"] = $fin_year;
                        $masterDetails[$z]["TaxBillNo"] = $TaxBillNo;
                        if ($prefix != "") {
                            $masterDetails[$z]["NewBillNo"] = $prefix . $billNo;
                        }

                        if ($masterDetails[$z]["advance"] == 0) {
                            $masterDetails[$z]["sino"] = 0;
                        }

                        // ✅ ZATCA Validation (only when stat = 1)
                        if ($stat == 1) {
                            if (!isset($_POST["zatca_einv_stat_items"])) {
                                throw new Exception("❌ Missing ZATCA data for BillNo: " . $billNo);
                            }

                            $zatca_bill_dtls = $_POST["zatca_einv_stat_items"];
                            $zatca_datas = json_decode($zatca_bill_dtls, true);

                            if (json_last_error() !== JSON_ERROR_NONE) {
                                throw new Exception("❌ Invalid ZATCA JSON for BillNo: " . $billNo);
                            }

                            if (empty($zatca_datas)) {
                                throw new Exception("❌ Empty ZATCA data for BillNo: " . $billNo);
                            }
                        }

                        // ✅ Step 1.5: Ensure at least one item exists for this master entry
                        $hasItems = false;
                        for ($i = 0; $i < count($data); $i++) {
                            if ($data[$i]["local_app_user_entry_id"] == $masterDetails[$z]["local_app_user_entry_id"]) {
                                $hasItems = true;
                                break;
                            }
                        }

                        // ❌ If no items found → Skip this MasterDetails entry
                        if (!$hasItems) {
                            continue;
                        }

                        // ✅ Step 2: Insert into MasterDetails
                        $this->model_mobileapi->deleteFromMasterDetailsByBillNo($masterDetails[$z]["local_app_user_entry_id"], $billNo);
                        $this->model_mobileapi->getQuery("MasterDetails", $masterDetails[$z]);

                        // ✅ Step 3: Insert ZATCA data if enabled
                        if ($stat == 1) {
                            foreach ($zatca_datas as $zd) {
                                $zt_sino = $this->model_mobileapi->getMax_SiNoZtca();
                                $zd["sino"] = $zt_sino;
                                $zd["bill_no"] = $billNo;
                                $this->model_mobileapi->getQueryZatca_Einv_Table("zatca_einv_stat", $zd);
                            }
                        }

                        // ✅ Step 4: Save Bank Details (if any)
                        $sino = $this->model_mobileapi->getSiNo();
                        for ($i = 0; $i < count($bankData); $i++) {
                            if ($bankData[$i]["local_app_user"] != $masterDetails[$z]["local_app_user_entry_id"]) {
                                continue;
                            } else {
                                $this->model_mobileapi->saveCollectionBank(
                                    $billNo,
                                    $bankData[$i]["TransactionType"],
                                    $sino,
                                    $bankData[$i]["Date"],
                                    $bankData[$i]["PartyName"],
                                    $bankData[$i]["NetTotal"],
                                    $bankData[$i]["Type"],
                                    $bankData[$i]["CashFlow"],
                                    $bankData[$i]["local_app_user"],
                                    $bankData[$i]["Narration"]
                                );
                            }
                        }

                        // ✅ Step 5: Insert SalesBill Items
                        for ($i = 0; $i < count($data); $i++) {
                            if ($data[$i]["local_app_user_entry_id"] != $masterDetails[$z]["local_app_user_entry_id"]) {
                                continue;
                            }

                            $res = $this->model_mobileapi->storeUser(
                                $data[$i]["itemname"],
                                $data[$i]["price"],
                                $data[$i]["qty"],
                                $data[$i]["unit"],
                                $data[$i]["party"],
                                $data[$i]["godown"],
                                $data[$i]["employee"],
                                $data[$i]["date1"],
                                $data[$i]["invno"],
                                $data[$i]["local_app_user_entry_id"],
                                $billNo,
                                $data[$i]["serial_no"],
                                $data[$i]["taxAmount"],
                                $data[$i]["taxPercentage"],
                                $data[$i]["itemcode"],
                                $data[$i]["qty_in_pack"],
                                $data[$i]["cost"],
                                $data[$i]["disc"],
                                $data[$i]["sqft"],
                                $data[$i]["taxtype"],
                                $data[$i]["NetV"]
                            );

                            if (!$res) {
                                throw new Exception("❌ Error inserting SalesBill item for BillNo: " . $billNo);
                            }

                            // Add success record to response
                            $b["bill_no"] = $billNo;
                            $b["id"] = $data[$i]["local_app_user_entry_id"];
                            $b["status"] = 'uploaded';
                            $b["previlage"] = '1';
                            $b["count"] = $cnt;
                            array_push($a, $b);
                        }

                        // ✅ Step 6: Commit per-bill success
                        $this->model_mobileapi->commit();
                    }

                    // ✅ Commit all final changes
                    $this->model_mobileapi->commit();
                    $this->model_mobileapi->updateSyncActivationStatus($_POST['user']);
                    echo json_encode($a);

                } catch (Exception $e) {
                    // ❌ Rollback on any failure
                    $this->model_mobileapi->rollBack();

                    $b["bill_no"] = isset($billNo) ? $billNo : 0;
                    $b["status"] = 'pending';
                    $b["previlage"] = '1';
                    $b["error"] = $e->getMessage();
                    $b["count"] = isset($cnt) ? $cnt : 0;

                    // ✅ $a is always defined, so no warning
                    array_push($a, $b);

                    echo json_encode($a);
                }
            } else {
                $response["success"] = 0;
                $response["message"] = "Required field(s) missing";
                echo json_encode($response);
            }
        } else {
            $response["success"] = 0;
            $response["message"] = "Invalid request method";
            echo json_encode($response);
        }
    }




    //---------------------------------------------------------------------------------

    public function saveInvoice8b()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            if (isset($_POST['code']) and isset($_POST["salesBillItems"]) and isset($_POST["salesBillMasterDetails"])) {
                $salesBillItemsData = $_POST["salesBillItems"];
                $masterDetailsData = $_POST["salesBillMasterDetails"];
                //    if (get_magic_quotes_gpc()) {
                //        $salesBillItemsData = stripslashes($salesBillItemsData);
                //        $masterDetailsData = stripslashes($masterDetailsData);
                //    }

                $data = json_decode($salesBillItemsData, true);
                $masterDetails = json_decode($masterDetailsData, true);
                if ($_POST['code'] == 1) {
                    $previlage = $this->model_mobileapi->getSynPrevilage($_POST['user']);
                    if ($previlage == 1) {
                        $a = array();
                        $b = array();
                        for ($z = 0; $z < count($masterDetails); $z++) {
                            $billNo = $this->model_mobileapi->getBillNo8b();
                            $masterDetails[$z]["BillNo"] = $billNo;
                            $this->model_mobileapi->deleteFromMasterDetailsByBillNo($masterDetails[$z]["local_app_user_entry_id"], $billNo);
                            $this->model_mobileapi->getQuery("masterdetails8bnew", $masterDetails[$z]);
                            for ($i = 0; $i < count($data); $i++) {
                                if ($data[$i]["local_app_user_entry_id"] != $masterDetails[$z]["local_app_user_entry_id"]) {
                                    continue;
                                } else {
                                    $res = $this->model_mobileapi->storeUser8b($data[$i]["itemname"], $data[$i]["price"], $data[$i]["qty"], $data[$i]["unit"], $data[$i]["party"], $data[$i]["godown"], $data[$i]["employee"], $data[$i]["date1"], $data[$i]["invno"], $data[$i]["local_app_user_entry_id"], $billNo, $data[$i]["serial_no"], $data[$i]["taxAmount"], $data[$i]["taxPercentage"], $data[$i]["itemcode"], $data[$i]["qty_in_pack"], $data[$i]["cost"], $data[$i]["disc"], $data[$i]["sqft"]);
                                    if ($res) {
                                        $b["bill_no"] = $billNo;
                                        $b["id"] = $data[$i]["local_app_user_entry_id"];
                                        $b["status"] = 'uploaded';
                                        $b["previlage"] = '1';
                                        array_push($a, $b);
                                    } else {
                                        $b["bill_no"] = $billNo;
                                        $b["id"] = $data[$i]["local_app_user_entry_id"];
                                        $b["status"] = 'pending';
                                        $b["previlage"] = '1';
                                        array_push($a, $b);
                                    }
                                }
                            }
                        }
                        $this->model_mobileapi->updateSyncActivationStatus($_POST['user']);
                    } else {
                        $a = array();
                        $b = array();
                        $b["bill_no"] = '0';
                        $b["id"] = '0';
                        $b["status"] = 'Update user sync sales bill Privilage !!';
                        $b["previlage"] = '-1';
                        array_push($a, $b);
                    }
                    echo json_encode($a);
                } else {
                    $a = array();
                    $b = array();
                    for ($z = 0; $z < count($masterDetails); $z++) {
                        $billNo = $this->model_mobileapi->getBillNo8b();
                        $masterDetails[$z]["BillNo"] = $billNo;
                        $this->model_mobileapi->deleteFromMasterDetailsByBillNo($masterDetails[$z]["local_app_user_entry_id"], $billNo);
                        $this->model_mobileapi->getQuery("masterdetails8bnew", $masterDetails[$z]);
                        for ($i = 0; $i < count($data); $i++) {
                            if ($data[$i]["local_app_user_entry_id"] != $masterDetails[$z]["local_app_user_entry_id"]) {
                                continue;
                            } else {
                                $res = $this->model_mobileapi->storeUser8b($data[$i]["itemname"], $data[$i]["price"], $data[$i]["qty"], $data[$i]["unit"], $data[$i]["party"], $data[$i]["godown"], $data[$i]["employee"], $data[$i]["date1"], $data[$i]["invno"], $data[$i]["local_app_user_entry_id"], $billNo, $data[$i]["serial_no"], $data[$i]["taxAmount"], $data[$i]["taxPercentage"], $data[$i]["itemcode"], $data[$i]["qty_in_pack"], $data[$i]["cost"], $data[$i]["disc"], $data[$i]["sqft"]);
                                if ($res) {
                                    $b["bill_no"] = $billNo;
                                    $b["id"] = $data[$i]["local_app_user_entry_id"];
                                    $b["status"] = 'uploaded';
                                    $b["previlage"] = '1';
                                    array_push($a, $b);
                                } else {
                                    $b["bill_no"] = $billNo;
                                    $b["id"] = $data[$i]["local_app_user_entry_id"];
                                    $b["status"] = 'pending';
                                    $b["previlage"] = '1';
                                    array_push($a, $b);
                                }
                            }
                        }
                    }
                    echo json_encode($a);
                }
            } else {
                $response["success"] = 0;
                $response["message"] = "Required field(s) is missing";
                echo json_encode($response);
            }
        } else {
            $response["success"] = 0;
            $response["message"] = "Something went wrong";
            echo json_encode($response);
        }
    }

    public function updateInvoice()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            if (isset($_POST['code']) and isset($_POST["salesBillItems"]) and isset($_POST["salesBillMasterDetails"])) {
                $salesBillItemsData = $_POST["salesBillItems"];
                $masterDetailsData = $_POST["salesBillMasterDetails"];
                //    if (get_magic_quotes_gpc()) {
                //        $salesBillItemsData = stripslashes($salesBillItemsData);
                //        $masterDetailsData = stripslashes($masterDetailsData);
                //    }

                //     if((function_exists("get_magic_quotes_gpc") && get_magic_quotes_gpc())    || (ini_get('magic_quotes_sybase') && (strtolower(ini_get('magic_quotes_sybase'))!="off")) ){
                //         $salesBillItemsData = stripslashes($salesBillItemsData);
                //         $masterDetailsData = stripslashes($masterDetailsData);
                // }
                $data = json_decode($salesBillItemsData, true);
                $masterDetails = json_decode($masterDetailsData, true);
                if ($_POST['code'] == 1) {
                    $previlage = $this->model_mobileapi->getSynPrevilage($_POST['user']);
                    if ($previlage == 1) {
                        $a = array();
                        $b = array();
                        for ($z = 0; $z < count($masterDetails); $z++) {
                            for ($i = 0; $i < count($data); $i++) {
                                $inv_no = $data[$i]["invno"];
                                $emp = $data[$i]["employee"];
                            }
                            $billNo = $this->model_mobileapi->getUpdateBillNo($inv_no, $emp);
                            $this->model_mobileapi->deleteFromSalesBillByBillNo($inv_no, $emp);
                            $this->model_mobileapi->getUpdateQueryMasterDetails($billNo, $masterDetails[$z]["BillDate"], $masterDetails[$z]["BillPartyName"], $masterDetails[$z]["BillTotalField"], $masterDetails[$z]["BillDiscAmtField"], $masterDetails[$z]["BillDiscPercField"], $masterDetails[$z]["BillTaxField"], $masterDetails[$z]["BillPackageField"], $masterDetails[$z]["BillNetTotalField"], $masterDetails[$z]["BillTyp"], $masterDetails[$z]["BillTime"], $masterDetails[$z]["OrderNo"], $masterDetails[$z]["TDiscAmt"], $masterDetails[$z]["TaxAmt"], $masterDetails[$z]["TItTaxAmt"], $masterDetails[$z]["TAmt"], $masterDetails[$z]["Cess"], $emp, $masterDetails[$z]["DCNoTax"], $masterDetails[$z]["TotDiscPercAmt"], $masterDetails[$z]["CessP"], $masterDetails[$z]["TotItWiseQty1"], $masterDetails[$z]["CashP"], $masterDetails[$z]["CashCard"], $masterDetails[$z]["CashCardAmt"], $masterDetails[$z]["godown"], $masterDetails[$z]["del_date"], $masterDetails[$z]["local_app_user_entry_id"], $inv_no, $masterDetails[$z]["SystemId"], $masterDetails[$z]["Profit"]);
                            for ($i = 0; $i < count($data); $i++) {
                                if ($data[$i]["local_app_user_entry_id"] != $masterDetails[$z]["local_app_user_entry_id"]) {
                                    continue;
                                } else {
                                    $res = $this->model_mobileapi->storeUser($data[$i]["itemname"], $data[$i]["price"], $data[$i]["qty"], $data[$i]["unit"], $data[$i]["party"], $data[$i]["godown"], $data[$i]["employee"], $data[$i]["date1"], $data[$i]["invno"], $data[$i]["local_app_user_entry_id"], $billNo, $data[$i]["serial_no"], $data[$i]["taxAmount"], $data[$i]["taxPercentage"], $data[$i]["itemcode"], $data[$i]["qty_in_pack"], $data[$i]["cost"], $data[$i]["disc"], $data[$i]["sqft"], $data[$i]["taxtype"], $data[$i]["NetV"]);
                                    if ($res) {
                                        $b["bill_no"] = $billNo;
                                        $b["id"] = $data[$i]["local_app_user_entry_id"];
                                        $b["status"] = 'uploaded';
                                        $b["previlage"] = '1';
                                        array_push($a, $b);
                                    } else {
                                        $b["bill_no"] = $billNo;
                                        $b["id"] = $data[$i]["local_app_user_entry_id"];
                                        $b["status"] = 'pending';
                                        $b["previlage"] = '1';
                                        array_push($a, $b);
                                    }
                                }
                            }
                        }
                        echo json_encode($a);
                        $this->model_mobileapi->updateSyncActivationStatus($_POST['user']);
                    } else {
                        $a = array();
                        $b = array();
                        $b["bill_no"] = '0';
                        $b["id"] = '0';
                        $b["status"] = 'Update user sync sales bill Privilage !!';
                        $b["previlage"] = '-1';
                        array_push($a, $b);
                    }
                    echo json_encode($a);
                } else {
                    $a = array();
                    $b = array();
                    for ($z = 0; $z < count($masterDetails); $z++) {
                        for ($i = 0; $i < count($data); $i++) {
                            $inv_no = $data[$i]["invno"];
                            $emp = $data[$i]["employee"];
                        }
                        $billNo = $this->model_mobileapi->getUpdateBillNoNew($inv_no, $emp);
                        $this->model_mobileapi->deleteFromSalesBillByBillNo($inv_no, $emp);
                        $this->model_mobileapi->getUpdateQueryMasterDetailsNew($billNo, $masterDetails[$z]["BillDate"], $masterDetails[$z]["BillPartyName"], $masterDetails[$z]["BillTotalField"], $masterDetails[$z]["BillDiscAmtField"], $masterDetails[$z]["BillDiscPercField"], $masterDetails[$z]["BillTaxField"], $masterDetails[$z]["BillPackageField"], $masterDetails[$z]["BillNetTotalField"], $masterDetails[$z]["BillTyp"], $masterDetails[$z]["BillTime"], $masterDetails[$z]["OrderNo"], $masterDetails[$z]["TDiscAmt"], $masterDetails[$z]["TaxAmt"], $masterDetails[$z]["TItTaxAmt"], $masterDetails[$z]["TAmt"], $masterDetails[$z]["Cess"], $emp, $masterDetails[$z]["DCNoTax"], $masterDetails[$z]["TotDiscPercAmt"], $masterDetails[$z]["CessP"], $masterDetails[$z]["TotItWiseQty1"], $masterDetails[$z]["CashP"], $masterDetails[$z]["CashCard"], $masterDetails[$z]["CashCardAmt"], $masterDetails[$z]["godown"], $masterDetails[$z]["del_date"], $masterDetails[$z]["local_app_user_entry_id"], $inv_no, $masterDetails[$z]["SystemId"], $masterDetails[$z]["Profit"]);
                        $this->model_mobileapi->getUpdateQueryCollection($billNo, $masterDetails[$z]["BillDate"], $masterDetails[$z]["BillPartyName"], $masterDetails[$z]["BillNetTotalField"], $emp);
                        for ($i = 0; $i < count($data); $i++) {
                            if ($data[$i]["local_app_user_entry_id"] != $masterDetails[$z]["local_app_user_entry_id"]) {
                                continue;
                            } else {
                                $res = $this->model_mobileapi->storeUser($data[$i]["itemname"], $data[$i]["price"], $data[$i]["qty"], $data[$i]["unit"], $data[$i]["party"], $data[$i]["godown"], $data[$i]["employee"], $data[$i]["date1"], $data[$i]["invno"], $data[$i]["local_app_user_entry_id"], $billNo, $data[$i]["serial_no"], $data[$i]["taxAmount"], $data[$i]["taxPercentage"], $data[$i]["itemcode"], $data[$i]["qty_in_pack"], $data[$i]["cost"], $data[$i]["disc"], $data[$i]["sqft"], $data[$i]["taxtype"], $data[$i]["NetV"]);
                                if ($res) {
                                    $b["bill_no"] = $billNo;
                                    $b["id"] = $data[$i]["local_app_user_entry_id"];
                                    $b["status"] = 'uploaded';
                                    $b["previlage"] = '1';
                                    array_push($a, $b);
                                } else {
                                    $b["bill_no"] = $billNo;
                                    $b["id"] = $data[$i]["local_app_user_entry_id"];
                                    $b["status"] = 'pending';
                                    $b["previlage"] = '1';
                                    array_push($a, $b);
                                }
                            }
                        }
                    }
                    echo json_encode($a);
                }
            } else {
                $response["success"] = 0;
                $response["message"] = "Required field(s) is missing";
                echo json_encode($response);
            }
        } else {
            $response["success"] = 0;
            $response["message"] = "Something went wrong";
            echo json_encode($response);
        }
    }

    public function deleteCollectionReport()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            if (isset($_POST['billNo'])) {
                $billNo = $_POST['billNo'];
                $this->model_mobileapi->deleteFromCollectionBySiNo($billNo);
                $response["success"] = 1;
                $response["billNo"] = $billNo;
                $response["message"] = "Collection Bill Deleted";
                echo json_encode($response);
            } else {
                $response["success"] = 0;
                $response["message"] = "Collection not Deleted";
                echo json_encode($response);
            }
        } else {
            $response["success"] = 0;
            $response["message"] = "Something went wrong";
            echo json_encode($response);
        }
    }

    public function deleteSaleBill()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            if (isset($_POST['billNo']) and isset($_POST["empName"])) {
                $inv_no = $_POST['billNo'];
                $emp = $_POST['empName'];
                $billNo = $this->model_mobileapi->getUpdateBillNo($inv_no, $emp);
                // $appuser = $this->model_mobileapi->getUpdatelocal($inv_no, $emp);
                $this->model_mobileapi->deleteFromSalesBillByBillNo($inv_no, $emp);
                $this->model_mobileapi->deleteFromMasterDetailsToSalesBillDelete($inv_no, $emp);
                $this->model_mobileapi->deleteFromCollectionToSaleBillDelete($inv_no);
                $response["success"] = 1;
                $response["billNo"] = $billNo;
                $response["message"] = "Sales Bill Deleted";
                echo json_encode($response);
            }
        } else {
            $response["success"] = 0;
            $response["message"] = "Something went wrong";
            echo json_encode($response);
        }
    }

    public function deleteSalesReturn()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            if (isset($_POST['billNo']) and isset($_POST["empName"])) {
                $inv_no = $_POST['billNo'];
                $emp = $_POST['empName'];
                // $appuser = $this->model_mobileapi->getUpdatelocal($inv_no, $emp);
                $this->model_mobileapi->deleteFromSalesReturnByBillNo($inv_no, $emp);
                $this->model_mobileapi->deleteFromSRMasterDetailsDelete($inv_no, $emp);
                $this->model_mobileapi->deleteFromCollectionSalesReturnDelete($inv_no);
                $response["success"] = 1;
                //  $response["billNo"] = $billNo;
                $response["message"] = "Sales Bill Deleted";
                echo json_encode($response);
            }
        } else {
            $response["success"] = 0;
            $response["message"] = "Something went wrong...";
            echo json_encode($response);
        }
    }

    public function deleteIntrans()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            if (isset($_POST['inv_no']) and isset($_POST["party"])) {
                $inv_no = $_POST['inv_no'];
                $emp = $_POST['party'];
                $this->model_mobileapi->deleteFromInTrans($inv_no, $emp);
                $response["success"] = 1;
                $response["inv_no"] = $inv_no;
                $response["message"] = "Intrans Bill Deleted";
                echo json_encode($response);
            }
        } else {
            $response["success"] = 0;
            $response["message"] = "Something went wrong";
            echo json_encode($response);
        }
    }

    public function saveReturnInvoice()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            if (isset($_POST['code']) and isset($_POST["salesReturnBillItems"]) and isset($_POST["salesBillSrMasterDetails"])) {
                $salesBillItemsData = $_POST["salesReturnBillItems"];
                $masterDetailsData = $_POST["salesBillSrMasterDetails"];
                $EditModeStatus = $_POST["EditMode"];
                $EditBillNo = $_POST["EditBillNo"];

                $onlilestat = $_POST["online"];

                //    if (get_magic_quotes_gpc()) {
                //        $salesBillItemsData = stripslashes($salesBillItemsData);
                //        $masterDetailsData = stripslashes($masterDetailsData);
                //    }

                $data = json_decode($salesBillItemsData, true);
                $masterDetails = json_decode($masterDetailsData, true);

                // $response["success"] =$masterDetails;
                // $response["message"] = "Required field(s) is missing";
                // echo json_encode($response);

                if ($_POST['code'] == 1) {
                    $previlage = $this->model_mobileapi->getSynPrevilage($_POST['user']);
                    if ($previlage == 1) {
                        $a = array();
                        $b = array();
                        for ($z = 0; $z < count($masterDetails); $z++) {
                            $retNo = $this->model_mobileapi->getSRBillNo();
                            $TaxBillNo = $this->model_mobileapi->getSRT_TAXBillNo();
                            $fin_year = $this->model_mobileapi->getFinYearSRT();

                            $masterDetails[$z]["RetNo"] = $retNo;
                            $masterDetails[$z]["TaxBillNo"] = $TaxBillNo;
                            $masterDetails[$z]["fin_year"] = $fin_year;

                            if ($EditModeStatus == "NO") {
                                $this->model_mobileapi->deleteFromSRMasterDetailsByRetNo($masterDetails[$z]["local_app_user_entry_id"], $retNo);
                            } else {
                                $retNo = $EditBillNo;
                            }

                            if ($onlilestat == 1) {
                                $this->model_mobileapi->deleteFromCollectionByRetNo($masterDetails[$z]["local_app_user_entry_id"], $retNo);
                            }

                            // $this->model_mobileapi->deleteFromCollectionByRetNo($masterDetails[$z]["local_app_user_entry_id"], $retNo);
                            $res = $this->model_mobileapi->storeSalesRetunCollection($retNo, $masterDetails[$z]["BillDate"], $masterDetails[$z]["BillPartyName"], $masterDetails[$z]["BillTotalField"], $masterDetails[$z]["BillNetTotalField"], $masterDetails[$z]["Employee"], $masterDetails[$z]["godown"], $masterDetails[$z]["local_app_user_entry_id"], $masterDetails[$z]["TaxAmt"], $TaxBillNo, $fin_year);
                            if ($EditModeStatus == "YES") {
                                $this->model_mobileapi->getUpdateQuerySRMasterDetails($retNo, $masterDetails[$z]["BillDate"], $masterDetails[$z]["BillPartyName"], $masterDetails[$z]["BillTotalField"], $masterDetails[$z]["BillDiscAmtField"], $masterDetails[$z]["BillDiscPercField"], $masterDetails[$z]["BillTaxField"], $masterDetails[$z]["BillPackageField"], $masterDetails[$z]["BillNetTotalField"], $masterDetails[$z]["BillTyp"], $masterDetails[$z]["TaxAmt"], $masterDetails[$z]["Employee"], $masterDetails[$z]["godown"], $masterDetails[$z]["local_app_user_entry_id"], $masterDetails[$z]["netQty"]);
                                $this->db->query("DELETE FROM " . super_model::$table_sales_return . " WHERE  RetNo = '$retNo'");
                            } else {

                                $stat = isset($_POST['stat']) ? $_POST['stat'] : 0;   // ZATCA_EINV_STAT
                                if ($stat == 1) {
                                    if (!isset($_POST["zatca_einv_stat_items"])) {
                                        die("ZATCA data not provided.");
                                    }

                                    $zatca_bill_dtls = $_POST["zatca_einv_stat_items"];
                                    $zatca_datas = json_decode($zatca_bill_dtls, true);

                                    if (json_last_error() !== JSON_ERROR_NONE) {
                                        die("Invalid JSON in zatca_einv_stat_items: " . json_last_error_msg());
                                    }

                                    if (!empty($zatca_datas)) {
                                        foreach ($zatca_datas as $zd) {
                                            $zt_sino = $this->model_mobileapi->getMax_SiNoZtca();
                                            $zd["sino"] = $zt_sino;
                                            $zd["bill_no"] = $retNo;
                                            $zd["bill_form"] = "Sales Return";

                                            $this->model_mobileapi->getQueryZatca_Einv_Table("zatca_einv_stat", $zd);
                                        }
                                    }
                                }

                                // $this->model_mobileapi->getQuery("SRMasterDetails", $masterDetails[$z]);
                                $this->model_mobileapi->getQuerySRmasterdetails("SRMasterDetails", $masterDetails[$z]);
                            }


                            for ($i = 0; $i < count($data); $i++) {
                                if ($data[$i]["local_app_user_entry_id"] != $masterDetails[$z]["local_app_user_entry_id"]) {
                                    continue;
                                } else {
                                    // $res = $this->model_mobileapi->storeSalesRetun($data[$i]["itemname"], $data[$i]["price"], $data[$i]["qty"], $data[$i]["unit"], $data[$i]["party"], $data[$i]["godown"], $data[$i]["employee"], $data[$i]["date1"], $data[$i]["invno"], $data[$i]["local_app_user_entry_id"], $retNo, $data[$i]["serial_no"], $data[$i]["taxAmount"], $data[$i]["taxPercentage"], $data[$i]["itemcode"], $data[$i]["qty_in_pack"], $data[$i]["cost"], $data[$i]["disc"]);
                                    $res = $this->model_mobileapi->storeSalesRetun($data[$i]["itemname"], $data[$i]["price"], $data[$i]["qty"], $data[$i]["unit"], $data[$i]["party"], $data[$i]["godown"], $data[$i]["employee"], $data[$i]["date1"], $data[$i]["invno"], $data[$i]["local_app_user_entry_id"], $retNo, $data[$i]["serial_no"], $data[$i]["taxAmount"], $data[$i]["taxPercentage"], $data[$i]["itemcode"], $data[$i]["qty_in_pack"], $data[$i]["cost"], $data[$i]["disc"], $data[$i]["taxtype"]);
                                    if ($res) {
                                        $b["id"] = $data[$i]["local_app_user_entry_id"];
                                        $b["status"] = 'uploaded';
                                        $b["previlage"] = '1';
                                        array_push($a, $b);
                                    } else {
                                        $b["id"] = $data[$i]["local_app_user_entry_id"];
                                        $b["status"] = 'pending';
                                        $b["previlage"] = '1';
                                        array_push($a, $b);
                                    }
                                }
                            }
                        }
                        $this->model_mobileapi->updateSyncActivationStatus();
                    } else {
                        $a = array();
                        $b = array();
                        $b["bill_no"] = '0';
                        $b["id"] = '0';
                        $b["status"] = 'Update user sync sales return bill Privilage !!';
                        $b["previlage"] = '-1';
                        array_push($a, $b);
                    }
                    echo json_encode($a);
                } else {
                    $a = array();
                    $b = array();
                    for ($z = 0; $z < count($masterDetails); $z++) {
                        $retNo = $this->model_mobileapi->getSRBillNo();
                        $TaxBillNo = $this->model_mobileapi->getSRT_TAXBillNo();
                        $fin_year = $this->model_mobileapi->getFinYearSRT();

                        $retNo = $retNo;

                        $masterDetails[$z]["RetNo"] = $retNo;
                        $masterDetails[$z]["TaxBillNo"] = $TaxBillNo;
                        $masterDetails[$z]["fin_year"] = $fin_year;

                        if ($EditModeStatus == "NO") {
                            $this->model_mobileapi->deleteFromSRMasterDetailsByRetNo($masterDetails[$z]["local_app_user_entry_id"], $retNo);
                        } else {
                            $retNo = $EditBillNo;
                        }


                        if ($onlilestat == 1) {
                            $this->model_mobileapi->deleteFromCollectionByRetNo($masterDetails[$z]["local_app_user_entry_id"], $retNo);
                        }

                        // $this->model_mobileapi->deleteFromCollectionByRetNo($masterDetails[$z]["local_app_user_entry_id"], $retNo);
                        $res = $this->model_mobileapi->storeSalesRetunCollection($retNo, $masterDetails[$z]["BillDate"], $masterDetails[$z]["BillPartyName"], $masterDetails[$z]["BillTotalField"], $masterDetails[$z]["BillNetTotalField"], $masterDetails[$z]["Employee"], $masterDetails[$z]["godown"], $masterDetails[$z]["local_app_user_entry_id"], $masterDetails[$z]["TaxAmt"], $TaxBillNo, $fin_year);
                        if ($EditModeStatus == "YES") {
                            $this->model_mobileapi->getUpdateQuerySRMasterDetails($retNo, $masterDetails[$z]["BillDate"], $masterDetails[$z]["BillPartyName"], $masterDetails[$z]["BillTotalField"], $masterDetails[$z]["BillDiscAmtField"], $masterDetails[$z]["BillDiscPercField"], $masterDetails[$z]["BillTaxField"], $masterDetails[$z]["BillPackageField"], $masterDetails[$z]["BillNetTotalField"], $masterDetails[$z]["BillTyp"], $masterDetails[$z]["TaxAmt"], $masterDetails[$z]["Employee"], $masterDetails[$z]["godown"], $masterDetails[$z]["local_app_user_entry_id"], $masterDetails[$z]["netQty"]);
                            $this->db->query("DELETE FROM " . super_model::$table_sales_return . " WHERE  RetNo = '$retNo'");
                        } else {

                            $stat = isset($_POST['stat']) ? $_POST['stat'] : 0;   // ZATCA_EINV_STAT
                            if ($stat == 1) {
                                if (!isset($_POST["zatca_einv_stat_items"])) {
                                    die("ZATCA data not provided.");
                                }

                                $zatca_bill_dtls = $_POST["zatca_einv_stat_items"];
                                $zatca_datas = json_decode($zatca_bill_dtls, true);

                                if (json_last_error() !== JSON_ERROR_NONE) {
                                    die("Invalid JSON in zatca_einv_stat_items: " . json_last_error_msg());
                                }

                                if (!empty($zatca_datas)) {
                                    foreach ($zatca_datas as $zd) {
                                        $zt_sino = $this->model_mobileapi->getMax_SiNoZtca();
                                        $zd["sino"] = $zt_sino;
                                        $zd["bill_no"] = $retNo;
                                        $zd["bill_form"] = "Sales Return";

                                        $this->model_mobileapi->getQueryZatca_Einv_Table("zatca_einv_stat", $zd);
                                    }
                                }
                            }

                            $this->model_mobileapi->getQuerySRmasterdetails("SRMasterDetails", $masterDetails[$z]);
                        }


                        for ($i = 0; $i < count($data); $i++) {
                            if ($data[$i]["local_app_user_entry_id"] != $masterDetails[$z]["local_app_user_entry_id"]) {
                                continue;
                            } else {
                                //  $res = $this->model_mobileapi->storeSalesRetun($data[$i]["itemname"], $data[$i]["price"], $data[$i]["qty"], $data[$i]["unit"], $data[$i]["party"], $data[$i]["godown"], $data[$i]["employee"], $data[$i]["date1"], $data[$i]["invno"], $data[$i]["local_app_user_entry_id"], $retNo, $data[$i]["serial_no"], $data[$i]["taxAmount"], $data[$i]["taxPercentage"], $data[$i]["itemcode"], $data[$i]["qty_in_pack"], $data[$i]["cost"], $data[$i]["disc"]);
                                $res = $this->model_mobileapi->storeSalesRetun($data[$i]["itemname"], $data[$i]["price"], $data[$i]["qty"], $data[$i]["unit"], $data[$i]["party"], $data[$i]["godown"], $data[$i]["employee"], $data[$i]["date1"], $data[$i]["invno"], $data[$i]["local_app_user_entry_id"], $retNo, $data[$i]["serial_no"], $data[$i]["taxAmount"], $data[$i]["taxPercentage"], $data[$i]["itemcode"], $data[$i]["qty_in_pack"], $data[$i]["cost"], $data[$i]["disc"], $data[$i]["taxtype"]);
                                if ($res) {
                                    $b["bill_no"] = $retNo;
                                    $b["id"] = $data[$i]["local_app_user_entry_id"];
                                    $b["status"] = 'uploaded';
                                    $b["previlage"] = '1';
                                    array_push($a, $b);
                                } else {
                                    $b["bill_no"] = $retNo;
                                    $b["id"] = $data[$i]["local_app_user_entry_id"];
                                    $b["status"] = 'pending';
                                    $b["previlage"] = '1';
                                    array_push($a, $b);
                                }
                            }
                        }
                    }
                    echo json_encode($a);
                }
            } else {
                $response["success"] = 0;
                $response["message"] = "Required field(s) is missing";
                echo json_encode($response);
            }
        } else {
            $response["success"] = 0;
            $response["message"] = "Something went wrong";
            echo json_encode($response);
        }
    }

    public function getSino()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'GET') {
            $res = $this->model_mobileapi->getSiNo();
            if ($res == 0) {
                $response["success"] = 0;
                $response["message"] = "Required field(s) is missing";
                echo json_encode($response);
            } else {
                $response["SiNO"] = $res;
                $response["message"] = "Success!";
                echo json_encode($response);
            }
        }
    }
    public function getCashparty()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'GET') {
            $res = $this->model_mobileapi->getCashParty();
            if ($res == 0) {
                $response["failed"] = 0;
                $response["message"] = "Required field(s) is missing";
                echo json_encode($response);
            } else {
                $response["party"] = $res;
                $response["message"] = "Success!";
                echo json_encode($response);
            }
        }
    }


    // public function saveReceipt()
    // {
    //     if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    //         if (isset($_POST['code']) and isset($_POST["usersJSON"])) {
    //             //    if (get_magic_quotes_gpc()) {
    //             //        $json = stripslashes($json);
    //             //    }                
    //             $data = json_decode($_POST["usersJSON"]);
    //             $a = array();
    //             $b = array();
    //             //                $SiNo = $this->model_mobileapi->getSiNo();
    //             if ($_POST['code'] == 1) {
    //                 $previlage = $this->model_mobileapi->getSynPrevilage($_POST['user']);
    //                 if ($previlage == 1) {
    //                     for ($i = 0; $i < count($data); $i++) {
    //                         $SiNo = $this->model_mobileapi->getSiNo();
    //                         $res = $this->model_mobileapi->storeDebit(strtoupper($data[$i]->party), $data[$i]->amount, $data[$i]->date1, $data[$i]->user, $data[$i]->godown, $data[$i]->image_data, $data[$i]->transaction_type, $data[$i]->cheque_no, $data[$i]->narration, $data[$i]->local_app_user_entry_id, $SiNo);
    //                         if ($res) {
    //                             $b["id"] = $data[$i]->id;
    //                             $b["status"] = 'uploaded';
    //                             $b["previlage"] = '1';
    //                             array_push($a, $b);
    //                         } else {
    //                             $b["id"] = $data[$i]->id;
    //                             $b["status"] = 'pending';
    //                             $b["previlage"] = '1';
    //                             array_push($a, $b);
    //                         }
    //                     }
    //                     $this->model_mobileapi->updateSyncActivationStatus();
    //                 } else {
    //                     $b["id"] = "0";
    //                     $b["status"] = 'Update user sync save receipt Privilage !!';
    //                     $b["previlage"] = '-1';
    //                     array_push($a, $b);
    //                 }
    //                 echo json_encode($a);
    //             } else {
    //                 for ($i = 0; $i < count($data); $i++) {
    //                     $SiNo = $this->model_mobileapi->getSiNo();
    //                     $res = $this->model_mobileapi->storeDebit(strtoupper($data[$i]->party), $data[$i]->amount, $data[$i]->date1, $data[$i]->user, $data[$i]->godown, $data[$i]->image_data, $data[$i]->transaction_type, $data[$i]->cheque_no, $data[$i]->narration, $data[$i]->local_app_user_entry_id, $SiNo);
    //                     if ($res) {
    //                         $b["id"] = $data[$i]->id;
    //                         $b["status"] = 'uploaded';
    //                         $b["previlage"] = '1';
    //                         array_push($a, $b);
    //                     } else {
    //                         $b["id"] = $data[$i]->id;
    //                         $b["status"] = 'pending';
    //                         $b["previlage"] = '1';
    //                         array_push($a, $b);
    //                     }
    //                 }
    //                 echo json_encode($a);
    //             }
    //         }
    //     }
    // }





    public function saveReceipt()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            if (isset($_POST['code']) && isset($_POST["usersJSON"])) {

                // Decode primary receipt data (DEBIT entries)
                $data = json_decode($_POST["usersJSON"]);
                $prefix_val = isset($_POST["prefix"]) ? $_POST["prefix"] : "";

                // Prepare response array
                $responseArray = array();

                // Check if BANK processing is enabled and decode if so
                $bankEnabled = isset($_POST['BANK']) && $_POST['BANK'] == 1 && isset($_POST["bankJSON"]);
                $bankData = $bankEnabled ? json_decode($_POST["bankJSON"]) : array();

                // If code == 1, check user privilege
                if ($_POST['code'] == 1) {
                    $privilege = $this->model_mobileapi->getSynPrevilage($_POST['user']);

                    if ($privilege == 1) {
                        // Loop through each DEBIT entry
                        for ($i = 0; $i < count($data); $i++) {
                            $SiNo = $this->model_mobileapi->getSiNo();

                            // Store DEBIT entry
                            $res = $this->model_mobileapi->storeDebit(
                                strtoupper($data[$i]->party),
                                $data[$i]->amount,
                                $data[$i]->date1,
                                $data[$i]->user,
                                $data[$i]->godown,
                                $data[$i]->image_data,
                                $data[$i]->transaction_type,
                                $data[$i]->cheque_no,
                                $data[$i]->narration,
                                $data[$i]->local_app_user_entry_id,
                                $SiNo,
                                $prefix_val
                            );
                            // If BANK is enabled and corresponding entry exists, store it
                            if ($bankEnabled && isset($bankData[$i])) {
                                $this->model_mobileapi->storeCollectionBank(
                                    strtoupper($bankData[$i]->party),
                                    $bankData[$i]->amount,
                                    $bankData[$i]->date1,
                                    $bankData[$i]->user,
                                    $bankData[$i]->godown,
                                    $bankData[$i]->image_data,
                                    $bankData[$i]->transaction_type,
                                    $bankData[$i]->cheque_no,
                                    $bankData[$i]->narration,
                                    $bankData[$i]->local_app_user_entry_id,
                                    $SiNo,
                                    $prefix_val,
                                    strtoupper($data[$i]->party)
                                );
                            }

                            // Prepare and store response for this item
                            $responseArray[] = array(
                                "id" => $data[$i]->id,
                                "local_app_user_entry_id" => $data[$i]->local_app_user_entry_id,
                                "status" => $res ? 'uploaded' : 'pending',
                                "previlage" => '1'

                            );
                        }

                        // Update sync status after all entries
                        $this->model_mobileapi->updateSyncActivationStatus();

                    } else {
                        // No privilege to upload
                        $responseArray[] = array(
                            "id" => "0",
                            "status" => 'Update user sync save receipt Privilage !!',
                            "previlage" => '-1'
                        );
                    }
                } else {
                    // code != 1: No privilege check, store directly
                    for ($i = 0; $i < count($data); $i++) {
                        $SiNo = $this->model_mobileapi->getSiNo();

                        // Store DEBIT entry
                        $res = $this->model_mobileapi->storeDebit(
                            strtoupper($data[$i]->party),
                            $data[$i]->amount,
                            $data[$i]->date1,
                            $data[$i]->user,
                            $data[$i]->godown,
                            $data[$i]->image_data,
                            $data[$i]->transaction_type,
                            $data[$i]->cheque_no,
                            $data[$i]->narration,
                            $data[$i]->local_app_user_entry_id,
                            $SiNo,
                            $prefix_val
                        );

                        // Store BANK if available
                        if ($bankEnabled && isset($bankData[$i])) {
                            $this->model_mobileapi->storeCollectionBank(
                                strtoupper($bankData[$i]->party),
                                $bankData[$i]->amount,
                                $bankData[$i]->date1,
                                $bankData[$i]->user,
                                $bankData[$i]->godown,
                                $bankData[$i]->image_data,
                                $bankData[$i]->transaction_type,
                                $bankData[$i]->cheque_no,
                                $bankData[$i]->narration,
                                $bankData[$i]->local_app_user_entry_id,
                                $SiNo,
                                $prefix_val,
                                strtoupper($data[$i]->party)
                            );
                        }

                        // Response for this item
                        $responseArray[] = array(
                            "id" => $data[$i]->id,
                            "local_app_user_entry_id" => $data[$i]->local_app_user_entry_id,
                            "status" => $res ? 'uploaded' : 'pending',
                            "previlage" => '1'
                        );

                    }
                }

                // Final JSON output
                echo json_encode($responseArray);
                return;
            }
        }

        // Fallback if not POST or required parameters missing
        echo json_encode(array(
            "id" => "0",
            "status" => "Invalid request",
            "previlage" => "-1"
        ));
    }



    public function updateReceipt()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            if (isset($_POST['SiNo']) and isset($_POST["usersJSON"])) {
                //    if (get_magic_quotes_gpc()) {
                //        $json = stripslashes($json);
                //    }                
                $data = json_decode($_POST["usersJSON"]);
                $SiNo = json_decode($_POST["SiNo"]);
                $prefix_val = isset($_POST["prefix"]) ? $_POST["prefix"] : "";
                $a = array();
                $b = array();
                //                $SiNo = $this->model_mobileapi->getSiNo();
                for ($i = 0; $i < count($data); $i++) {
                    $res = $this->model_mobileapi->storeDebit(strtoupper($data[$i]->party), $data[$i]->amount, $data[$i]->date1, $data[$i]->user, $data[$i]->godown, $data[$i]->image_data, $data[$i]->transaction_type, $data[$i]->cheque_no, $data[$i]->narration, $data[$i]->local_app_user_entry_id, $SiNo, $prefix_val);
                    if ($res) {
                        $b["id"] = $SiNo;
                        $b["status"] = 'uploaded';
                        array_push($a, $b);
                    } else {
                        $b["id"] = $SiNo;
                        $b["status"] = 'pending';
                        array_push($a, $b);
                    }
                    echo json_encode($a);
                }
            } else {
                $response["success"] = 0;
                $response["message"] = "Required field(s) is missing";
                echo json_encode($response);
            }
        } else {
            $response["success"] = 0;
            $response["message"] = "Something went wrong";
            echo json_encode($response);
        }
    }

    public function saveGPSData()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            if (isset($_POST["usersJSON"])) {
                $json = $_POST["usersJSON"];
                //    if (get_magic_quotes_gpc()) {
                //        $json = stripslashes($json);
                //    }

                $data = json_decode($json);
                $a = array();
                $b = array();
                for ($i = 0; $i < count($data); $i++) {
                    $res = $this->model_mobileapi->storeGPS($data[$i]->latitude, $data[$i]->longitude, $data[$i]->party_name, $data[$i]->action, $data[$i]->date1, $data[$i]->user, $data[$i]->godown);
                    if ($res) {
                        $b["id"] = $data[$i]->id;
                        $b["status"] = 'UPLOADED';
                        array_push($a, $b);
                    } else {
                        $b["id"] = $data[$i]->id;
                        $b["status"] = 'PENDING';
                        array_push($a, $b);
                    }
                }
                echo json_encode($a);
            }
        }
    }

    public function saveOrder()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            if (isset($_POST["orderBillItems"]) and isset($_POST["orderBillMasterDetails"])) {
                $orderBillItemsData = $_POST["orderBillItems"];
                $ordermasterDetailsData = $_POST["orderBillMasterDetails"];

                $data = json_decode($orderBillItemsData, true);
                $masterDetails = json_decode($ordermasterDetailsData, true);
                $a = array();
                $b = array();
                for ($z = 0; $z < count($masterDetails); $z++) {
                    $billNo = $this->model_mobileapi->getOrderBillNo();
                    $masterDetails[$z]["BillNo"] = $billNo;
                    $this->model_mobileapi->deleteFromMasterDetails8BByBillNo($masterDetails[$z]["local_app_user_entry_id"], $billNo);
                    $this->model_mobileapi->getQuery("MasterDetails8B", $masterDetails[$z]);
                    for ($i = 0; $i < count($data); $i++) {
                        if ($data[$i]["local_app_user_entry_id"] != $masterDetails[$z]["local_app_user_entry_id"]) {
                            // echo "aaaa";
                            continue;
                        } else {
                            // echo "bbbb";
                            $res = $this->model_mobileapi->storeOrderUser($data[$i]["itemname"], $data[$i]["price"], $data[$i]["qty"], $data[$i]["unit"], $data[$i]["party"], $data[$i]["godown"], $data[$i]["employee"], $data[$i]["date1"], $data[$i]["invno"], $data[$i]["local_app_user_entry_id"], $billNo, $data[$i]["serial_no"], $data[$i]["taxAmount"], $data[$i]["taxPercentage"], $data[$i]["itemcode"], $data[$i]["qty_in_pack"], $data[$i]["cost"]);
                            if ($res) {
                                $b["bill_no"] = $billNo;
                                $b["id"] = $data[$i]["local_app_user_entry_id"];
                                $b["status"] = 'uploaded';
                                array_push($a, $b);
                            } else {
                                $b["bill_no"] = $billNo;
                                $b["id"] = $data[$i]["local_app_user_entry_id"];
                                $b["status"] = 'pending';
                                array_push($a, $b);
                            }
                        }
                    }
                }
                echo json_encode($a);
            } else {
                $response["success"] = 0;
                $response["message"] = "Required field(s) is missing";
                echo json_encode($response);
            }
        } else {
            $response["success"] = 0;
            $response["message"] = "Something went wrong";
            echo json_encode($response);
        }
    }



    public function saveParty()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            if (isset($_POST["SaveParty"])) {
                $savePartyItems = $_POST["SaveParty"];
                $data = json_decode($savePartyItems, true);
                $a = array();
                $b = array();
                for ($i = 0; $i < count($data); $i++) {
                    $name = $data[$i]["name"];
                    $code = $data[$i]["code"];
                    $address1 = $data[$i]["address1"];
                    $address2 = $data[$i]["address2"];
                    $mobNo = $data[$i]["mobileno"];
                    $gstNumber = $data[$i]["gst_no"];
                    $stateAndCode = $data[$i]["cst_no"];
                    // $balance = $data[$i]["balance"];  
                    $balance = $data[$i]["opening"];
                    $local_app_user_entry_id = $data[$i]["local_app_user_entry_id"];
                    $partyType = $data[$i]["party_type"];
                    $user = $data[$i]["user_name"];
                    $lat = $data[$i]["latitude"];
                    $lon = $data[$i]["longitude"];
                    $location_cordinates = "($lat,$lon)";
                    $old_name = $data[$i]["temp_name"];
                    //     print_r( $old_name);
                    //    $location_cordinates = [$lat, $lon];
                    date_default_timezone_set('Asia/Kolkata');
                    $dateTime = date('Y-m-d 00:00:00', time());

                    // Step 1: Determine ledgerTypes
                    if ($partyType == "CUSTOMER") {
                        $ledgerTypes = "CUSTOMER/ SUNDRY DEBTORS";
                    } else if ($partyType == "PURCHASE PARTY") {
                        $ledgerTypes = "PURCHASE PARTY/ SUNDRY CREDITORS";
                    } else {
                        $ledgerTypes = $partyType; // fallback/default case
                    }

                    // Step 2: Get mid from mid_find()
                    $mid = $this->model_mobileapi->mid_find($partyType, $ledgerTypes);


                    // $res = $this->model_mobileapi->addNewParty(strtoupper($name), strtoupper($code), strtoupper($address1), strtoupper($address2), $mobNo, strtoupper($gstNumber), strtoupper($stateAndCode), $balance, strtoupper($user), $dateTime, $local_app_user_entry_id, strtoupper($partyType),$location_cordinates);
                    $res = $this->model_mobileapi->addNewParty(strtoupper($name), strtoupper($code), strtoupper($address1), strtoupper($address2), $mobNo, strtoupper($gstNumber), strtoupper($stateAndCode), $balance, strtoupper($user), $dateTime, $local_app_user_entry_id, strtoupper($partyType), $location_cordinates, $old_name, $mid);
                    if ($res) {
                        $b["id"] = $data[$i]["local_app_user_entry_id"];
                        $b["status"] = 'uploaded';
                        array_push($a, $b);
                    } else {
                        $b["id"] = $data[$i]["local_app_user_entry_id"];
                        $b["status"] = 'pending';
                        array_push($a, $b);
                    }
                }
                echo json_encode($a);
            } else {
                $response["success"] = 0;
                $response["message"] = "Required field(s) is missing";
                echo json_encode($response);
            }
        } else {
            $response["success"] = 0;
            $response["message"] = "Something went wrong";
            echo json_encode($response);
        }
    }

    public function savePayment()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            if (isset($_POST["usersJSON"])) {
                //    if (get_magic_quotes_gpc()) {
                //        $json = stripslashes($json);
                //    }

                $data = json_decode($_POST["usersJSON"]);
                $a = array();
                $b = array();
                //                $SiNo = $this->model_mobileapi->getSiNo();
                for ($i = 0; $i < count($data); $i++) {
                    $SiNo = $this->model_mobileapi->getSiNo();
                    $res = $this->model_mobileapi->storeCredit(strtoupper($data[$i]->party), $data[$i]->amount, $data[$i]->date1, $data[$i]->user, $data[$i]->godown, $data[$i]->transaction_type, $data[$i]->cheque_no, $data[$i]->narration, $data[$i]->local_app_user_entry_id, $SiNo);

                    if ($res) {
                        $b["id"] = $data[$i]->id;
                        $b["status"] = 'uploaded';
                        array_push($a, $b);
                    } else {
                        $b["id"] = $data[$i]->id;
                        $b["status"] = 'pending';
                        array_push($a, $b);
                    }
                }
                echo json_encode($a);
            }
        }
    }

    public function saveExpense()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            if (isset($_POST["usersJSON"])) {
                $prefix_val = isset($_POST["prefix"]) ? $_POST["prefix"] : "";

                //    if (get_magic_quotes_gpc()) {
                //        $json = stripslashes($json);
                //    }                
                $data = json_decode($_POST["usersJSON"]);
                $a = array();
                $b = array();
                //                $SiNo = $this->model_mobileapi->getSiNo();
                for ($i = 0; $i < count($data); $i++) {
                    $SiNo = $this->model_mobileapi->getSiNo();
                    $res = $this->model_mobileapi->storeExpense(strtoupper($data[$i]->party), $data[$i]->amount, $data[$i]->date1, $data[$i]->user, $data[$i]->godown, $data[$i]->transaction_type, $data[$i]->cheque_no, $data[$i]->narration, $data[$i]->local_app_user_entry_id, $SiNo, $data[$i]->TaxP, $data[$i]->TaxAmt, $prefix_val);

                    if ($res) {
                        $b["id"] = $data[$i]->id;
                        $b["status"] = 'uploaded';
                        array_push($a, $b);
                    } else {
                        $b["id"] = $data[$i]->id;
                        $b["status"] = 'pending';
                        array_push($a, $b);
                    }
                }
                echo json_encode($a);
            }
        }
    }

    public function saveTakeStockToPBill()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            if (isset($_POST["usersJSON"])) {
                //    if (get_magic_quotes_gpc()) {
                //        $json = stripslashes($json);
                //    }                
                $data = json_decode($_POST["usersJSON"]);
                $a = array();
                $b = array();
                //    $BillNo1 = $this->model_mobileapi->getInvNo();
                for ($i = 0; $i < count($data); $i++) {
                    $BillNo1 = $this->model_mobileapi->getInvNo();

                    $TaxBillNo = $this->model_mobileapi->getPBILL_TAXBillNo();
                    $fin_year = $this->model_mobileapi->getFinYearPBill();

                    $res1 = $this->model_mobileapi->storeTakeStockToPBill($BillNo1, $data[$i]->party, $data[$i]->netTotal, $data[$i]->billTime, $data[$i]->invDate, $data[$i]->totalQuantity, $data[$i]->local_app_user_entry_id, $data[$i]->employee, $data[$i]->PNetV, $data[$i]->PTaxA, $TaxBillNo, $fin_year);
                    if ($res1) {
                        // $b["id"] = $data[$i]->id;
                        $b["status"] = 'uploaded';
                        $b["BillNo"] = $BillNo1;
                        array_push($a, $b);
                    } else {
                        // $b["id"] = $data[$i]->id;
                        $b["status"] = 'pending';
                        $b["BillNo"] = $BillNo1;
                        array_push($a, $b);
                    }
                }
                echo json_encode($a);
            } else {
                $response["success"] = 0;
                $response["message"] = "Required field(s) is missing";
                echo json_encode($response);
                return;
            }
        } else {
            $response["success"] = 0;
            $response["message"] = "Something went wrong";
            echo json_encode($response);
            return;
        }
    }


    public function saveTakeStock()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            if (isset($_POST["usersJSON"])) {
                //    if (get_magic_quotes_gpc()) {
                //        $json = stripslashes($json);
                //    }                
                $data = json_decode($_POST["usersJSON"]);
                $TakeStockBillNo = $_POST["TakeStockBillNo"];
                $a = array();
                $b = array();
                //    $BillNo2 = $this->model_mobileapi->getInvNo();
                for ($i = 0; $i < count($data); $i++) {
                    // $BillNo = $this->model_mobileapi->getInvNo();
                    $res = $this->model_mobileapi->storeTakeStock($data[$i]->id, $data[$i]->itemname, $data[$i]->price, $data[$i]->qty, $data[$i]->unit, $data[$i]->itemcode, $data[$i]->pack, $data[$i]->cost, $data[$i]->MRP, $data[$i]->total, $data[$i]->PBDate, $data[$i]->EXDate, $data[$i]->local_app_user_entry_id, $data[$i]->employee, $data[$i]->PTaxP, $data[$i]->PTaxA, $data[$i]->PNetV, $i, $data[$i]->arabicname, $TakeStockBillNo);
                    if ($res) {
                        // $b["id"] = $data[$i]->id;
                        $b["status"] = 'uploaded';
                        array_push($a, $b);
                    } else {
                        // $b["id"] = $data[$i]->id;
                        $b["status"] = 'pending';
                        array_push($a, $b);
                    }
                }
                echo json_encode($a);
            } else {
                $response["success"] = 0;
                $response["message"] = "Required field(s) is missing";
                echo json_encode($response);
                return;
            }
        } else {
            $response["success"] = 0;
            $response["message"] = "Something went wrong";
            echo json_encode($response);
            return;
        }
    }

    public function saveTakeStockToCollection()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            if (isset($_POST["usersJSON"])) {
                //    if (get_magic_quotes_gpc()) {
                //        $json = stripslashes($json);
                //    }                
                $data = json_decode($_POST["usersJSON"]);
                $a = array();
                $b = array();
                //    $BillNo3 = $this->model_mobileapi->getInvNo();
                //    $BillNo3 += 1;
                for ($i = 0; $i < count($data); $i++) {

                    $TaxBillNo = $this->model_mobileapi->getPBILL_TAXBillNo();
                    $fin_year = $this->model_mobileapi->getFinYearPBill();

                    $res1 = $this->model_mobileapi->saveTakeStockToCollection($data[$i]->date1, $data[$i]->party, $data[$i]->netTotal, $data[$i]->employee, $data[$i]->local_app_user_entry_id, $data[$i]->billTime, $TaxBillNo, $fin_year);
                    if ($res1) {
                        // $b["id"] = $data[$i]->id;
                        $b["status"] = 'uploaded';
                        array_push($a, $b);
                    } else {
                        // $b["id"] = $data[$i]->id;
                        $b["status"] = 'pending';
                        array_push($a, $b);
                    }
                }
                echo json_encode($a);
            } else {
                $response["success"] = 0;
                $response["message"] = "Required field(s) is missing";
                echo json_encode($response);
                return;
            }
        } else {
            $response["success"] = 0;
            $response["message"] = "Something went wrong";
            echo json_encode($response);
            return;
        }
    }


    public function saveProduct()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            if (isset($_POST["productJSON"])) {

                $upload_typ = $_POST["upload_typ"];

                //    if (get_magic_quotes_gpc()) {
                //        $json = stripslashes($json);
                //    }


                $data = json_decode($_POST["productJSON"]);
                $a = array();
                $b = array();
                for ($i = 0; $i < count($data); $i++) {
                    $res = $this->model_mobileapi->storeProduct(strtoupper($data[$i]->itemname), $data[$i]->itemcode, $data[$i]->stock, $data[$i]->user, $data[$i]->godown, $data[$i]->base_rate_retail, $data[$i]->sec_rate_retail, $data[$i]->base_unit, $data[$i]->sec_unit, $data[$i]->category, $data[$i]->img, $data[$i]->tax, $data[$i]->base_rate_wholesale, $data[$i]->sec_rate_wholesale, $data[$i]->qty_in_pack, $data[$i]->local_app_user_entry_id, $data[$i]->Cost, $data[$i]->SecCostRate, $data[$i]->StockInMain, $data[$i]->Rate3, $data[$i]->prod_typ, $data[$i]->CostRs, $data[$i]->Disc, $data[$i]->DiscP, $data[$i]->Color, $data[$i]->ArabicName, $data[$i]->ThirdCost, $data[$i]->ThirdFirstRate, $data[$i]->ThirdUnit, $data[$i]->ThirdPack, $data[$i]->barcode, $data[$i]->temp_name, 
                    $upload_typ , $data[$i]->sec_bar , $data[$i]->third_bar);
                    //   print_r($res);
                    if ($res) {
                        $b["statusid"] = 1;
                        $b["id"] = $data[$i]->id;
                        $b["status"] = 'uploaded';
                        array_push($a, $b);
                    } else {
                        $b["statusid"] = 0;
                        $b["id"] = $data[$i]->id;
                        $b["status"] = 'pending';
                        array_push($a, $b);
                    }
                }
                echo json_encode($a);
            }
        }
    }






    public function saveDamage()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            if (isset($_POST["DamageData"])) {
                //    if (get_magic_quotes_gpc()) {
                //        $json = stripslashes($json);
                //    }
                $d = $_POST["DamageData"];

                $data = json_decode($d, true);
                $billno = $this->model_mobileapi->getInvNodamage();
                $a = array();
                $b = array();
                for ($i = 0; $i < count($data); $i++) {
                    //print_r($data[0]["itemname"]);
                    $res = $this->model_mobileapi->storeDamage($data, $billno);
                    //                    print_r($res);
                    if ($res) {
                        $b["statusid"] = 1;
                        // $b["id"] = $data[0]->id;
                        $b["status"] = 'uploaded';
                        array_push($a, $b);
                    } else {
                        $b["statusid"] = 0;
                        //  $b["id"] = $data[0]->id;
                        $b["status"] = 'pending';
                        array_push($a, $b);
                    }
                }
                echo json_encode($a);
            }
        }
    }


    public function savePurchase()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            if (isset($_POST["purchaseBillItems"]) and isset($_POST["pbillMasterDetails"])) {
                $salesBillItemsData = $_POST["purchaseBillItems"];
                $masterDetailsData = $_POST["pbillMasterDetails"];
                $collectionData = $_POST["purchasecollection"];
                //    if (get_magic_quotes_gpc()) {
                //        $salesBillItemsData = stripslashes($salesBillItemsData);
                //        $masterDetailsData = stripslashes($masterDetailsData);
                //    }



                $data = json_decode($salesBillItemsData, true);
                $masterDetails = json_decode($masterDetailsData, true);
                $collection = json_decode($collectionData, true);
                $a = array();
                $b = array();
                for ($z = 0; $z < count($masterDetails); $z++) {
                    $invoNo = $this->model_mobileapi->getPurchaseInvNo();
                    $TaxBillNo = $this->model_mobileapi->getPBILL_TAXBillNo();
                    $fin_year = $this->model_mobileapi->getFinYearPBill();

                    $masterDetails[$z]["InvoiceNo"] = $invoNo;
                    $masterDetails[$z]["TaxBillNo"] = $TaxBillNo;
                    $masterDetails[$z]["fin_year"] = $fin_year;

                    // $local_app_user_entry_id = $masterDetails[$z]["local_app_user_entry_id"];

                    $this->model_mobileapi->deleteFromPBillByInvoNo($masterDetails[$z]["local_app_user_entry_id"], $invoNo);
                    $this->model_mobileapi->getQuery("PBill", $masterDetails[$z]);
                    for ($i = 0; $i < count($data); $i++) {
                        if ($data[$i]["local_app_user_entry_id"] != $masterDetails[$z]["local_app_user_entry_id"]) {
                            continue;
                        } else {
                            $res = $this->model_mobileapi->storePurchaseBill($data[$i]["itemname"], $data[$i]["price"], $data[$i]["qty"], $data[$i]["unit"], $data[$i]["party"], $data[$i]["godown"], $data[$i]["employee"], $data[$i]["date1"], $data[$i]["invno"], $data[$i]["local_app_user_entry_id"], $invoNo, $data[$i]["serial_no"], $data[$i]["taxAmount"], $data[$i]["taxPercentage"], $data[$i]["itemcode"], $data[$i]["qty_in_pack"]);
                            if ($res) {
                                $b["bill_no"] = $invoNo;
                                $b["id"] = $data[$i]["local_app_user_entry_id"];
                                $b["status"] = 'uploaded';
                                array_push($a, $b);
                            } else {
                                $b["bill_no"] = $invoNo;
                                $b["id"] = $data[$i]["local_app_user_entry_id"];
                                $b["status"] = 'pending';
                                array_push($a, $b);
                            }
                        }
                    }
                    $this->model_mobileapi->StorePurchaseCollection($invoNo, $collection[$z]["Date1"], $collection[$z]["PartyName"], $collection[$z]["Amount"], $collection[$z]["godown"], $collection[$z]["local_app_user_entry_id"], $collection[$z]["bill_time"], $TaxBillNo, $fin_year);
                }
                echo json_encode($a);
            } else {
                $response["success"] = 0;
                $response["message"] = "Required field(s) is missing";
                echo json_encode($response);
                return;
            }
        } else {
            $response["success"] = 0;
            $response["message"] = "Something went wrong";
            echo json_encode($response);
            return;
        }
    }




    public function syncTakeStock()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            if (isset($_POST["purchaseBillItems"]) && isset($_POST["pbillMasterDetails"])) {



                $salesBillItemsData = $_POST["purchaseBillItems"];
                $masterDetailsData = $_POST["pbillMasterDetails"];
                $collectionData = $_POST["purchasecollection"];


                // $masterDetailsData = $_POST["pbillMasterDetails"];
                //  $masterDetailsData = json_decode($_POST["pbillMasterDetails"]);


                // print_r($masterDetailsData);
                // $collectionData = $_POST["purchasecollection"];
                //    if (get_magic_quotes_gpc()) {
                //        $salesBillItemsData = stripslashes($salesBillItemsData);
                //        $masterDetailsData = stripslashes($masterDetailsData);
                //    }


                // print_r('here 1.1');
                $data = json_decode($salesBillItemsData, true);

                $masterDetails = json_decode($masterDetailsData, true);


                $collection = json_decode($collectionData, true);
                $a = array();
                $b = array();

                for ($z = 0; $z < count($masterDetails); $z++) {
                    // print_r('here 3');
                    $invoNo = $this->model_mobileapi->getPurchaseInvNo();
                    $TaxBillNo = $this->model_mobileapi->getPBILL_TAXBillNo();
                    $fin_year = $this->model_mobileapi->getFinYearPBill();

                    $masterDetails[$z]["InvoiceNo"] = $invoNo;
                    $masterDetails[$z]["TaxBillNo"] = $TaxBillNo;
                    $masterDetails[$z]["fin_year"] = $fin_year;
                    //$masterDetails[$z]["InvoiceNo"] = $invoNo;
                    $this->model_mobileapi->storeTakeStockToPBill($invoNo, $masterDetails[$z]["party"], $masterDetails[$z]["netTotal"], $masterDetails[$z]["billTime"], $masterDetails[$z]["invDate"], $masterDetails[$z]["totalQuantity"], $masterDetails[$z]["local_app_user_entry_id"], $masterDetails[$z]["employee"], $masterDetails[$z]["PNetV"], $masterDetails[$z]["PTaxA"], $TaxBillNo, $fin_year);
                    // $this->model_mobileapi->storeTakeStockToPBill($invoNo,$masterDetails[$z]->party,$masterDetails[$z]->netTotal,$masterDetails[$z]->billTime,$masterDetails[$z]->invDate,$masterDetails[$z]->totalQuantity,$masterDetails[$z]->local_app_user_entry_id,$masterDetails[$z]->employee,$masterDetails[$z]->PNetV) ;
                    //$this->model_mobileapi->deleteFromPBillByInvoNo($masterDetails[$z]["local_app_user_entry_id"], $invoNo);
                    //  $this->model_mobileapi->getQuery("PBill", $masterDetails[$z]);
                    for ($i = 0; $i < count($data); $i++) {
                        if ($data[$i]["inv_no"] != $masterDetails[$z]["inv_no"]) {
                            continue;
                        } else {
                            $res = $this->model_mobileapi->SyncTakeStockPurchaseBill($data[$i]["id"], $data[$i]["itemname"], $data[$i]["price"], $data[$i]["qty"], $data[$i]["unit"], $data[$i]["itemcode"], $data[$i]["pack"], $data[$i]["cost"], $data[$i]["MRP"], $data[$i]["total"], $data[$i]["PBDate"], $data[$i]["EXDate"], $data[$i]["local_app_user_entry_id"], $data[$i]["employee"], $data[$i]["PTaxP"], $data[$i]["PTaxA"], $data[$i]["PNetV"], $i, $data[$i]["arabicname"], $invoNo);
                            // $res1 = $this->model_mobileapi->storeTakeStockToPBill($BillNo1,$data[$i]->party,$data[$i]->netTotal,$data[$i]->billTime,$data[$i]->invDate,$data[$i]->totalQuantity,$data[$i]->local_app_user_entry_id,$data[$i]->employee,$data[$i]->PNetV) ;
                            // $res = $this->model_mobileapi->storePurchaseBill($data[$i]["itemname"], $data[$i]["price"], $data[$i]["qty"], $data[$i]["unit"], $data[$i]["party"], $data[$i]["godown"], $data[$i]["employee"], $data[$i]["date1"], $data[$i]["invno"], $data[$i]["local_app_user_entry_id"], $invoNo, $data[$i]["serial_no"], $data[$i]["taxAmount"], $data[$i]["taxPercentage"], $data[$i]["itemcode"], $data[$i]["qty_in_pack"]);
                            if ($res) {
                                $b["bill_no"] = $invoNo;
                                $b["id"] = $data[$i]["local_app_user_entry_id"];
                                $b["status"] = 'uploaded';
                                array_push($a, $b);
                            } else {
                                $b["bill_no"] = $invoNo;
                                $b["id"] = $data[$i]["local_app_user_entry_id"];
                                $b["status"] = 'pending';
                                array_push($a, $b);
                            }
                        }
                    }
                    $this->model_mobileapi->StorePurchaseCollection($invoNo, $collection[$z]["date1"], $collection[$z]["party"], $collection[$z]["netTotal"], $collection[$z]["employee"], $collection[$z]["local_app_user_entry_id"], $collection[$z]["billTime"], $TaxBillNo, $fin_year);
                }
                echo json_encode($a);
            } else {
                $response["success"] = 0;
                $response["message"] = "Required field(s) is missing";
                echo json_encode($response);
                return;
            }
        } else {
            $response["success"] = 0;
            $response["message"] = "Something went wrong";
            echo json_encode($response);
            return;
        }
    }




    public function manageParty()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            if (isset($_POST["methodType"])) {
                $methodType = $_POST["methodType"];
                if ($methodType === "listParty") {
                    $data["response"] = array();
                    $data["success"] = 1;
                    $data["response"] = $this->model_mobileapi->listParty();
                    echo json_encode($data);
                } else if ($methodType === "addNewParty") {
                    $name = $_POST['name'];
                    $code = $_POST['code'];
                    $address1 = $_POST['address1'];
                    $address2 = $_POST['address2'];
                    $mobNo = $_POST['mob'];
                    $gstNumber = $_POST['gstNumber'];
                    $stateAndCode = $_POST['stateAndCode'];
                    $balance = $_POST['balance'];
                    $user = $_POST['user'];
                    date_default_timezone_set('Asia/Kolkata');
                    $dateTime = date('Y-m-d 00:00:00', time());
                    $qry = $this->model_mobileapi->addNewParty(strtoupper($name), strtoupper($code), strtoupper($address1), strtoupper($address2), $mobNo, strtoupper($gstNumber), strtoupper($stateAndCode), $balance, strtoupper($user), $dateTime);
                    if ($qry) {
                        $data["success"] = 1;
                        echo json_encode($data);
                    } else {
                        $data["success"] = 0;
                        echo json_encode($data);
                    }
                } else if ($methodType === "editParty") {
                    $name = $_POST['name'];
                    $code = $_POST['code'];
                    $address1 = $_POST['address1'];
                    $address2 = $_POST['address2'];
                    $mobNo = $_POST['mob'];
                    $gstNumber = $_POST['gstNumber'];
                    $stateAndCode = $_POST['stateAndCode'];
                    $balance = $_POST['balance'];
                    $user = $_POST['user'];
                    date_default_timezone_set('Asia/Kolkata');
                    $dateTime = date('Y-m-d 00:00:00', time());
                    $this->model_mobileapi->deleteFromMaster('CUSTOMER', $name);
                    $this->model_mobileapi->deleteFromCollection('Opening', 'CUSTOMER', $name);
                    $qry = $this->model_mobileapi->addNewParty($name, $code, $address1, $address2, $mobNo, $gstNumber, $stateAndCode, $balance, $user, $dateTime);
                    if ($qry) {
                        $data["success"] = 1;
                        echo json_encode($data);
                    } else {
                        $data["success"] = 0;
                        echo json_encode($data);
                    }
                    $data["success"] = 1;
                    echo json_encode($data);
                } else if ($methodType === "getParty") {
                    $data["success"] = 1;
                    $data["products"] = $this->model_mobileapi->getPartyByName($_POST['partyName']);
                    echo json_encode($data);
                }
            }
        }
    }

    public function sendSMS()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            if (isset($_POST["code"]) and isset($_POST["number"]) and isset($_POST["msg"])) {
                $number = $_POST['number'];
                $msg = $_POST['msg'];
                $username = "kckdental"; //use your sms api username
                $pass = "ysdAP9H5";  //enter your password
                $dest_mobileno = $number; //reciever 10 digit number (use comma (,) for multiple users. eg: 9999999999,8888888888,7777777777)
                $message = urlencode($msg); //sms content
                $senderid = "KCKSER"; //use your sms api sender id
                $url = "http://sms.rbsindia.net/api/sms?format=xml&key=cea762587be943f323fde2988919e1f1&method=MT&mobile=" . $number . "&sender=KAMBRN&route=TL&text=" . $message;
                file_get_contents($url);
                $response["success"] = 1;
                $response["message"] = "mseeg : " . $msg . "  nummmmmm  " . $number;
                echo json_encode($response);
            } else {
                $response["success"] = 0;
                $response["message"] = "Required field(s) is missing";
                echo json_encode($response);
            }
        } else {
            $response["success"] = 0;
            $response["message"] = "Something went wrong";
            echo json_encode($response);
        }
    }

    public function UpdatePriceChart()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            if (isset($_POST["price1"]) and isset($_POST["price2"]) and isset($_POST["price3"])) {
                $price1 = $_POST["price1"];
                $price2 = $_POST["price2"];
                $price3 = $_POST["price3"];
                $res1 = $this->model_mobileapi->priceChart($price1, $price2, $price3);
                $response["success"] = 1;
                $response["message"] = "Succesfully Uploaded";
                echo json_encode($response);
            } else {
                $response["success"] = 0;
                $response["message"] = "Required field(s) is missing";
                echo json_encode($response);
                return;
            }
        } else {
            $response["success"] = 0;
            $response["message"] = "Something went wrong";
            echo json_encode($response);
            return;
        }
    }

    public function saveIntransaction()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            if (isset($_POST["salesIntransItems"])) {
                $json = $_POST["salesIntransItems"];
                echo ($json);
                //    if (get_magic_quotes_gpc()) {
                //        $json = stripslashes($json);
                //    }
                $data = json_decode($json);
                $a = array();
                $b = array();
                if ($_POST['code'] == 1) {
                    for ($i = 0; $i < count($data); $i++) {
                        $res = $this->model_mobileapi->saveintrans($data[$i]->itemname, $data[$i]->qty, $data[$i]->rate, $data[$i]->total, $data[$i]->party, $data[$i]->net_qty, $data[$i]->net_amnt, $data[$i]->godown, $data[$i]->employee, $data[$i]->date1, $data[$i]->inv_no, $data[$i]->local_app_user_entry_id, $data[$i]->credit, $data[$i]->inv_no_str, $data[$i]->type);
                        $b["id"] = $data[$i]->local_app_user_entry_id;
                        $b["status"] = 'uploaded';
                        array_push($a, $b);
                    }
                    echo json_encode($a);
                }
            } else {
                $response["success"] = 0;
                $response["message"] = "Required field(s) is missing";
                echo json_encode($response);
            }
        } else {
            $response["success"] = 0;
            $response["message"] = "Something went wrong";
            echo json_encode($response);
        }
    }

    public function saveIntransactionOne()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            if (isset($_POST["salesIntransItems"]) and isset($_POST["intranscount"])) {
                $json = $_POST["salesIntransItems"];
                $json1 = $_POST["intranscount"];
                //    if (get_magic_quotes_gpc()) {
                //        $json = stripslashes($json);
                //        $json1 = stripslashes($json1);
                //    }
                $data2 = json_decode($json, true);
                $data = json_decode($json);
                $data1 = json_decode($json1, true);
                // echo json_encode($data1);
                $a = array();
                $b = array();
                for ($z = 0; $z < count($data1); $z++) {
                    $BillNo = $this->model_mobileapi->getInvNoIntrans();
                    if ($_POST['code'] == 1) {
                        for ($i = 0; $i < count($data); $i++) {
                            if ($data2[$i]["inv_no"] != $data1[$z]["inv_no"]) {
                                continue;
                            } else {
                                $res = $this->model_mobileapi->saveintrans($data[$i]->itemname, $data[$i]->qty, $data[$i]->rate, $data[$i]->total, $data[$i]->party, $data[$i]->net_qty, $data[$i]->net_amnt, $data[$i]->godown, $data[$i]->employee, $data[$i]->date1, $BillNo, $data[$i]->local_app_user_entry_id, $data[$i]->credit, $data[$i]->inv_no_str, $data[$i]->type);
                                $b["id"] = $data[$i]->local_app_user_entry_id;
                                $b["party"] = $data[$i]->party;
                                $b["status"] = 'uploaded';
                                array_push($a, $b);
                            }
                        }
                        echo json_encode($a);
                    }
                }
            } else {
                $response["success"] = 0;
                $response["message"] = "Required field(s) is missing";
                echo json_encode($response);
            }
        } else {
            $response["success"] = 0;
            $response["message"] = "Something went wrong";
            echo json_encode($response);
        }
    }

    public function getPrices()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $res = $this->model_mobileapi->getPriceOneToFiftynine();
            $res1 = $this->model_mobileapi->getPriceFiftyToSevenFour();
            $res2 = $this->model_mobileapi->getPriceSevenficeAbove();
            $a = array();
            $b = array();
            // getPriceChartPrices
            if ($res) {
                $b["desc1"] = $res;
                $b["desc2"] = $res1;
                $b["desc3"] = $res2;
                $b["previlage"] = '1';
                array_push($a, $b);
            } else {
                $b["success"] = 0;
                $b["message"] = "Required field(s) is missing";
                array_push($a, $b);
            }
            echo json_encode($a);
        } else {
            $response["success"] = 0;
            $response["message"] = "Something went wrong";
            echo json_encode($response);
        }
    }


    public function db_upload()
    {
        // Enable error reporting for debugging
        error_reporting(E_ALL);
        ini_set('display_errors', 1);

        // Check if the request is POST
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {

            // Use absolute path to avoid issues on the server
            // $upload_path = FCPATH . 'DatabaseBackup/';

            $upload_path = 'application/DatabaseBackup/';

            // Check and create directory if not exists
            if (!is_dir($upload_path)) {
                if (!mkdir($upload_path, 0777, true)) {
                    echo json_encode([
                        'success' => 0,
                        'message' => 'Failed to create upload directory.'
                    ]);
                    return;
                }
            }

            // Upload configuration
            $config['upload_path'] = $upload_path;
            $config['allowed_types'] = 'db|sql|sqlite|txt'; // Add more types if needed
            // $config['max_size'] = 128000; // 128MB
            $config['max_size'] = 307200; // 300MB
            $config['file_name'] = $this->input->post('filename'); // filename from form

            // Load upload library
            $this->load->library('upload', $config);

            // Debug: check $_FILES
            if (empty($_FILES['DbFile']['name'])) {
                echo json_encode([
                    'success' => 0,
                    'message' => 'No file selected for upload.',
                    'debug_files' => $_FILES
                ]);
                return;
            }

            // Perform the upload
            if (!$this->upload->do_upload('DbFile')) {
                echo json_encode([
                    'success' => 0,
                    'message' => 'Upload error: ' . strip_tags($this->upload->display_errors()),
                    'debug_files' => $_FILES
                ]);
            } else {
                $upload_data = $this->upload->data(); // File info
                echo json_encode([
                    'success' => 1,
                    'message' => 'upload_success',
                    'file_data' => $upload_data
                ]);
            }

        } else {
            // Invalid method
            echo json_encode([
                'success' => 0,
                'message' => 'Invalid request method. Use POST.'
            ]);
        }
    }


    // public function saveHoldItems()
    // {
    //     // Check if the request is POST
    //     if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    //         if (isset($_POST['code']) && isset($_POST["HoldBillItems"])) {
    //             try {
    //                 // Decode the JSON data from POST request
    //                 $holdItemsData = $_POST["HoldBillItems"];
    //                 $data = json_decode($holdItemsData, true);

    //                 // Initialize response arrays
    //                 $a = array();
    //                 $count = 0;

    //                 // Basic validation for necessary fields
    //                 foreach ($data as $index => $item) {
    //                     if (empty($item["party"]) || empty($item["itemname"]) || empty($item["qty"]) || empty($item["employee"])) {
    //                         throw new Exception("Missing required fields in item index: $index");
    //                     }
    //                 }

    //                 // Call the storeHold function to save all items at once
    //                 $res = $this->model_mobileapi->storeHold(
    //                     $data // Pass the entire data array
    //                 );

    //                 // Check if storeHold function executed successfully

    //                 // if (!$res) {
    //                 //     throw new Exception("Error in storing hold items.");
    //                 // } else {
    //                 //     // On success, prepare success response with itemname and status
    //                 //     foreach ($data as $item) {
    //                 //         if ($item['upload_status'] == 'pending') {
    //                 //             $b = ["status" => 'pending', "itemname" => $item['itemname']];
    //                 //         } else {
    //                 //             $b = ["status" => 'uploaded', "itemname" => $item['itemname']];
    //                 //         }
    //                 //         array_push($a, $b);
    //                 //     }
    //                 // }


    //                 if (!$res) {
    //                     foreach ($data as $item) {
    //                         $b = ["status" => 'pending', "itemname" => $item['itemname'],"party" => $item['party']];
    //                         array_push($a, $b);
    //                     }

    //                     // $b = ["itemname" => $item['itemname']];
    //                     // $response["success"] = 0;
    //                     // $response["message"] = "Error";
    //                     // $response["data"] = $b;
    //                     // echo json_encode($response);
    //                      throw new Exception("Error in storing hold items.");  // Alredy Exist This Data
    //                 } else {
    //                     // On success, prepare success response
    //                     foreach ($data as $item) {
    //                         $b = ["status" => 'uploaded', "itemname" => $item['itemname'],"party" => $item['party']];
    //                         array_push($a, $b);
    //                     }
    //                 }

    //                 // If everything is successful, commit the transaction
    //                 //              $this->db->commit();

    //                 // Return the response with success
    //                 $response["success"] = 1;
    //                 $response["message"] = "Hold items saved successfully";
    //                 $response["data"] = $a;
    //                 echo json_encode($response);
    //             } catch (Exception $e) {
    //                 // On exception, rollback transaction and send error response
    //                 $response["success"] = 0;
    //                 $response["message"] = $e->getMessage();
    //                 echo json_encode($response);
    //             }
    //         } else {
    //             // If required fields are missing
    //             $response["success"] = 0;
    //             $response["message"] = "Required field(s) is missing";
    //             echo json_encode($response);
    //         }
    //     } else {
    //         // If the request method is not POST
    //         $response["success"] = 0;
    //         $response["message"] = "Invalid request method";
    //         echo json_encode($response);
    //     }
    // }


    public function saveHoldItems()
    {
        // Check if the request method is POST
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            // Ensure 'code' and 'HoldBillItems' are present in the request
            if (isset($_POST['code']) && isset($_POST["HoldBillItems"])) {
                try {
                    // Decode HoldBillItems from the POST data
                    $holdItemsData = $_POST["HoldBillItems"];
                    $data = json_decode($holdItemsData, true);

                    // Check if HoldBillItems is empty or not a valid array
                    if (empty($data) || !is_array($data)) {
                        // Return an error if the HoldBillItems array is empty
                        $response["success"] = 1;
                        $response["status"] = false;
                        $response["message"] = "Data already inserted";
                        echo json_encode($response);
                        return; // Stop further execution
                    }

                    // Initialize response arrays and counters
                    $a = array();
                    $count = 0;

                    // Validate each item in the HoldBillItems array
                    foreach ($data as $index => $item) {
                        $missing = [];

                        if (empty($item["party"])) {
                            $missing[] = "party";
                        }
                        if (empty($item["itemname"])) {
                            $missing[] = "itemname";
                        }
                        if (empty($item["qty"])) {
                            $missing[] = "qty";
                        }
                        if (empty($item["employee"])) {
                            $missing[] = "employee";
                        }

                        if (!empty($missing)) {
                            $missingFields = implode(", ", $missing);
                            throw new Exception("Missing required field(s) [$missingFields] in item index: $index");
                        }
                    }


                    // Call the storeHold function to save all items
                    $res = $this->model_mobileapi->storeHold($data); // Pass the entire data array

                    // Check if storeHold returned false (indicating failure)
                    if (!$res) {
                        foreach ($data as $item) {
                            $b = ["status" => 'pending', "itemname" => $item['itemname'], "party" => $item['party']];
                            array_push($a, $b);
                        }
                        // throw new Exception("Error in storing hold items."); // Data may already exist

                    } else {
                        // On success, prepare the success response
                        foreach ($data as $item) {
                            $b = ["status" => 'uploaded', "itemname" => $item['itemname'], "party" => $item['party']];
                            array_push($a, $b);
                        }
                    }

                    // Return a success response with the saved items
                    $response["success"] = 1;
                    $response["status"] = true;
                    $response["message"] = "Hold items saved successfully";
                    $response["data"] = $a;
                    echo json_encode($response);

                } catch (Exception $e) {
                    // Handle any errors by returning an error response
                    $response["success"] = 0;
                    $response["message"] = $e->getMessage();
                    echo json_encode($response);
                }
            } else {
                // If required fields (code, HoldBillItems) are missing
                $response["success"] = 0;
                $response["message"] = "Required field(s) is missing";
                echo json_encode($response);
            }
        } else {
            // If the request method is not POST
            $response["success"] = 0;
            $response["message"] = "Invalid request method";
            echo json_encode($response);
        }
    }



    public function getholdbill()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            // Check if 'code' is set in the POST request
            if (isset($_POST['code'])) {
                $username = $_POST['username'];
                $data = array(
                    "success" => 1,
                    "response" => $this->model_mobileapi->getholditems()
                );
                echo json_encode($data);
            } else {
                // Response for missing 'code'
                $response = array(
                    "success" => 0,
                    "message" => "Required field(s) is missing"
                );
                echo json_encode($response);
            }
        } else {
            // Handle wrong request method
            http_response_code(405); // Method Not Allowed
            $response = array(
                "success" => 0,
                "message" => "Invalid request method"
            );
            echo json_encode($response);
        }
    }

    public function saveTest2()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {

            $a = array();
            $b = array();
            $json = file_get_contents('php://input');
            $data = json_decode($json, true);
            $billNo = $this->model_mobileapi->getBillNo();
            $sino = $this->model_mobileapi->getSiNo();
            $fin_year = $this->model_mobileapi->getFinYear();
            $masterData = $data['master'];
            // $lip_id = $masterData["local_app_user_entry_id"];
            // $this->model_mobileapi->deleteFromMasterDetailsByBillNo( $lip_id, $billNo);
            $masterData["BillNo"] = $billNo;
            $masterData["sino"] = $sino;
            $masterData["fin_year"] = $fin_year;
            $masterData["TaxBillNo"] = $billNo;


            $lip_id = $masterData["local_app_user_entry_id"];
            $this->model_mobileapi->deleteFromMasterDetailsByBillNo($lip_id, $billNo);
            //      print_r($lip_id); 
            $this->model_mobileapi->getQuery("MasterDetails", $masterData);
            if (isset($data['zatca_einv_stat'])) {
                $zatca_tbl_data = $data['zatca_einv_stat'];
                $zatca_tbl_data["bill_no"] = $billNo; // Ensure BillNo is included
                $this->model_mobileapi->deletezatca_master($lip_id, $billNo);
                $this->model_mobileapi->getQueryZatca_Einv_Table("zatca_einv_stat", $zatca_tbl_data);
            }
            $invoiceLines = $data['InvoiceLines'];

            $count = 0; // Initialize counter

            foreach ($invoiceLines as $data) {
                $res = $this->model_mobileapi->storeUser($data["itemname"], $data["price"], $data["qty"], $data["unit"], $data["party"], $data["godown"], $data["employee"], $data["date1"], $data["invno"], $data["local_app_user_entry_id"], $billNo, $data["serial_no"], $data["taxAmount"], $data["taxPercentage"], $data["itemcode"], $data["qty_in_pack"], $data["cost"], $data["disc"], $data["sqft"], $data["taxtype"], $data["NetV"]);
                if ($res) {
                    $b["bill_no"] = $billNo;
                    $b["id"] = $data["local_app_user_entry_id"];
                    $b["status"] = 'uploaded';
                    $b["previlage"] = '1';
                    $b["count"] = $count; // Set the current count value
                    //        $b["count"] = 0;
                    array_push($a, $b);
                } else {
                    $b["bill_no"] = $billNo;
                    $b["id"] = $data["local_app_user_entry_id"];
                    $b["status"] = 'pending';
                    $b["previlage"] = '1';
                    $b["count"] = $count; // Set the current count value
                    //          $b["count"] = 0;
                    $b["err"] = error_get_last();
                    array_push($a, $b);
                }

                $count++; // Increment the counter
            }


            echo json_encode($a);
        } else {
            $response["success"] = 0;
            $response["message"] = "Something went wrong";
            echo json_encode($response);
        }
    }




    public function SavePurchase_ReturnInvoice()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $a = array();
            $b = array();
            $json = file_get_contents('php://input');
            $data = json_decode($json, true);

            $billNo = $this->model_mobileapi->getMaxPrtBillNo();
            //  $sino = $this->model_mobileapi->getSiNo();
            $fin_year = $this->model_mobileapi->getPRTFinYear();
            $masterData = $data['master'];

            $masterData["RetNo"] = $billNo;
            // $masterData["sino"] = $sino;
            $masterData["fin_year"] = $fin_year;
            $masterData["TaxBillNo"] = $billNo;

            $bllnet_tot = $masterData["BillNetTotalField"];
            $bill_partyname = $masterData["BillPartyName"];
            $Employee = $masterData["godown"];
            $date1 = $masterData["BillDate"];
            $lip_id = $masterData["local_app_user_entry_id"];

            // Perform delete operations
            $this->model_mobileapi->deleteFromPRTMasterDetailsByBillNo($lip_id, $billNo);
            $this->model_mobileapi->deleteFromPRTCollectionByBillNo($lip_id, $billNo);

            print_r($lip_id); // Debugging - prints lip_id
            //          print_r($bllnet_tot);
            //          print_r($bill_partyname); 
            $this->model_mobileapi->getQuery("PRMasterDetails", $masterData);
            $this->model_mobileapi->storePurchaseReturn_COLLECTION($billNo, $date1, $bill_partyname, $bllnet_tot, $Employee, $lip_id);

            $invoiceLines = $data['InvoiceLines'];
            $count = 0; // Initialize counter

            foreach ($invoiceLines as $data) {
                $res = $this->model_mobileapi->storePurchaseRetun(
                    $data["itemname"],
                    $data["price"],
                    $data["qty"],
                    $data["unit"],
                    $data["party"],
                    $data["godown"],
                    $data["employee"],
                    $data["date1"],
                    $data["invno"],
                    $data["local_app_user_entry_id"],
                    $billNo,
                    $data["serial_no"],
                    $data["taxAmount"],
                    $data["tax"],
                    $data["itemcode"],
                    $data["qty_in_pack"]
                );

                $b["bill_no"] = $billNo;
                $b["id"] = $data["local_app_user_entry_id"];
                $b["lip_id"] = $lip_id; // Add lip_id to the response
                $b["status"] = $res ? 'uploaded' : 'pending';
                $b["previlage"] = '1';
                $b["count"] = $count; // Set the current count value

                if (!$res) {
                    $b["err"] = error_get_last(); // Add error details for failed inserts
                }

                array_push($a, $b);
                $count++; // Increment the counter
            }

            echo json_encode($a);
        } else {
            $response["success"] = 0;
            $response["message"] = "Something went wrong";
            echo json_encode($response);
        }
    }

    //Alternative Receipt

    // public function SaveReceipt_New()
    // {
    //     if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    //         echo json_encode(["success" => 0, "message" => "Invalid request method"]);
    //         return;
    //     }

    //     $json = file_get_contents('php://input');
    //     $data = json_decode($json, true);
    //     // echo json_encode($data);  // To check what data is coming in


    //     if (!$data || !is_array($data)) {
    //         echo json_encode(["success" => 0, "message" => "Invalid JSON data"]);
    //         return;
    //     }

    //     $insertedRecords = [];
    //     $count = 0;

    //     foreach ($data as $item) {
    //         if (!isset($item['collections'])) {
    //             continue;
    //         }

    //         $masterData = $item['collections'];
    //         $lip_id = $masterData["local_app_user_entry_id"];
    //         $CashFlow = $masterData["CashFlow"];

    //         // echo $lip_id;

    //         // Check if the same lip_id exists in the database
    //         $existingRecord = $this->model_mobileapi->checkExistingRecordDebit($lip_id, $CashFlow);

    //         // echo $existingRecord;

    //         if ($existingRecord) {
    //             // Delete the existing record before inserting the new one
    //             $this->model_mobileapi->deleteSinoDebitCollection($lip_id, $existingRecord['SiNo']);
    //         }

    //         // Generate Serial Number and replace "SiNo"
    //         $sino = $this->model_mobileapi->getSiNo();
    //         $masterData["SiNo"] = $sino; // Update correct key
    //         unset($masterData["sino"]); // Remove duplicate entry

    //         // echo  $masterData["SiNo"];
    //         // echo  $masterData["sino"];

    //         // Insert data into database
    //         $insertResult = $this->model_mobileapi->insertDebit("Collection", $masterData);

    //         if ($insertResult > 0) {
    //             $insertedRecords[] = [
    //                 "bill_no" => $masterData["SiNo"],
    //                 "id" => $lip_id,
    //                 "status" => 'uploaded',
    //                 "previlage" => '1',
    //                 "count" => ++$count
    //             ];
    //         } else {
    //             $insertedRecords[] = [
    //                 "bill_no" => $masterData["SiNo"],
    //                 "id" => $lip_id,
    //                 "status" => 'pending',
    //                 "previlage" => '1',
    //                 "count" => $count,
    //                 "err" => error_get_last()
    //             ];
    //         }
    //     }

    //     if ($count > 0) {
    //         echo json_encode([
    //             "success" => 1,
    //             "message" => "Records processed successfully",
    //             "data" => $insertedRecords,
    //             "count" => $count
    //         ]);
    //     } else {
    //         echo json_encode([
    //             "success" => 0,
    //             "message" => "No records processed"
    //         ]);
    //     }
    // }


    public function SaveReceipt_New2()
    {
        if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
            echo json_encode(["success" => 0, "message" => "Invalid request method"]);
            return;
        }

        $json = file_get_contents('php://input');
        $data = json_decode($json, true);

        if (!$data || !is_array($data)) {
            echo json_encode(["success" => 0, "message" => "Invalid JSON data"]);
            return;
        }

        $insertedRecords = [];
        $count = 0;
        $groupedData = [];

        // 1. Group entries by local_app_user_entry_id
        foreach ($data as $item) {
            if (!isset($item['collections']))
                continue;
            $entry = $item['collections'];
            $lip_id = $entry['local_app_user_entry_id'];

            if (!isset($groupedData[$lip_id])) {
                $groupedData[$lip_id] = [];
            }
            $groupedData[$lip_id][] = $entry;
        }

        // 2. Process each group (one customer + one bank)
        foreach ($groupedData as $lip_id => $entries) {
            // Check if already exists in DB (based on lip_id, even if 2 rows were there before)
            $existingRecord = $this->model_mobileapi->checkExistingRecordDebit($lip_id, null); // Pass null if checking without CashFlow

            if ($existingRecord) {
                $this->model_mobileapi->deleteSinoDebitCollection($lip_id, $existingRecord['SiNo']);
            }

            // Generate one SiNo for this transaction
            $sino = $this->model_mobileapi->getSiNo();

            foreach ($entries as $entry) {
                $entry["SiNo"] = $sino;
                unset($entry["sino"]);

                $insertResult = $this->model_mobileapi->insertDebit("Collection", $entry);

                if ($insertResult > 0) {
                    $insertedRecords[] = [
                        "bill_no" => $entry["SiNo"],
                        "id" => $lip_id,
                        "status" => 'uploaded',
                        "previlage" => '1',
                        "count" => ++$count
                    ];
                } else {
                    $insertedRecords[] = [
                        "bill_no" => $entry["SiNo"],
                        "id" => $lip_id,
                        "status" => 'pending',
                        "previlage" => '1',
                        "count" => $count,
                        "err" => error_get_last()
                    ];
                }
            }
        }

        if ($count > 0) {
            echo json_encode([
                "success" => 1,
                "message" => "Records processed successfully",
                "data" => $insertedRecords,
                "count" => $count
            ]);
        } else {
            echo json_encode([
                "success" => 0,
                "message" => "No records processed"
            ]);
        }
    }


    public function SaveReceipt_New()
    {
        if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
            echo json_encode(["success" => 0, "message" => "Invalid request method"]);
            return;
        }

        $json = file_get_contents('php://input');
        $data = json_decode($json, true);

        if (!$data || !is_array($data)) {
            echo json_encode(["success" => 0, "message" => "Invalid JSON data"]);
            return;
        }

        $insertedRecords = [];
        $count = 0;
        $groupedData = [];

        // Group entries by local_app_user_entry_id
        foreach ($data as $item) {
            if (!isset($item['collections']))
                continue;
            $entry = $item['collections'];
            $lip_id = $entry['local_app_user_entry_id'];
            $Typ = $entry['Typ'];

            if (!isset($groupedData[$lip_id])) {
                $groupedData[$lip_id] = [];
            }
            $groupedData[$lip_id][] = $entry;
        }

        // Insert each group with the same SiNo
        foreach ($groupedData as $lip_id => $entries) {
            $sino = $this->model_mobileapi->getSiNo();// Generate one SiNo for the group
            $prefix_val = $this->model_mobileapi->get_prefix_val();

            foreach ($entries as $entry) {
                $entry["SiNo"] = $sino;
                unset($entry["sino"]);  // Just in case
                $entry["prefix"] = (!empty($prefix_val) ? $prefix_val : "") . $sino;

                $insertResult = $this->model_mobileapi->insertDebit("Collection", $entry);

                if ($insertResult > 0) {
                    $insertedRecords[] = [
                        "bill_no" => $entry["SiNo"],
                        "id" => $lip_id,
                        "status" => 'uploaded',
                        "previlage" => '1',
                        "Typ" => $entry['Typ'],
                        "count" => ++$count
                    ];
                } else {
                    $insertedRecords[] = [
                        "bill_no" => $entry["SiNo"],
                        "id" => $lip_id,
                        "status" => 'pending',
                        "previlage" => '1',
                        "Typ" => $entry['Typ'],
                        "count" => $count,
                        "err" => error_get_last()
                    ];
                }
            }
        }

        if ($count > 0) {
            echo json_encode([
                "success" => 1,
                "message" => "Records processed successfully",
                "data" => $insertedRecords,
                "count" => $count
            ]);
        } else {
            echo json_encode([
                "success" => 0,
                "message" => "No records processed"
            ]);
        }
    }



    //Alternative payment

    public function SavePayment_New()
    {
        if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
            echo json_encode(["success" => 0, "message" => "Invalid request method"]);
            return;
        }

        $json = file_get_contents('php://input');
        $data = json_decode($json, true);

        if (!$data || !is_array($data)) {
            echo json_encode(["success" => 0, "message" => "Invalid JSON data"]);
            return;
        }

        $insertedRecords = [];
        $count = 0;

        foreach ($data as $item) {
            if (!isset($item['collections'])) {
                continue;
            }

            $masterData = $item['collections'];
            $lip_id = $masterData["local_app_user_entry_id"];

            // Check if the same lip_id exists in the database
            $existingRecord = $this->model_mobileapi->checkExistingRecordCredit($lip_id);

            if ($existingRecord) {
                // Delete the existing record before inserting the new one
                $this->model_mobileapi->deleteSinoCreditCollection($lip_id, $existingRecord['SiNo']);
            }

            // Generate Serial Number and replace "SiNo"
            $sino = $this->model_mobileapi->getSiNo();
            $masterData["SiNo"] = $sino; // Update correct key
            unset($masterData["sino"]); // Remove duplicate entry

            // Insert data into database
            $insertResult = $this->model_mobileapi->insertDebit("Collection", $masterData);

            if ($insertResult > 0) {
                $insertedRecords[] = [
                    "bill_no" => $masterData["SiNo"],
                    "id" => $lip_id,
                    "status" => 'uploaded',
                    "previlage" => '1',
                    "count" => ++$count
                ];
            } else {
                $insertedRecords[] = [
                    "bill_no" => $masterData["SiNo"],
                    "id" => $lip_id,
                    "status" => 'pending',
                    "previlage" => '1',
                    "count" => $count,
                    "err" => error_get_last()
                ];
            }
        }

        if ($count > 0) {
            echo json_encode([
                "success" => 1,
                "message" => "Records processed successfully",
                "data" => $insertedRecords,
                "count" => $count
            ]);
        } else {
            echo json_encode([
                "success" => 0,
                "message" => "No records processed"
            ]);
        }
    }


    //save company

    // public function savecompany() {
    //     if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    //         $json = file_get_contents('php://input');
    //         $data = json_decode($json, true);

    //         if (!isset($data['company'])) {
    //             echo json_encode(["success" => 0, "message" => "Invalid Data"]);
    //             return;
    //         }

    //         $masterData = $data['company'];

    //         // Perform insert or replace operation
    //         $affectedRows = $this->model_mobileapi->storecompany($masterData);

    //         if ($affectedRows > 0) {
    //             $response = ["success" => 1, "message" => "Success"];
    //         } else {
    //             $response = ["success" => 0, "message" => "Fail"];
    //         }

    //         echo json_encode($response);
    //     } else {
    //         echo json_encode(["success" => 0, "message" => "Invalid Request"]);
    //     }
    // }


    public function savecompany()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $json = file_get_contents('php://input');
            $data = json_decode($json, true);

            // Ensure data is an array and contains at least one element
            if (!is_array($data) || empty($data) || !isset($data[0]['company'])) {
                echo json_encode(["success" => 0, "message" => "Invalid Data"]);
                return;
            }

            $masterData = $data[0]['company']; // Extract first element

            // Perform insert or replace operation
            $affectedRows = $this->model_mobileapi->storecompany($masterData);

            if ($affectedRows > 0) {
                $response = ["success" => 1, "message" => "Success"];
            } else {
                $response = ["success" => 0, "message" => "Fail"];
            }

            echo json_encode($response);
        } else {
            echo json_encode(["success" => 0, "message" => "Invalid Request"]);
        }
    }

    //SaveUesPrevillageApk

    // public function SaveUserPrevillage()
    // {
    //     if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    //         // Read JSON input
    //         $json = file_get_contents('php://input');
    //         $data = json_decode($json, true);

    //         // Ensure data is an array and contains at least one element
    //         if (!is_array($data) || empty($data) || !isset($data[0]['userprevillage_apk'])) {
    //             echo json_encode(["success" => 0, "message" => "Invalid Data"]);
    //             return;
    //         }

    //         //  $masterData = $data[0]['company']; // Extract first element

    //         $masterData = $data[0]['userprevillage_apk']; // Extract first element

    //         // Perform insert or replace operation
    //         $affectedRows = $this->model_mobileapi->storeprevillage($masterData);

    //         if ($affectedRows > 0) {
    //             echo json_encode(["success" => 1, "message" => "Success"]);
    //         } else {
    //             echo json_encode(["success" => 0, "message" => "Fail"]);
    //         }
    //     } else {
    //         echo json_encode(["success" => 0, "message" => "Invalid Request"]);
    //     }
    // }


    public function SaveUserPrevillage()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            // Read JSON input
            $json = file_get_contents('php://input');
            $data = json_decode($json, true);

            // Validate JSON and required keys
            if (!is_array($data) || empty($data) || !isset($data[0]['userprevillage_apk'])) {
                echo json_encode(["success" => 0, "message" => "Invalid Data"]);
                return;
            }

            $masterData = $data[0]['userprevillage_apk'];

            // Extract user name from apk_user
            $userName = isset($masterData['apk_user']) ? trim($masterData['apk_user']) : null;

            if (!$userName) {
                echo json_encode(["success" => 0, "message" => "User name is missing"]);
                return;
            }

            // Check if user exists in MASTER table
            $this->load->database(); // Load DB if not already
            $query = $this->db->query(
                "SELECT NAME FROM " . super_model::$table_master . " WHERE Typ = 'EMPLOYEES' AND Desig = 'USER' AND NAME = ?",
                [$userName]
            );

            if ($query->num_rows() > 0) {
                // User exists, proceed with saving
                $affectedRows = $this->model_mobileapi->storeprevillage($masterData);

                if ($affectedRows > 0) {
                    echo json_encode(["success" => 1, "message" => "Success"]);
                } else {
                    echo json_encode(["success" => 0, "message" => "Fail"]);
                }
            } else {
                // User not found
                echo json_encode(["success" => 0, "message" => "User not found in database"]);
            }

            // Close the database connection
            $this->db->close();

        } else {
            echo json_encode(["success" => 0, "message" => "Invalid Request Method"]);
        }
    }


    public function getPrevilage_apk()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            if (isset($_POST["username"])) {
                $users = $this->model_mobileapi->getUserAccess_apk($_POST['username']);
                if ($users != false) {
                    $no_of_users = count($users);
                } else {
                    $no_of_users = 0;
                }
                if ($no_of_users > 0) {
                    $response["privilage"] = array();
                    for ($i = 0; $i < count($users); $i++) {
                        $privilage = array();
                        $privilage["trade_transactions"] = $users[$i]["trade_transactions"];
                        $privilage["account_entries"] = $users[$i]["account_entries"];
                        $privilage["business_identifiers"] = $users[$i]["business_identifiers"];
                        $privilage["printer_status"] = $users[$i]["printer_status"];
                        $privilage["apk_sync_stat"] = $users[$i]["apk_sync_stat"];
                        $privilage["menu_management"] = $users[$i]["menu_management"];
                        $privilage["sync_pervillage"] = $users[$i]["sync_pervillage"];
                        $privilage["zatca_access"] = $users[$i]["zatca_access"];
                        $privilage["other_identifiers"] = $users[$i]["other_identifiers"];
                        array_push($response["privilage"], $privilage);
                    }
                    $response["success"] = 1;
                    echo json_encode($response);
                } else {
                    $response["success"] = 0;
                    $response["message"] = "No Privilage found";
                    echo json_encode($response);
                }
            } else {
                $response["success"] = 0;
                $response["message"] = "Required field(s) is missing";
                echo json_encode($response);
            }
        } else {
            $response["success"] = 0;
            $response["message"] = "Something went wrong";
            echo json_encode($response);
        }
    }

    // SAVE B2C

    public function SaveInvoiceB2B()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {

            $a = array();
            $b = array();
            $json = file_get_contents('php://input');
            $data = json_decode($json, true);
            $billNo = $this->model_mobileapi->getB2CBillNo();
            $sino = $this->model_mobileapi->getSiNo();
            $fin_year = $this->model_mobileapi->getFinYearB2C();
            $masterData = $data['master'];

            // $lip_id = $masterData["local_app_user_entry_id"];
            // $this->model_mobileapi->deleteFromMasterDetailsByBillNo( $lip_id, $billNo);

            $masterData["BillNo"] = $billNo;
            $masterData["sino"] = $sino;
            $masterData["fin_year"] = $fin_year;
            $masterData["TaxBillNo"] = $billNo;


            $lip_id = $masterData["local_app_user_entry_id"];
            $this->model_mobileapi->deleteFromMasterDetails8BNEWByBillNo($lip_id, $billNo);
            //      print_r($lip_id); 

            $this->model_mobileapi->getQuery("MasterDetails8BNew", $masterData);
            if (isset($data['zatca_einv_stat'])) {
                $zatca_tbl_data = $data['zatca_einv_stat'];
                $zatca_tbl_data["bill_no"] = $billNo; // Ensure BillNo is included
                $this->model_mobileapi->deletezatca_master($lip_id, $billNo);
                $this->model_mobileapi->getQueryZatca_Einv_Table("zatca_einv_stat", $zatca_tbl_data);
            }

            $invoiceLines = $data['InvoiceLines'];

            $count = 0; // Initialize counter

            foreach ($invoiceLines as $data) {
                $res = $this->model_mobileapi->storeUserB2C($data["itemname"], $data["price"], $data["qty"], $data["unit"], $data["party"], $data["godown"], $data["employee"], $data["date1"], $data["invno"], $data["local_app_user_entry_id"], $billNo, $data["serial_no"], $data["taxAmount"], $data["taxPercentage"], $data["itemcode"], $data["qty_in_pack"], $data["cost"], $data["disc"], $data["sqft"], $data["taxtype"], $data["NetV"]);
                if ($res) {
                    $b["bill_no"] = $billNo;
                    $b["id"] = $data["local_app_user_entry_id"];
                    $b["status"] = 'uploaded';
                    $b["previlage"] = '1';
                    $b["count"] = $count; // Set the current count value
                    array_push($a, $b);
                } else {
                    $b["bill_no"] = $billNo;
                    $b["id"] = $data["local_app_user_entry_id"];
                    $b["status"] = 'pending';
                    $b["previlage"] = '1';
                    $b["count"] = $count; // Set the current count value
                    $b["err"] = error_get_last();
                    array_push($a, $b);
                }

                $count++; // Increment the counter
            }


            echo json_encode($a);
        } else {
            $response["success"] = 0;
            $response["message"] = "Something went wrong";
            echo json_encode($response);
        }
    }


    //TEST B2B

    public function saveTest2B2B_INV()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $responseArray = array();
            $json = file_get_contents('php://input');
            $data = json_decode($json, true);

            $billNo = $this->model_mobileapi->getBillNo();
            $sino = $this->model_mobileapi->getSiNo();
            $fin_year = $this->model_mobileapi->getFinYear();
            $TaxBillNo = $this->model_mobileapi->getB2B_TAXBillNo();
            $masterData = $data['master'];
            $invoiceLines = $data['InvoiceLines'];
            $local_app_user_entry_id = $masterData['local_app_user_entry_id'];

            $count = 0;
            $allSuccess = true;
            $tempResults = array();


            // ================== (1) EMPTY INVOICE LINES CHECK ======================
            if (empty($invoiceLines)) {

                $tempResults[] = [
                    "bill_no" => $billNo,
                    "id" => $local_app_user_entry_id,
                    "status" => "pending",
                    "error_message" => "No invoice lines found B2B",
                    "previlage" => '1',
                    "count" => 0
                ];

                echo json_encode([
                    "state" => false,
                    "data" => $tempResults
                ]);
                return;
            }

            // === Validate and Process Each Invoice Line ===
            foreach ($invoiceLines as $line) {
                $validationError = $this->validateInvoiceLine($line);
                $res = false;
                $errorMessage = null;

                if ($validationError) {
                    $errorMessage = $validationError;
                } else {
                    // All required fields are present; try inserting
                    $res = $this->model_mobileapi->storeUserB2B(
                        $line["itemname"],
                        $line["price"],
                        $line["qty"],
                        $line["unit"],
                        $line["party"],
                        $line["godown"],
                        $line["employee"],
                        $line["date1"],
                        $line["invno"],
                        $line["local_app_user_entry_id"],
                        $billNo,
                        $line["serial_no"],
                        $line["taxAmount"],
                        $line["taxPercentage"],
                        $line["itemcode"],
                        $line["qty_in_pack"],
                        $line["cost"],
                        $line["disc"],
                        $line["sqft"],
                        $line["taxtype"],
                        $line["NetV"]
                    );

                    if (!$res) {
                        $errorMessage = "Insertion failed (DB error)";
                    }
                }

                if (!$res) {
                    $allSuccess = false;
                }

                $tempResults[] = array(
                    "bill_no" => $billNo,
                    "id" => isset($line["local_app_user_entry_id"]) ? $line["local_app_user_entry_id"] : null,
                    "status" => $res ? "uploaded" : "pending",
                    "error_message" => $errorMessage,
                    "previlage" => '1',
                    "count" => $count
                );
                $count++;
            }

            // === All Lines OK: Proceed with master + zatca ===
            if ($allSuccess) {
                $masterData["BillNo"] = $billNo;
                $masterData["sino"] = $sino;
                $masterData["fin_year"] = $fin_year;
                $masterData["TaxBillNo"] = $TaxBillNo;

                //  Only set NewBillNo if prefix is not empty
                if (!empty($data['prefix'])) {
                    $masterData["NewBillNo"] = $data['prefix'] . $billNo;
                }

                $this->model_mobileapi->getQuery("MasterDetails", $masterData);

                if (isset($data['zatca_einv_stat'])) {
                    $zt_sino = $this->model_mobileapi->getMax_SiNoZtca();
                    $zatca_tbl_data = $data['zatca_einv_stat'];
                    $zatca_tbl_data["sino"] = $zt_sino;
                    $zatca_tbl_data["bill_no"] = $billNo;
                    $this->model_mobileapi->getQueryZatca_Einv_Table("zatca_einv_stat", $zatca_tbl_data);
                }

                echo json_encode([
                    "state" => true,
                    "data" => $tempResults
                ]);
            } else {
                // Some lines failed — return only failed lines
                $failedOnly = array_filter($tempResults, function ($entry) {
                    return $entry["status"] == "pending";
                });

                echo json_encode([
                    "state" => false,
                    "data" => array_values($failedOnly)
                ]);
            }

        } else {
            echo json_encode([
                "state" => false,
                "message" => "Invalid request method"
            ]);
        }
    }



    //SAVE B2C

    public function saveTest2B2C_INV()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $responseArray = array();
            $json = file_get_contents('php://input');
            $data = json_decode($json, true);

            $billNo = $this->model_mobileapi->getB2CBillNo();
            $sino = $this->model_mobileapi->getSiNo();
            $fin_year = $this->model_mobileapi->getFinYearB2C();
            $TaxBillNo = $this->model_mobileapi->getB2C_TAXBillNo();

            $masterData = $data['master'];
            $invoiceLines = $data['InvoiceLines'];
            $local_app_user_entry_id = $masterData['local_app_user_entry_id'];

            $count = 0;
            $allSuccess = true;
            $tempResults = array();


            // ================== (1) EMPTY INVOICE LINES CHECK ======================
            if (empty($invoiceLines)) {

                $tempResults[] = [
                    "bill_no" => $billNo,
                    "id" => $local_app_user_entry_id,
                    "status" => "pending",
                    "error_message" => "No invoice lines found B2C",
                    "previlage" => '1',
                    "count" => 0
                ];

                echo json_encode([
                    "state" => false,
                    "data" => $tempResults
                ]);
                return;
            }

            // === Validate and Process Each Invoice Line ===
            foreach ($invoiceLines as $line) {
                $validationError = $this->validateInvoiceLine($line);
                $res = false;
                $errorMessage = null;

                if ($validationError) {
                    $errorMessage = $validationError;
                } else {
                    // All required fields are present; try inserting
                    $res = $this->model_mobileapi->storeUserB2C(
                        $line["itemname"],
                        $line["price"],
                        $line["qty"],
                        $line["unit"],
                        $line["party"],
                        $line["godown"],
                        $line["employee"],
                        $line["date1"],
                        $line["invno"],
                        $line["local_app_user_entry_id"],
                        $billNo,
                        $line["serial_no"],
                        $line["taxAmount"],
                        $line["taxPercentage"],
                        $line["itemcode"],
                        $line["qty_in_pack"],
                        $line["cost"],
                        $line["disc"],
                        $line["sqft"],
                        $line["taxtype"],
                        $line["NetV"]
                    );

                    if (!$res) {
                        $errorMessage = "Insertion failed (DB error)";
                    }
                }

                if (!$res) {
                    $allSuccess = false;
                }

                $tempResults[] = array(
                    "bill_no" => $billNo,
                    "id" => isset($line["local_app_user_entry_id"]) ? $line["local_app_user_entry_id"] : null,
                    "status" => $res ? "uploaded" : "pending",
                    "error_message" => $errorMessage,
                    "previlage" => '1',
                    "count" => $count
                );
                $count++;
            }

            // === All Lines OK: Proceed with master + zatca ===
            if ($allSuccess) {
                $masterData["BillNo"] = $billNo;
                $masterData["sino"] = $sino;
                $masterData["fin_year"] = $fin_year;
                //$masterData["TaxBillNo"] = $billNo;
                $masterData["TaxBillNo"] = $TaxBillNo;

                if (!empty($data['prefix'])) {
                    $masterData["NewBillNo"] = $data['prefix'] . $billNo;
                }

                $this->model_mobileapi->getQuery("MasterDetails8BNew", $masterData);

                if (isset($data['zatca_einv_stat'])) {
                    $zt_sino = $this->model_mobileapi->getMax_SiNoZtca();
                    $zatca_tbl_data = $data['zatca_einv_stat'];
                    $zatca_tbl_data["sino"] = $zt_sino;
                    $zatca_tbl_data["bill_no"] = $billNo;
                    $this->model_mobileapi->getQueryZatca_Einv_Table("zatca_einv_stat", $zatca_tbl_data);
                }

                echo json_encode([
                    "state" => true,
                    "data" => $tempResults
                ]);
            } else {
                // Some lines failed — return only failed lines
                $failedOnly = array_filter($tempResults, function ($entry) {
                    return $entry["status"] == "pending";
                });

                echo json_encode([
                    "state" => false,
                    "data" => array_values($failedOnly)
                ]);
            }

        } else {
            echo json_encode([
                "state" => false,
                "message" => "Invalid request method"
            ]);
        }
    }


    private function validateInvoiceLine($line)
    {
        $requiredKeys = [
            "itemname",
            "price",
            "qty",
            "unit",
            "party",
            "godown",
            "employee",
            "date1",
            "invno",
            "local_app_user_entry_id",
            "serial_no",
            "taxAmount",
            "taxPercentage",
            // "itemcode",
            "qty_in_pack",
            "cost",
            "disc",
            "sqft",
            "taxtype"
        ];

        foreach ($requiredKeys as $key) {
            if (!isset($line[$key]) || $line[$key] === "") {
                return "Missing or empty key: $key";
            }
        }

        return null; // All OK
    }


    //SRT

    public function saveTest2SRT_INV()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $responseArray = array();
            $json = file_get_contents('php://input');
            $data = json_decode($json, true);

            $retNo = $this->model_mobileapi->getSRBillNo();
            $TaxBillNo = $this->model_mobileapi->getSRT_TAXBillNo();
            // $sino = $this->model_mobileapi->getSiNo();
            $fin_year = $this->model_mobileapi->getFinYearSRT();

            $masterData = $data['master'];
            $invoiceLines = $data['InvoiceLines'];

            $count = 0;
            $allSuccess = true;
            $tempResults = array();

            // === Validate and Process Each Invoice Line ===
            foreach ($invoiceLines as $line) {
                $validationError = $this->validateInvoiceLineSRT($line);
                $res = false;
                $errorMessage = null;

                if ($validationError) {
                    $errorMessage = $validationError;
                } else {
                    // All required fields are present; try inserting
                    $res = $this->model_mobileapi->SaveSalesReturnBills(
                        $line["itemname"],
                        $line["price"],
                        $line["qty"],
                        $line["unit"],
                        $line["party"],
                        $line["godown"],
                        $line["employee"],
                        $line["date1"],
                        $line["invno"],
                        $line["local_app_user_entry_id"],
                        $retNo,
                        $line["serial_no"],
                        $line["taxAmount"],
                        $line["taxPercentage"],
                        $line["itemcode"],
                        $line["qty_in_pack"],
                        $line["cost"],
                        $line["disc"],
                        // $line["sqft"],
                        $line["taxtype"]
                    );

                    if (!$res) {
                        $errorMessage = "Insertion failed (DB error)";
                    }
                }

                if (!$res) {
                    $allSuccess = false;
                }

                $tempResults[] = array(
                    "bill_no" => $retNo,
                    "id" => isset($line["local_app_user_entry_id"]) ? $line["local_app_user_entry_id"] : null,
                    "status" => $res ? "uploaded" : "pending",
                    "error_message" => $errorMessage,
                    "previlage" => '1',
                    "count" => $count
                );
                $count++;
            }

            // === All Lines OK: Proceed with master + zatca ===
            if ($allSuccess) {
                $masterData["RetNo"] = $retNo;
                // $masterData["sino"] = $sino;
                $masterData["fin_year"] = $fin_year;
                $masterData["TaxBillNo"] = $TaxBillNo;

                $this->model_mobileapi->getQuerySRmasterdetails("SRMasterDetails", $masterData);

                // Save collection record
                $this->model_mobileapi->SaveSalesRetunCollection(
                    $retNo,
                    $masterData["BillDate"],
                    $masterData["BillPartyName"],
                    $masterData["BillTotalField"],
                    $masterData["BillNetTotalField"],
                    $masterData["Employee"], // or use "Employee" if needed
                    $masterData["godown"],
                    $masterData["local_app_user_entry_id"],
                    $masterData["TaxAmt"],
                    $masterData["fin_year"],
                    $masterData["TaxBillNo"]


                );

                // Handle ZATCA

                if (isset($data['zatca_einv_stat'])) {
                    $zt_sino = $this->model_mobileapi->getMax_SiNoZtca();
                    $zatca_tbl_data = $data['zatca_einv_stat'];
                    $zatca_tbl_data["sino"] = $zt_sino;
                    $zatca_tbl_data["bill_no"] = $retNo;
                    $zatca_tbl_data["bill_form"] = "Sales Return";
                    $this->model_mobileapi->getQueryZatca_Einv_Table("zatca_einv_stat", $zatca_tbl_data);
                }

                echo json_encode([
                    "state" => true,
                    "data" => $tempResults
                ]);
            } else {
                // Some lines failed — return only failed lines
                $failedOnly = array_filter($tempResults, function ($entry) {
                    return $entry["status"] == "pending";
                });

                echo json_encode([
                    "state" => false,
                    "data" => array_values($failedOnly)
                ]);
            }

        } else {
            echo json_encode([
                "state" => false,
                "message" => "Invalid request method"
            ]);
        }
    }

    private function validateInvoiceLineSRT($line)
    {
        $requiredKeys = [
            "itemname",
            "price",
            "qty",
            "unit",
            "party",
            "godown",
            "employee",
            "date1",
            "invno",
            "local_app_user_entry_id",
            "serial_no",
            "taxAmount",
            "taxPercentage",
            // "itemcode",
            "qty_in_pack",
            "cost",
            "disc",
            "taxtype"
        ];

        foreach ($requiredKeys as $key) {
            if (!isset($line[$key]) || $line[$key] === "") {
                return "Missing or empty key: $key";
            }
        }

        return null; // All OK
    }



    public function saveInvoiceB2C()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            if (isset($_POST['code']) and isset($_POST["salesBillItems"]) and isset($_POST["salesBillMasterDetails"])) {
                try {
                    // Start the transaction
                    $this->model_mobileapi->beginTransaction();

                    $salesBillItemsData = $_POST["salesBillItems"];
                    $masterDetailsData = $_POST["salesBillMasterDetails"];
                    $salesBillCollectionBank = $_POST["salesBillCollectionBank"];
                    $prefix = isset($_POST['prefix']) ? $_POST['prefix'] : "";

                    $data = json_decode($salesBillItemsData, true);
                    $masterDetails = json_decode($masterDetailsData, true);
                    $bankData = json_decode($salesBillCollectionBank, true);

                    $cnt = 0;
                    //   if ($_POST['code'] == 1) {
                    //   $previlage = $this->model_mobileapi->getSynPrevilage($_POST['user']);
                    //  if ($previlage == 1) {
                    $a = array();
                    $b = array();
                    $count = 0;
                    $fin_year = $this->model_mobileapi->getFinYearB2C();
                    for ($z = 0; $z < count($masterDetails); $z++) {
                        $cnt++;
                        $billNo = $this->model_mobileapi->getB2CBillNo();
                        $sino = $this->model_mobileapi->getSiNo();
                        $TaxBillNo = $this->model_mobileapi->getB2C_TAXBillNo();
                        $masterDetails[$z]["BillNo"] = $billNo;
                        $masterDetails[$z]["sino"] = $sino;
                        $masterDetails[$z]["fin_year"] = $fin_year;
                        $masterDetails[$z]["TaxBillNo"] = $TaxBillNo;

                        if ($prefix != "") {
                            $masterDetails[$z]["NewBillNo"] = $prefix . $billNo;
                        }

                        if ($masterDetails[$z]["advance"] == 0) {
                            $masterDetails[$z]["sino"] = 0;
                        }
                        $this->model_mobileapi->deleteFromMasterDetails8BNEW_ByBillNo($masterDetails[$z]["local_app_user_entry_id"], $billNo);


                        // Execute the first query within the transaction
                        $this->model_mobileapi->getQuery("MasterDetails8BNew", $masterDetails[$z]);

                        $stat = isset($_POST['stat']) ? $_POST['stat'] : 0;   // ZATCA_EINV_STAT

                        if ($stat == 1) {
                            if (!isset($_POST["zatca_einv_stat_items"])) {
                                die("ZATCA data not provided.");
                            }

                            $zatca_bill_dtls = $_POST["zatca_einv_stat_items"];
                            $zatca_datas = json_decode($zatca_bill_dtls, true);

                            if (json_last_error() !== JSON_ERROR_NONE) {
                                die("Invalid JSON in zatca_einv_stat_items: " . json_last_error_msg());
                            }

                            if (!empty($zatca_datas)) {
                                foreach ($zatca_datas as $zd) {
                                    $zt_sino = $this->model_mobileapi->getMax_SiNoZtca();
                                    $zd["sino"] = $zt_sino;
                                    $zd["bill_no"] = $billNo;

                                    $this->model_mobileapi->getQueryZatca_Einv_Table("zatca_einv_stat", $zd);
                                }
                            }
                        }



                        $sino = $this->model_mobileapi->getSiNo();
                        for ($i = 0; $i < count($bankData); $i++) {
                            if ($bankData[$i]["local_app_user"] != $masterDetails[$z]["local_app_user_entry_id"]) {
                                continue;
                            } else {
                                $this->model_mobileapi->saveCollectionBank($billNo, $bankData[$z]["TransactionType"], $sino, $bankData[$z]["Date"], $bankData[$z]["PartyName"], $bankData[$z]["NetTotal"], $bankData[$z]["Type"], $bankData[$z]["CashFlow"], $bankData[$z]["local_app_user"], $bankData[$z]["Narration"]);
                            }
                        }


                        // Execute the second query within the transaction
                        for ($i = 0; $i < count($data); $i++) {
                            // ... (your existing code)


                            if ($data[$i]["local_app_user_entry_id"] != $masterDetails[$z]["local_app_user_entry_id"]) {
                                continue;
                            } else {
                                $res = $this->model_mobileapi->storeUserB2Cdata($data[$i]["itemname"], $data[$i]["price"], $data[$i]["qty"], $data[$i]["unit"], $data[$i]["party"], $data[$i]["godown"], $data[$i]["employee"], $data[$i]["date1"], $data[$i]["invno"], $data[$i]["local_app_user_entry_id"], $billNo, $data[$i]["serial_no"], $data[$i]["taxAmount"], $data[$i]["taxPercentage"], $data[$i]["itemcode"], $data[$i]["qty_in_pack"], $data[$i]["cost"], $data[$i]["disc"], $data[$i]["sqft"], $data[$i]["taxtype"], $data[$i]["NetV"]);
                                if (!$res) {
                                    $this->model_mobileapi->rollBack(); //newly added in 7/19/24
                                    $b["bill_no"] = $billNo;
                                    $b["id"] = $data[$i]["local_app_user_entry_id"];
                                    $b["status"] = 'pending';
                                    $b["previlage"] = '1';
                                    $b["count"] = $cnt;
                                    $b["err"] = error_get_last();
                                    array_push($a, $b);
                                    // If an error occurs, throw an exception to roll back the transaction
                                    throw new Exception("Error in storeUser");
                                } else {
                                    $b["bill_no"] = $billNo;
                                    $b["id"] = $data[$i]["local_app_user_entry_id"];
                                    $b["status"] = 'uploaded';
                                    $b["previlage"] = '1';
                                    $b["count"] = $cnt;
                                    array_push($a, $b);
                                }
                            }
                        }



                        // Commit the changes for this iteration of the loop
                        // $this->model_mobileapi->commit();
                        // echo json_encode($a);
                    }

                    // Commit the entire transaction
                    $this->model_mobileapi->commit();

                    $this->model_mobileapi->updateSyncActivationStatus($_POST['user']);
                    // }else{
                    //     $a = array();
                    //     $b = array();
                    //     $b["bill_no"] = '0';
                    //     $b["id"] = '0';
                    //     $b["status"] = 'Update user sync sales bill Privilage !!';
                    //     $b["previlage"] = '-1';
                    //     array_push($a, $b);
                    // }
                    echo json_encode($a);
                    //     }//post code
                } catch (Exception $e) {
                    // An error occurred, roll back the transaction
                    $this->model_mobileapi->rollBack();

                    // Handle the exception or log the error
                    $b["bill_no"] = $billNo;
                    $b["id"] = $data[$i]["local_app_user_entry_id"];
                    $b["status"] = 'pending';
                    $b["previlage"] = '1';
                    $b["count"] = $cnt;
                    $b["err"] = error_get_last();
                    array_push($a, $b);
                    echo json_encode($a);
                }
            } else {
                $response["success"] = 0;
                $response["message"] = "Required field(s) is missing";
                echo json_encode($response);
            }
        } else {
            $response["success"] = 0;
            $response["message"] = "Something went wrong";
            echo json_encode($response);
        }
    }

    public function getholdbill_partywise()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            // Check if 'code' is set in the POST request
            if (isset($_POST['party'])) {
                $username = $_POST['user'];
                $party = $_POST['party'];
                $data = array(
                    "success" => 1,
                    "response" => $this->model_mobileapi->getholditems_party($party)
                );
                echo json_encode($data);
            } else {
                // Response for missing 'code'
                $response = array(
                    "success" => 0,
                    "message" => "Required field(s) is missing"
                );
                echo json_encode($response);
            }
        } else {
            // Handle wrong request method
            http_response_code(405); // Method Not Allowed
            $response = array(
                "success" => 0,
                "message" => "Invalid request method"
            );
            echo json_encode($response);
        }
    }

    public function delete_product()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            if (isset($_POST['itemname'])) {
                $itemname = $_POST['itemname'];
                $this->model_mobileapi->delete_product_cloud($itemname);
                $response["success"] = 1;
                $response["billNo"] = $itemname;
                $response["message"] = "Product Deleted";
                echo json_encode($response);
            } else {
                $response["success"] = 0;
                $response["message"] = "Product not Deleted";
                echo json_encode($response);
            }
        } else {
            $response["success"] = 0;
            $response["message"] = "Something went wrong";
            echo json_encode($response);
        }
    }

    public function saveCategory()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            if (isset($_POST['categoryName'])) {
                $categoryName = $_POST['categoryName'];
                $mode = $_POST['mode'];
                $oldName = $_POST['oldName'];

                if ($mode == "insert") {
                    $this->model_mobileapi->saveCategory($categoryName);
                    $response["success"] = 1;
                    $response["message"] = "Category  Added Succesfull";
                    echo json_encode($response);
                } else if ($mode == "update") {
                    $this->model_mobileapi->updateCategory($categoryName, $oldName);
                    $response["success"] = 1;
                    $response["message"] = " Category Updated Succesfull";
                    echo json_encode($response);
                } else {
                    $this->model_mobileapi->DeleteCategory($categoryName);
                    $response["success"] = 1;
                    $response["message"] = " Category Deleted Succesfull";
                    echo json_encode($response);
                }

            } else {
                $response["success"] = 0;
                $response["message"] = "Category Added Failed";
                echo json_encode($response);
            }
        } else {
            $response["success"] = 0;
            $response["message"] = "Something went wrong";
            echo json_encode($response);
        }
    }


        public function updateProduct()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            if (isset($_POST["productJSON"])) {

                $upload_typ = $_POST["upload_typ"];
                $data = json_decode($_POST["productJSON"]);
                $a = array();
                $b = array();
                for ($i = 0; $i < count($data); $i++) {
                    $res = $this->model_mobileapi->update_Product(strtoupper($data[$i]->itemname), $data[$i]->itemcode, $data[$i]->stock, $data[$i]->user, $data[$i]->godown, $data[$i]->base_rate_retail, $data[$i]->sec_rate_retail, $data[$i]->base_unit, $data[$i]->sec_unit, $data[$i]->category, $data[$i]->img, $data[$i]->tax, $data[$i]->base_rate_wholesale, $data[$i]->sec_rate_wholesale, $data[$i]->qty_in_pack, $data[$i]->local_app_user_entry_id, $data[$i]->Cost, $data[$i]->SecCostRate, $data[$i]->StockInMain, $data[$i]->Rate3, $data[$i]->prod_typ, $data[$i]->CostRs, $data[$i]->Disc, $data[$i]->DiscP, $data[$i]->Color, $data[$i]->ArabicName, $data[$i]->ThirdCost, $data[$i]->ThirdFirstRate, $data[$i]->ThirdUnit, $data[$i]->ThirdPack, $data[$i]->barcode, $data[$i]->temp_name, 
                    $upload_typ , $data[$i]->sec_bar , $data[$i]->third_bar);
                    //   print_r($res);
                    if ($res) {
                        $b["statusid"] = 1;
                        $b["id"] = $data[$i]->id;
                        $b["status"] = 'uploaded';
                        array_push($a, $b);
                    } else {
                        $b["statusid"] = 0;
                        $b["id"] = $data[$i]->id;
                        $b["status"] = 'pending';
                        array_push($a, $b);
                    }
                }
                echo json_encode($a);
            }
        }
    }





}
