<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class SuperCtrl extends CI_Controller {

    public static $appName = 'Easy-Invoice';

    public function __construct() {
        // Call the CI_Model constructor
        parent::__construct();
        $this->load->library('session');
        $this->load->helper('form');
        $this->load->library('encrypt');
        $this->load->model('model_user');
    }
     public function getLoggedUserLevel() {
        $sess = ($this->getSessionData());
        if (isset($sess)) {
            return $sess["session"]["user_level"];
        } else {
            return FALSE;
        }
    }
    public function pageLoadBy($view, $data = array(), $key = -1) {
        $data['appName'] = SuperCtrl::$appName;
        $this->load->view($view, $data);
    }
    public  function clean($string) {
        $string = str_replace(' ', '-', $string); // Replaces all spaces with hyphens.
        return preg_replace('/[^A-Za-z0-9\-]/', '', $string); // Removes special chars.
    }
    public function preparePageBy($view, $data = array(), $key = -1) {
        $sess = $this->session->all_userdata(); //$this->getSessionData();
        if (isset($sess['session']['uid'])) {
            $data['appName'] = SuperCtrl::$appName;
            $data['userDetails'] = $this->model_user->getUserByUid($sess['session']['uid']);
//            $data['userBalanceAmount'] = $userDetails['balance_amt'];
            $data['view'] = $view;
            $this->load->view('view_binder', $data);
        } else {
            $this->pageLoadBy('view_login', $data);
        }
    }

    public function encrypt($param) {
        return $this->encrypt->encode($param);
    }

    public function decrypt($param) {
        return $this->encrypt->decode($param);
    }

    public function destroySession() {
        $this->session->sess_destroy();
        return true;
    }

    public function loadDataToSession($data) {
        $this->session->set_userdata("session", $data);
    }

    public function getSessionData() {
        $data = $this->session->all_userdata();
        if (isset($data['session'])) {
            return $data;
        } else {
            return false;
        }
    }

    public function do_image_upload($fileInputFieldName, $type) {//$type gif|jpg|png
        $uploadfolder = date("Y-m");
        $uploadpath = 'jr_files' . DIRECTORY_SEPARATOR;
        if (!is_dir($uploadpath . $uploadfolder)) {
            // creating month-year folder to upload item  image 
            mkdir($uploadpath . $uploadfolder, 0777, TRUE);
        }
        $fullPath = $uploadpath . DIRECTORY_SEPARATOR . $uploadfolder;
        $config['upload_path'] = $fullPath;
        $config['allowed_types'] = $type;
        $config['max_size'] = 5024;
        $config['max_width'] = 5024;
        $config['max_height'] = 5024;
        $config['overwrite'] = TRUE;
        $this->load->library('upload', $config);

        if (!$this->upload->do_upload($fileInputFieldName)) {
            $error = array('error' => $this->upload->display_errors());
//            $this->load->view('upload_form', $error);
            print_r($error);
            return 0;
        } else {
            $data = array('upload_data' => $this->upload->data());
            $fileDetails['path'] = DIRECTORY_SEPARATOR . "jr_files" . DIRECTORY_SEPARATOR . $uploadfolder . DIRECTORY_SEPARATOR . $data['upload_data']['file_name'];
            $fileDetails['extension'] = $file_ext = pathinfo($fileDetails['path'], PATHINFO_EXTENSION);
            return $fileDetails;
        }
    }

    public function getCurrentDateTime() {
        date_default_timezone_set('Asia/Kolkata');
        $dateTime = date('Y-m-d h:i:s', time());
        return $dateTime;
    }

    public function getCurrentDate() {
        $date = date('Y-m-d', time());
        return $date;
    }

    public function manipulateDate($operation, $inputDate, $criteria, $outputFormat, $value) {
        $effectiveDate = $inputDate;
        $noOfMonths = $value;
        $effectiveDate = strtotime($operation . $noOfMonths . " " . $criteria, strtotime($effectiveDate));
        $effectiveDate = strftime($outputFormat, $effectiveDate);
        return $effectiveDate;
        /*
          outputFormat '%Y-%m-%d'
          operation   + or -
          inputDate yyyy/MM/dd
          criteria months or years or days
          value
         */
    }

    public function compareDates($d1, $d2) {
        if (strtotime($d1) > strtotime($d2)) {
            return true;
        } else {
            return false;
        }
    }

    public function send_mail($toEmail, $password) {
        $this->load->library('email');
        $this->email->initialize(array(
            //'protocol' => 'smtp',
            'smtp_host' => 'relay-hosting.secureserver.net',
            'smtp_user' => 'skydentRecovery@gmail.com',
            'smtp_pass' => 'alpha147',
            'smtp_port' => 25,
            'crlf' => "\r\n",
            'newline' => "\r\n"
        ));

        $this->email->from('skydentRecovery@gmail.com', 'Skydent Team');
        $this->email->to($toEmail);
//        $this->email->cc('another@another-example.com');
//        $this->email->bcc('them@their-example.com');
        $this->email->subject('Skydent App Password');
        $this->email->message('Your Password: ' . $password);
        $this->email->send();

        // echo $this->email->print_debugger();
    }

}

/* NOTE
 * to enable base_url(): add $autoload['helper'] = array('url'); in config/autoload.php 
 * 
 * AUTOLOAD possibilities:
 * $autoload['libraries'] = array('database', 'session', 'parser'); $autoload['helper'] = array('url', 'form');
 * 
 * 
 */