<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');


if (!function_exists('setInfoFromArray')) {

    function setInfoFromArray($inputArray, $blockId) {
        $error = 'noerror';
        $outputArray = array();
        foreach ($inputArray as $key => $value) {
            if ($key === "pid") {
                continue;
            }
            if ($key === "title" || $key === "pid" || $key === "description" || $key === "keywords") {
                continue;
            }
            $index = count($outputArray) === 0 ? 0 : count($outputArray) + 1;
            if (isset($value)) {
                $outputArray[$index] = array(
                    "pid" => $inputArray['pid'],
                    "param_key" => $key,
                    "param_value" => $inputArray[$key],
                    "block_id" => $blockId
                );
            } else {
                $error = "Product Information is not valid";
                break;
            }
        }
        return $outputArray;
    }

}

if (!function_exists('prepareProductInfo')) {

    function prepareProductInfo($resultArray) {
        $pid = -10;
        $count = 0;
        $data['productDetails'] = array();
        $data['OutProductDetails'] = array();
        foreach ($resultArray as $key => $value) {
            foreach ($resultArray[$key] as $key2 => $value2) {
                if ($key2 === "pid") {
                    if ($resultArray[$key][$key2] != $pid) {
                        $pid = $resultArray[$key][$key2];
                    }
                }
                $data['productDetails'][$pid][$key2] = $resultArray[$key][$key2];
                $data['productDetails'][$pid][$resultArray[$key]['param_key']] = $resultArray[$key]['param_value'];
            }
        }
        foreach ($data['productDetails'] as $key => $value) {
            $data['OutProductDetails'][$count] = $data['productDetails'][$key];
            $count++;
        }
        return $data['OutProductDetails'];
    }

}



if (!function_exists('prepareProductInfoById')) {

    function prepareProductInfoById($resultArray) {
        $count = 0;
        $data['productDetails'] = array();
        foreach ($resultArray as $key => $value) {
            foreach ($resultArray[$key] as $key2 => $value2) {
                $data['productDetails'][$key2] = $resultArray[$key][$key2];
                $data['productDetails'][$resultArray[$key]['param_key']] = $resultArray[$key]['param_value'];
            }
            $count++;
        }
        return $data['productDetails'];
    }

}
