<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Firebase {
    
    var $FIREBASE;
    
    function __construct($firebase_url){
        $this->FIREBASE = $firebase_url[0];
    }
    
    public function insert($path, $data){
        $curl = curl_init();
        if(is_array($data)){
            $json = json_encode( $data );
            // Initialize cURL
            curl_setopt( $curl, CURLOPT_URL, $this->FIREBASE . $path . ".json" );
            curl_setopt( $curl, CURLOPT_CUSTOMREQUEST, "PUT" );
            curl_setopt( $curl, CURLOPT_POSTFIELDS, $json );//or $data
        }else{
            curl_setopt( $curl, CURLOPT_URL, $this->FIREBASE . $path . ".json" );
            curl_setopt( $curl, CURLOPT_CUSTOMREQUEST, "PUT" );
            curl_setopt( $curl, CURLOPT_POSTFIELDS, $data );
            
        }
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt( $curl, CURLOPT_RETURNTRANSFER, true );
        $response = curl_exec( $curl );
        curl_close( $curl );
    }
    
    function update($path,$data){
        $curl = curl_init();
        if(is_array($data)){
            $json = json_encode( $data );
            // Initialize cURL
            curl_setopt( $curl, CURLOPT_URL, $this->FIREBASE . $path . ".json" );
            curl_setopt( $curl, CURLOPT_CUSTOMREQUEST, "PATCH" );
            curl_setopt( $curl, CURLOPT_POSTFIELDS, $json );
        }else{
            curl_setopt( $curl, CURLOPT_URL, $this->FIREBASE . $path . ".json");
            curl_setopt( $curl, CURLOPT_CUSTOMREQUEST, "PATCH" );
            curl_setopt( $curl, CURLOPT_POSTFIELDS, $data );
        }
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt( $curl, CURLOPT_RETURNTRANSFER, true );
        $response = curl_exec( $curl );
        curl_close( $curl );
    }
    
    function delete($path){
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt( $curl, CURLOPT_URL, $this->FIREBASE . $path.".json" );
        curl_setopt( $curl, CURLOPT_CUSTOMREQUEST, "DELETE" );
        curl_setopt( $curl, CURLOPT_RETURNTRANSFER, true );
        $response = curl_exec( $curl );
        curl_close( $curl );
    }
    
    function get($path){
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt( $curl, CURLOPT_URL, $this->FIREBASE . $path . ".json" );
        curl_setopt( $curl, CURLOPT_RETURNTRANSFER, true );
        $response = curl_exec( $curl );
        curl_close( $curl );
        return json_decode($response, TRUE);
    }
    
}