<?php

require_once('super_model.php');

class Model_mobileapi extends super_model
{

    public function varifyAppUser($username, $password)
    {
        $query1 = $this->db->query("SELECT *, COUNT(*) AS cnt FROM " . super_model::$table_users . " WHERE PassWord=" . $this->db->escape($password) . " AND Typ=" . $this->db->escape($username) . " GROUP BY UName");
        $row1 = $query1->result_array();
        $counter = $row1[0]['cnt'];
        if ($counter > 0) {
            $query2 = $this->db->query("SELECT Name, Code FROM " . super_model::$table_master . " WHERE Name=" . $this->db->escape($username));
            if ($row2 = $query2->result_array()) {
                $query3 = $this->db->query("SELECT MAX(BillNo) AS BillNo,NewBillNo  FROM " . super_model::$table_master_details . " WHERE Lorry = '$username'");
                //   $query3 = $this->db->query("SELECT BillNo, NewBillNo FROM " . super_model::$table_master_details . " WHERE BillNo IN (SELECT MAX(BillNo) AS BillNo FROM " . super_model::$table_master_details . " WHERE Lorry = '$username' )");
                if ($row3 = $query3->result_array()) {
                    if ($row3[0]['BillNo'] == null || $row3[0]['NewBillNo'] == null) {
                        $result['BillNo'] = "0";
                        $result['NewBillNo'] = "0";
                    } else {
                        $result['BillNo'] = $row3[0]['BillNo'];
                        $result['NewBillNo'] = $row3[0]['NewBillNo'];
                    }
                    $result['cnt'] = $row1[0]['cnt'];
                    $result['Success'] = 1;
                    $result['Name'] = $row2[0]['Name'];
                    $result['Code'] = $row2[0]['Code'];
                    return $result;
                } else {
                    $result['BillNo'] = "0";
                    $result['NewBillNo'] = "0";
                    $result['cnt'] = $row1[0]['cnt'];
                    $result['Success'] = 1;
                    return $result;
                }
            } else {
                $result['cnt'] = 0;
                $result['Success'] = 0;
                return $result;
            }
        } else {
            $result['cnt'] = 0;
            $result['Success'] = 0;
            return $result;
        }
    }





    public function getPartyWithBalance()
    {
        $data = array();
        $query1 = $this->db->query("SELECT `Name`, `Code`, `Ph`, `CstNo`, `TinNo`, `Typ` ,`Address1`, `Address2`, `emp`,`outlet`, `credit_limit`, `location`,second_name FROM " . super_model::$table_master . " WHERE Name !='Cash' AND Name !='3'
        AND Typ IN('CUSTOMER','PURCHASE PARTY','EMPLOYEES','BANK ACCOUNT','BANK','EXPENSE') GROUP BY `Name` ORDER BY `Name` ASC");
        // $query1 = $this->db->query("SELECT `Name`, `Code`, `Ph`, `CstNo`, `TinNo`, `Typ` ,`Address1`, `Address2`, `emp`,`outlet`, `credit_limit` FROM " . super_model::$table_master . " WHERE Name !='Cash' AND Name !='3' GROUP BY `Name` ORDER BY `Name` ASC");
        $masterResult = $query1->result_array();
        for ($x = 0; $x < count($masterResult); $x++) {
            $i = $masterResult[$x]['Name'];
            $data[$i]["Name"] = $masterResult[$x]["Name"];
            $data[$i]["Code"] = $masterResult[$x]["Code"];
            $data[$i]["Ph"] = $masterResult[$x]["Ph"];
            $data[$i]["CstNo"] = $masterResult[$x]["CstNo"];
            $data[$i]["TinNo"] = $masterResult[$x]["TinNo"];
            $data[$i]["party_type"] = $masterResult[$x]["Typ"];
            $data[$i]["Address1"] = $masterResult[$x]["Address1"];
            $data[$i]["emp"] = $masterResult[$x]["emp"];
            $data[$i]["Opening"] = '0';
            $data[$i]["outlet"] = $masterResult[$x]["outlet"];
            $data[$i]["credit_limit"] = $masterResult[$x]["credit_limit"];
            $data[$i]["location"] = $masterResult[$x]["location"];
            $data[$i]["second_name"] = $masterResult[$x]["second_name"];
            $data[$i++]["Address2"] = $masterResult[$x]["Address2"];
        }
        $query2 = $this->db->query("SELECT PartyName, (SUM(NetTotal)-SUM(Amount)) AS Opening,(SUM(Amount)-SUM(NetTotal)) AS Opening2  FROM " . super_model::$table_collection . " GROUP BY PartyName");
        $collectionResult = $query2->result_array();
        for ($j = 0; $j < count($collectionResult); $j++) {
            if (isset($data[$collectionResult[$j]['PartyName']])) {
                $data[$collectionResult[$j]['PartyName']]['Opening'] = $collectionResult[$j]['Opening'];
                if ($data[$collectionResult[$j]['PartyName']]['party_type'] == "PURCHASE PARTY") {
                    $data[$collectionResult[$j]['PartyName']]['Opening'] = $collectionResult[$j]['Opening2'];
                }
            }
        }
        return $data;
    }



    public function getPartyWithBalanceNew()
    {
        $data = array();
        $query = $this->db->query("
            SELECT m.`Name`, m.`Code`, m.`Ph`, m.`CstNo`, m.`TinNo`, m.`Typ`, m.`Address1`, m.`Address2`, m.`emp`, m.`outlet`,
                   COALESCE(SUM(c.NetTotal - c.Amount), 0) AS Opening
            FROM " . super_model::$table_master . " AS m
            LEFT JOIN " . super_model::$table_collection . " AS c ON m.`Name` = c.PartyName
            WHERE m.`Name` != 'Cash' AND m.`Name` != '3'
            GROUP BY m.`Name`
            ORDER BY m.`Name` ASC
        ");
        $result = $query->result_array();
        foreach ($result as $row) {
            $data[$row['Name']] = [
                'Name' => $row['Name'],
                'Code' => $row['Code'],
                'Ph' => $row['Ph'],
                'CstNo' => $row['CstNo'],
                'TinNo' => $row['TinNo'],
                'party_type' => $row['Typ'],
                'Address1' => $row['Address1'],
                'Address2' => $row['Address2'],
                'emp' => $row['emp'],
                'outlet' => $row['outlet'],
                'Opening' => ($row['Opening'] < 0 && $row['party_type'] == "PURCHASE PARTY") ? abs($row['Opening']) : $row['Opening']
            ];
        }
        return $data;
    }



    public function getPurchaseFortakeStock($name)
    {
        $data = array();
        $query1 = $this->db->query("SELECT DISTINCT ItemC ,PItem,PRate,PQty,Unit,PGoodsOn,PBDate,PBillNo,PSiNo,Pack,MRP,SRP,PTaxA FROM PurchaseBill GROUP BY ItemC ");
        $data = $query1->result_array();
        return $data;
    }


    public function setpartywiseSales($partyname, $item, $unit)
    {

        $data = array();
        $query1 = $this->db->query(" SELECT I.ItemC, I.Rate , I.Item FROM SalesBill I INNER JOIN  MasterDetails  S ON S.BillNo = I.BillNo 
        WHERE I.Item = '$item' AND S.BillPartyName = '$partyname'  AND I.Unit = '$unit' ORDER BY S.BillNo DESC LIMIT 1 ");
        $data = $query1->result_array();
        return $data;
    }


    public function setcomapnydtls()
    {
        $data = array();
        $query1 = $this->db->query("SELECT NAME AS shopname,Place,Add1,Add2,Web,company_details,name_ar,tax_no_ar,Email,identific_no,city_name,post_code,logo,ph,
        CONCAT_WS(', ', building_no_ar, street_ar, district_ar, city_ar, pincode_ar,country_ar) AS shop_dtls_arabic FROM " . super_model::$company . "");
        $data = $query1->result_array();
        return $data;
    }


    public function getPartyWithBalancefg()
    {
        $data = array();
        $query1 = $this->db->query("SELECT `Name`, `Code`, `Ph`, `CstNo`, `TinNo`, `Typ` ,`Address1`, `Address2`, `emp`,`outlet` FROM " . super_model::$table_master . " WHERE Name !='Cash' AND Name !='3' GROUP BY `Name` ORDER BY `Name` ASC");
        $masterResult = $query1->result_array();
        for ($x = 0; $x < count($masterResult); $x++) {
            $i = $masterResult[$x]['Name'];
            $data[$i]["Name"] = $masterResult[$x]["Name"];
            $data[$i]["Code"] = $masterResult[$x]["Code"];
            $data[$i]["Ph"] = $masterResult[$x]["Ph"];
            $data[$i]["CstNo"] = $masterResult[$x]["CstNo"];
            $data[$i]["TinNo"] = $masterResult[$x]["TinNo"];
            $data[$i]["party_type"] = $masterResult[$x]["Typ"];
            $data[$i]["Address1"] = $masterResult[$x]["Address1"];
            $data[$i]["emp"] = $masterResult[$x]["emp"];
            $data[$i]["outlet"] = $masterResult[$x]["outlet"];
            // if($masterResult[$x]["Typ"]=="CUSTOMER"){
            //     $query2 = $this->db->query("SELECT PartyName, (SUM(NetTotal)-SUM(Amount)) AS Opening FROM " . super_model::$table_collection . " WHERE PartyName = '".$masterResult[$x]["Name"]."'");
            // }else if($masterResult[$x]["Typ"]=="PURCHASE PARTY"){
            //     $query2 = $this->db->query("SELECT PartyName, (SUM(Amount)-SUM(NetTotal)) AS Opening FROM " . super_model::$table_collection . " WHERE PartyName = '".$masterResult[$x]["Name"]."'");
            // }
            if ($masterResult[$x]["Typ"] == "PURCHASE PARTY") {
                $query2 = $this->db->query("SELECT PartyName, (SUM(Amount)-SUM(NetTotal)) AS Opening FROM " . super_model::$table_collection . " WHERE PartyName = '" . $masterResult[$x]["Name"] . "'");
            } else {
                $query2 = $this->db->query("SELECT PartyName, (SUM(NetTotal)-SUM(Amount)) AS Opening FROM " . super_model::$table_collection . " WHERE PartyName = '" . $masterResult[$x]["Name"] . "'");
            }

            $collectionResult = $query2->result_array();
            $data[$i]["Opening"] = $collectionResult[0]['Opening'];
            $data[$i++]["Address2"] = $masterResult[$x]["Address2"];
        }
        return $data;
    }


    public function getProducts()
    {
        $this->db->select('*');
        $this->db->from(super_model::$table_sales_item);
        $query = $this->db->get();
        $data = $query->result_array();
        return $data;
    }


    public function getGodownStock($username)
    {
        // $this->db->select('*');
        // $this->db->where('godown', $username);
        // $this->db->from(super_model::$table_godown_stock);
        // $query = $this->db->get();

        // $query = $this->db->query("SELECT Item,SUM(qty),cst,it_unit,it_pack FROM" . super_model::$table_godown_stock . "  WHERE godown= '$username' GROUP BY Item");

        $query = $this->db->query("SELECT Item,SUM(qty) as qty,cst,it_unit,it_pack,godown FROM godown_wise_stock WHERE godown='$username' GROUP BY Item");
        $data = $query->result_array();
        return $data;
    }


    public function JewelleryLogin($username)
    {

        $query = $this->db->query("SELECT Nam FROM Other WHERE Typ='$username'");
        $data = $query->result_array();
        return $data[0]['Nam'];
    }


    public function getUserPrevilage($username)
    {
        $this->db->select('*');
        $this->db->where('usr_name', $username);
        $this->db->from(super_model::$table_user_privilage);
        $query = $this->db->get();
        $data = $query->result_array();
        return $data;
    }

    public function updateSyncActivationStatus($username)
    {
        $data['apk_sync'] = 0;
        $this->db->where('usr_name', $username);
        $this->db->update(super_model::$table_user_privilage, $data);
    }

    public function getSynPrevilage($username)
    {
        $query = $this->db->query("SELECT apk_sync FROM " . super_model::$table_user_privilage . " WHERE usr_name = '$username'");
        if ($query->num_rows() > 0) {
            if ($row = $query->result_array()) {
                return $row[0]["apk_sync"];
            } else {
                return false;
            }
        }
    }

    public function getEmployeeName()
    {
        $query = $this->db->query("SELECT DISTINCT Employee AS Name FROM " . super_model::$table_collection . " WHERE Employee IS NOT NULL ORDER BY Employee ASC");
        $data = $query->result_array();
        return $data;
    }

    public function getLocatioInfo($date1, $date2, $employeeName)
    {
        $query = $this->db->query("SELECT latitude,longitude FROM " . super_model::$table_mobile_app_gps . " WHERE date1 BETWEEN '$date1' AND '$date2' AND party_name ='$employeeName' ORDER BY id");
        $data = $query->result_array();
        return $data;
    }

    public function employeeWiseSalesReport($date1, $date2, $empName)
    {
        // $query = $this->db->query("SELECT DISTINCT BillNo,NewBillNo,BillTime , BillPartyName AS PartyName, BillNetTotalField AS NetTotal,Lorry ,DATE_FORMAT(BillDate, '%d-%m-%Y') AS Date1 FROM " . super_model::$table_master_details . " WHERE BillDate BETWEEN '$date1 00:00:00' AND '$date2 23:59:59' AND (Lorry = '$empName' OR godown='$empName') ORDER BY BillNo ASC");
        $query = $this->db->query("SELECT 
    md.BillNo,
    md.NewBillNo,
    md.BillTime,
    md.BillPartyName AS PartyName,
    md.BillNetTotalField AS NetTotal,
    md.Lorry,
    DATE_FORMAT(md.BillDate, '%d-%m-%Y') AS Date1,
    CASE 
        WHEN sb.BillNo IS NOT NULL THEN 'uploaded'
        ELSE 'partial'
    END AS STATUS
    FROM " . super_model::$table_master_details . " md
    LEFT JOIN (
    SELECT DISTINCT BillNo, BillTyp, GoodsOn FROM " . super_model::$table_sales_bill . "
    WHERE BillTyp = '8' AND GoodsOn = '$empName'
    ) sb ON sb.BillNo = md.BillNo
    WHERE md.BillDate BETWEEN '$date1 00:00:00' AND '$date2 23:59:59'
    AND (md.Lorry = '$empName' OR md.godown = '$empName')
    ORDER BY md.BillNo ASC");

        $data = $query->result_array();
        for ($i = 0; $i < count($data); $i++) {
            if ($data[$i]["BillTime"] == null) {
                $data[$i]["BillTime"] = "";
            }
            $data[$i]["dateTime"] = $data[$i]["Date1"] . " " . $data[$i]["BillTime"];
        }
        return $data;
    }

    public function SaleMansReport($date1, $date2, $empName)
    {
        $query = $this->db->query("SELECT DISTINCT Lorry AS salesman ,SUM(BillNetTotalField) AS total FROM MasterDetails WHERE BillDate BETWEEN '$date1' AND '$date2' AND godown = '$empName' GROUP BY Lorry");
        $data = $query->result_array();
        return $data;
    }


    public function EnquiryReport($date1, $date2, $empName)
    {
        $query = $this->db->query(" SELECT enq_no,enq_date,product,qty,enq_status FROM enquiry WHERE enq_date BETWEEN '$date1' AND '$date2' AND counter_name='$empName'");
        $data = $query->result_array();
        return $data;
    }


    public function employeeWiseSalesReportBtoc($date1, $date2, $empName)
    {
        // $query = $this->db->query("SELECT DISTINCT BillNo,NewBillNo,BillTime , BillPartyName AS PartyName, BillNetTotalField AS NetTotal,Lorry ,DATE_FORMAT(BillDate, '%d-%m-%Y') AS Date1 FROM " . super_model::$table_master_details8Bnew . " WHERE BillDate BETWEEN '$date1 00:00:00' AND '$date2 23:59:59' AND (Lorry = '$empName' OR godown='$empName') ORDER BY BillNo ASC");
        $query = $this->db->query("SELECT 
        md.BillNo,
        md.NewBillNo,
        md.BillTime,
        md.BillPartyName AS PartyName,
        md.BillNetTotalField AS NetTotal,
        md.Lorry,
        DATE_FORMAT(md.BillDate, '%d-%m-%Y') AS Date1,
        CASE 
        WHEN sb.BillNo IS NOT NULL THEN 'uploaded'
        ELSE 'partial'
        END AS STATUS
        FROM " . super_model::$table_master_details8Bnew . " md
        LEFT JOIN (
        SELECT DISTINCT BillNo, BillTyp, GoodsOn FROM " . super_model::$table_sales_bill . "
        WHERE BillTyp = '8BNEW' AND GoodsOn = '$empName'
        ) sb ON sb.BillNo = md.BillNo
        WHERE md.BillDate BETWEEN '$date1 00:00:00' AND '$date2 23:59:59'
        AND (md.Lorry = '$empName' OR md.godown = '$empName')
        ORDER BY md.BillNo ASC");

        $data = $query->result_array();
        for ($i = 0; $i < count($data); $i++) {
            if ($data[$i]["BillTime"] == null) {
                $data[$i]["BillTime"] = "";
            }
            $data[$i]["dateTime"] = $data[$i]["Date1"] . " " . $data[$i]["BillTime"];
        }
        return $data;
    }

    public function collectionReportEmployeeWise($date1, $date2, $empName)
    {
        $query = $this->db->query("SELECT SiNo AS BillNo,PartyName,bill_time, Amount, DATE_FORMAT(Date1, '%d-%m-%Y') AS Date1, image_data FROM " . super_model::$table_collection . " WHERE Date1 BETWEEN '$date1 00:00:00' AND '$date2 23:59:59' AND Employee ='$empName' AND Amount != 0 AND PartyName != '3' AND TransactionType !='ToSalesReturn' AND TransactionType  !='Opening'  AND Typ='CUSTOMER' ORDER BY Date1 ASC");
        $data = $query->result_array();
        for ($i = 0; $i < count($data); $i++) {
            if ($data[$i]["bill_time"] == null) {
                $data[$i]["bill_time"] = "";
            }
            $data[$i]["dateTime"] = $data[$i]["Date1"] . " " . $data[$i]["bill_time"];
        }
        return $data;
    }

    public function collectionReport($date1, $date2)
    {
        $query = $this->db->query("SELECT SiNo AS BillNo,PartyName,bill_time, Amount, DATE_FORMAT(Date1, '%d-%m-%Y') AS Date1, image_data FROM " . super_model::$table_collection . " WHERE Date1 BETWEEN '$date1 00:00:00' AND '$date2 23:59:59' AND Amount != 0 AND PartyName!= '3' AND TransactionType !='ToSalesReturn' AND TransactionType  !='Opening' AND Typ='CUSTOMER' ORDER BY Date1 ASC");
        $data = $query->result_array();
        for ($i = 0; $i < count($data); $i++) {
            if ($data[$i]["bill_time"] == null) {
                $data[$i]["bill_time"] = "";
            }
            $data[$i]["dateTime"] = $data[$i]["Date1"] . " " . $data[$i]["bill_time"];
        }
        return $data;
    }

    public function expenseReport($date1, $date2, $empName)
    {
        $query = $this->db->query("SELECT SiNo AS BillNo,PartyName,bill_time, NetTotal as Amount, DATE_FORMAT(Date1, '%d-%m-%Y') AS Date1, image_data FROM " . super_model::$table_collection . " WHERE Date1 BETWEEN '$date1 00:00:00' AND '$date2 23:59:59' AND TransactionType ='Cash' AND Typ='EXPENSE' AND Employee = '$empName' ORDER BY Date1 ASC");
        $data = $query->result_array();
        for ($i = 0; $i < count($data); $i++) {
            if ($data[$i]["bill_time"] == null) {
                $data[$i]["bill_time"] = "";
            }
            $data[$i]["dateTime"] = $data[$i]["Date1"] . " " . $data[$i]["bill_time"];
        }
        return $data;
    }

    public function paymentReport($date1, $date2, $empName)
    {
        $query = $this->db->query("SELECT SiNo AS BillNo,PartyName,bill_time, NetTotal as Amount, DATE_FORMAT(Date1, '%d-%m-%Y') AS Date1, image_data FROM " . super_model::$table_collection . " WHERE Date1 BETWEEN '$date1 00:00:00' AND '$date2 23:59:59' AND TransactionType ='Cash' AND Typ='PURCHASE PARTY'  AND Employee = '$empName' ORDER BY Date1 ASC");
        $data = $query->result_array();
        for ($i = 0; $i < count($data); $i++) {
            if ($data[$i]["bill_time"] == null) {
                $data[$i]["bill_time"] = "";
            }
            $data[$i]["dateTime"] = $data[$i]["Date1"] . " " . $data[$i]["bill_time"];
        }
        return $data;
    }

    public function openingReport($date1)
    {
        $query = $this->db->query("SELECT SUM(Amount),SUM(NetTotal) FROM " . super_model::$table_collection . " WHERE Date1 < '$date1' AND (TransactionType ='Cash' || TransactionType ='Cheque' ||  TransactionType ='RTGS' || TransactionType ='DD' || TransactionType ='Recieved ByCash')");
        $data = $query->result_array();
        for ($i = 0; $i < count($data); $i++) {
            if ($data[$i]["bill_time"] == null) {
                $data[$i]["bill_time"] = "";
            }
            $data[$i]["dateTime"] = $data[$i]["Date1"] . " " . $data[$i]["bill_time"];
        }
        return $data;
    }

    public function cashBookReport($date1, $date2)
    {
        $query = $this->db->query("SELECT SiNo,bill_time,DATE_FORMAT(Date1, '%d-%m-%Y') AS Date1,PartyName,Amount,NetTotal FROM " . super_model::$table_collection . " WHERE Date1 BETWEEN '$date1' AND '$date2' AND
                                (TransactionType ='Cash' || TransactionType ='Cheque' ||  TransactionType ='RTGS' || TransactionType ='DD' || TransactionType ='Recieved ByCash')");
        $data = $query->result_array();
        for ($i = 0; $i < count($data); $i++) {
            if ($data[$i]["bill_time"] == null) {
                $data[$i]["bill_time"] = "";
            }
            $data[$i]["dateTime"] = $data[$i]["Date1"] . " " . $data[$i]["bill_time"];
        }
        return $data;
    }

    public function purchaseReport($date1, $date2, $empName)
    {
        $query = $this->db->query("SELECT BillNo,bill_time,DATE_FORMAT(Date1, '%d-%m-%Y') AS Date1,PartyName,Amount FROM " . super_model::$table_collection . " WHERE Date1 BETWEEN '$date1' AND '$date2' AND TransactionType ='ToCash' AND Employee = '$empName' ORDER BY BillNo ASC ");
        //  $query = $this->db->query("SELECT InvoiceNo as BillNo,BillTime as bill_time,DATE_FORMAT(InvoiceDat, '%d-%m-%Y') AS Date1,PartyName,Ntot as Amount FROM " . super_model::$table_collection . " WHERE InvoiceDat BETWEEN '$date1' AND '$date2'");
        $data = $query->result_array();
        for ($i = 0; $i < count($data); $i++) {
            if ($data[$i]["bill_time"] == null) {
                $data[$i]["bill_time"] = "";
            }
            $data[$i]["dateTime"] = $data[$i]["Date1"] . " " . $data[$i]["bill_time"];
            $data[$i]["NetTotal"] = $data[$i]["Amount"];
        }
        return $data;
    }



    public function salesReport($date1, $date2)
    {
        // $query = $this->db->query("SELECT DISTINCT BillNo,bill_time,PartyName,NetTotal, DATE_FORMAT(Date1, '%d-%m-%Y') AS Date1 FROM " . super_model::$table_collection . " WHERE Date1 BETWEEN '$date1 00:00:00' AND '$date2 23:59:59' AND TransactionType='ToSales' AND BillForm ='8'  ORDER BY BillNo ASC");
        $query = $this->db->query("SELECT 
    c.BillNo,
    c.bill_time,
    c.PartyName,
    c.NetTotal,
    DATE_FORMAT(c.Date1, '%d-%m-%Y') AS Date1,
    CASE 
        WHEN sb.BillNo IS NOT NULL THEN 'uploaded'
        ELSE 'partial'
    END AS STATUS
    FROM " . super_model::$table_collection . " c
    LEFT JOIN (
    SELECT DISTINCT BillNo, BillTyp FROM  " . super_model::$table_sales_bill . " WHERE BillTyp = '8'
    ) sb ON sb.BillNo = c.BillNo
    WHERE c.Date1 BETWEEN '$date1 00:00:00' AND '$date2 23:59:59'
    AND c.TransactionType = 'ToSales'
    AND c.BillForm = '8'
    ORDER BY c.BillNo ASC");

        $data = $query->result_array();
        for ($i = 0; $i < count($data); $i++) {
            if ($data[$i]["bill_time"] == null) {
                $data[$i]["bill_time"] = "";
            }
            $data[$i]["dateTime"] = $data[$i]["Date1"] . " " . $data[$i]["bill_time"];
        }
        return $data;
    }


    public function salesReturnReport($date1, $date2, $empName)
    {
        $query = $this->db->query("SELECT DISTINCT BillNo As RetNo,PartyName,Amount AS NetTotal, DATE_FORMAT(Date1, '%d-%m-%Y') AS Date1 FROM " . super_model::$table_collection . " WHERE Date1 BETWEEN '$date1 00:00:00' AND '$date2 23:59:59' AND TransactionType='ToSalesReturn' AND Employee='$empName' ORDER BY BillNo ASC");
        $data = $query->result_array();
        for ($i = 0; $i < count($data); $i++) {
            // if ($data[$i]["bill_time"] == null) {
            //     $data[$i]["bill_time"] = "";
            // }
            // $data[$i]["dateTime"] = $data[$i]["Date1"] . " " . $data[$i]["bill_time"];
            $data[$i]["dateTime"] = $data[$i]["Date1"];
        }
        return $data;
    }

    public function orderReport($date1, $date2)
    {
        $query = $this->db->query("SELECT DISTINCT BillNo,BillTime,BillPartyName,BillNetTotalField, DATE_FORMAT(BillDate, '%d-%m-%Y') AS BillDate FROM " . super_model::$table_master_details8B . "  WHERE BillDate BETWEEN '$date1 00:00:00' AND '$date2 23:59:59' ORDER BY BillNo ASC");
        $data = $query->result_array();
        for ($i = 0; $i < count($data); $i++) {
            if ($data[$i]["BillTime"] == null) {
                $data[$i]["BillTime"] = "";
            }
            $data[$i]["dateTime"] = $data[$i]["BillDate"] . " " . $data[$i]["BillTime"];
        }
        return $data;
    }

    public function employeeWiseorderReport($date1, $date2, $empName)
    {
        $query = $this->db->query("SELECT DISTINCT BillNo,BillTime,BillPartyName,BillNetTotalField, DATE_FORMAT(BillDate, '%d-%m-%Y') AS BillDate FROM " . super_model::$table_master_details8B . "  WHERE BillDate BETWEEN '$date1 00:00:00' AND '$date2 23:59:59' AND Lorry = '$empName' ORDER BY BillNo ASC");
        $data = $query->result_array();
        for ($i = 0; $i < count($data); $i++) {
            if ($data[$i]["BillTime"] == null) {
                $data[$i]["BillTime"] = "";
            }
            $data[$i]["dateTime"] = $data[$i]["BillDate"] . " " . $data[$i]["BillTime"];
        }
        return $data;
    }

    public function employeeWiseAuditingReport($empName)
    {
        $query = $this->db->query("SELECT SUM(Opening) AS Amt FROM " . super_model::$table_master . " WHERE emp = '$empName' ");
        $result = $query->row();
        $opngAmt = $result->Amt;

        $query = $this->db->query("SELECT SUM(tot) AS Amt FROM (SELECT SUM(total) AS tot FROM " . super_model::$table_godown_trance . " WHERE dest = '$empName' GROUP BY vcr_no )AS tabil");
        $result = $query->row();
        $stockAmt = $result->Amt;

        $query = $this->db->query("SELECT SUM(Amount) AS Amt FROM " . super_model::$table_collection . " WHERE Employee = '$empName' AND (TransactionType ='Cash' || TransactionType ='Cheque' ||  TransactionType ='RTGS' || TransactionType ='DD') AND Typ = 'CUSTOMER'");
        $result = $query->row();
        $receiptAmt = $result->Amt;

        $query = $this->db->query("SELECT SUM(NetTotal) AS Amt FROM " . super_model::$table_collection . " WHERE Employee = '$empName' AND (TransactionType ='Cash' || TransactionType ='Cheque' ||  TransactionType ='RTGS' || TransactionType ='DD') AND Typ = 'EXPENSE'");
        $result = $query->row();
        $expenceAmt = $result->Amt;

        $query = $this->db->query("SELECT SUM(BillDiscAmtField) + SUM(TDiscAmt) AS Amt FROM " . super_model::$table_master_details . " WHERE Lorry = '$empName'");
        $result = $query->row();
        $discountAmt = $result->Amt;

        $query = $this->db->query("SELECT SUM(net_total) AS Amt FROM " . super_model::$table_godown_trance . " WHERE src = '$empName' ");
        $result = $query->row();
        $returnAmt = $result->Amt;

        $query = $this->db->query("SELECT SUM(amount) AS Amt FROM (SELECT qty*cst AS amount FROM " . super_model::$table_godown_stock . " WHERE godown = '$empName' GROUP BY item,cst) AS tabil;");
        $result = $query->row();
        $stockGdAmt = $result->Amt;

        $query = $this->db->query("SELECT SUM(NetTotal) - SUM(Amount) AS Amt FROM " . super_model::$table_collection . " WHERE  Employee = '$empName' AND Typ = 'CUSTOMER';");
        $result = $query->row();
        $creditAmt = $result->Amt;

        $res = array();
        $res['opening_amt'] = $opngAmt;
        $res['stock_amt'] = $stockAmt;
        $res['receipt'] = $receiptAmt;
        $res['expence'] = $expenceAmt;
        $res['discount'] = $discountAmt;
        $res['return'] = $returnAmt;
        $res['van_stock'] = $stockGdAmt;
        $res['credit'] = $creditAmt;
        return $res;
    }

    // public function ledger($date1, $date2, $partyName)
    // {
    //     $query = $this->db->query("SELECT bill_time, DATE_FORMAT(Date1, '%d-%m-%Y') AS Date1, COALESCE(Amount, 0) AS debit, COALESCE(NetTotal, 0) AS credit, BillForm AS bill_typ,
    //     CONCAT(COALESCE(BillNo, 0), '/', COALESCE(SiNo, 0)) AS InvoiceNo,TransactionType  FROM " . super_model::$table_collection . " WHERE Date1 BETWEEN '$date1 00:00:00' AND '$date2 23:59:59' AND PartyName= '$partyName' AND  Typ='CUSTOMER' ");
    //     // $query = $this->db->query("SELECT bill_time, DATE_FORMAT(Date1, '%d-%m-%Y') AS Date1, Amount AS debit , NetTotal AS credit FROM " . super_model::$table_collection . " WHERE Date1 BETWEEN '$date1 00:00:00' AND '$date2 23:59:59' AND PartyName= '$partyName' AND  Typ='CUSTOMER' ");
    //     $data = $query->result_array();
    //     for ($i = 0; $i < count($data); $i++) {
    //         if ($data[$i]["bill_time"] == null) {
    //             $data[$i]["bill_time"] = "";
    //         }
    //         $data[$i]["dateTime"] = $data[$i]["Date1"] . " " . $data[$i]["bill_time"];
    //     }
    //     return $data;
    // }


    public function ledger($date1, $date2, $partyName)
    {
        // Prepare the SQL query with safe parameter binding
        $sql = "
    SELECT 
        CAST(NULL AS TIME) AS bill_time,
        CAST(NULL AS DATE) AS Date1,
        COALESCE(SUM(Amount), 0) - COALESCE(SUM(NetTotal), 0) AS debit,
        0 AS credit,
        '' AS bill_typ,
        '' AS InvoiceNo,
        'Opening' AS TransactionType
    FROM " . super_model::$table_collection . "
    WHERE 
        Date1 < ? 
        AND PartyName = ? 
        AND Typ = 'CUSTOMER'

    UNION ALL

    SELECT 
        bill_time,
        DATE_FORMAT(Date1, '%d-%m-%Y') AS Date1,
        COALESCE(Amount, 0) AS debit,
        COALESCE(NetTotal, 0) AS credit,
        BillForm AS bill_typ,
        CONCAT(COALESCE(BillNo, ''), '/', COALESCE(SiNo, '')) AS InvoiceNo,
        TransactionType  
    FROM " . super_model::$table_collection . "
    WHERE 
        Date1 BETWEEN ? AND ?
        AND PartyName = ?
        AND Typ = 'CUSTOMER'

    ORDER BY Date1, bill_time
    ";

        // Bind parameters to prevent SQL injection
        $query = $this->db->query($sql, array(
            $date1 . ' 00:00:00',   // for opening balance
            $partyName,
            $date1 . ' 00:00:00',   // for transaction records
            $date2 . ' 23:59:59',
            $partyName
        ));

        // Fetch results
        $data = $query->result_array();

        // Format dateTime and handle nulls
        for ($i = 0; $i < count($data); $i++) {
            $billTime = $data[$i]["bill_time"] ?? '';
            $dateOnly = $data[$i]["Date1"] ?? '';

            $data[$i]["bill_time"] = $billTime;
            $data[$i]["dateTime"] = trim($dateOnly . ' ' . $billTime);
        }

        return $data;
    }


    public function currentStockReport($empName)
    {
        // $query = $this->db->query("SELECT ItemNameTextField,godown_wise_stock.qty AS StockInMain,Cost,curr_stock * Cost AS TotalCost, Rate1 AS sellingprice,Size  FROM " . super_model::$table_sales_item . " RIGHT JOIN " . super_model::$table_godown_wise_stock . " ON `ItemNameTextField` = godown_wise_stock.Item WHERE godown='$empName' ORDER BY ItemNameTextField ASC;");
        $query = $this->db->query("
    SELECT 
        s.ItemNameTextField,                             
        SUM(g.qty) AS StockInMain, 
        s.Cost,                      
        s.curr_stock * s.Cost AS TotalCost,               
        s.Rate1 AS sellingprice,                              
        s.Size                                         
    FROM " . super_model::$table_sales_item . " s
    INNER JOIN " . super_model::$table_godown_wise_stock . " g 
        ON s.ItemNameTextField = g.Item  
    WHERE g.godown = '$empName'                    
    GROUP BY 
        s.ItemNameTextField, 
        s.curr_stock, 
        s.Cost, 
        s.Rate1, 
        s.Size
    ORDER BY s.ItemNameTextField ASC");
        $data = $query->result_array();
        return $data;
    }



    public function CashBookData($empName, $date1, $date2)
    {
        // $query = $this->db->query("SELECT Date1,PartyName,Narration,Amount,NetTotal,Typ,TransactionType,SiNo FROM Collection WHERE Date1 Between '$date1' And '$date2' AND godown = ' $empName ' ORDER BY Date1,SiNo ASC");
        $query = $this->db->query("SELECT Date1,PartyName,Narration,Amount,NetTotal,Typ,TransactionType,SiNo FROM Collection WHERE Date1 BETWEEN '$date1' And '$date2' AND godown = '$empName' ORDER BY Date1,SiNo ASC");
        $data = $query->result_array();
        $query2 = $this->db->query("SELECT TransactionType,Amount,NetTotal,PartyName,Narration FROM Collection where Date1 < '$date1' AND godown = '$empName'");
        $data2 = $query2->result_array();
        return $data;
    }



    public function CashBookDataOpening($empName, $date1, $date2)
    {
        // $query = $this->db->query("SELECT Date1,PartyName,Narration,Amount,NetTotal,Typ,TransactionType,SiNo FROM Collection WHERE Date1 Between '$date1' And '$date2' AND godown = ' $empName ' ORDER BY Date1,SiNo ASC");

        $query2 = $this->db->query("SELECT TransactionType,Amount,NetTotal,PartyName,Narration FROM Collection where Date1 < '$date1' AND godown = '$empName'");
        $data2 = $query2->result_array();
        return $data2;
    }



    public function currentStockReportSalesItem($empName)
    {
        $query = $this->db->query("SELECT ItemNameTextField,curr_stock AS StockInMain,Cost,curr_stock*Cost as TotalCost ,Rate1 as sellingprice,Size FROM SalesItem ORDER BY ItemNameTextField ASC");
        $data = $query->result_array();
        return $data;
    }

    public function currentStockReportEMPWise($empName)
    {
        $query = $this->db->query("SELECT ItemNameTextField,godown_wise_stock.qty AS StockInMain,Cost,curr_stock * Cost AS TotalCost,Rate1 as sellingprice ,Size FROM " . super_model::$table_sales_item . " RIGHT JOIN " . super_model::$table_godown_wise_stock . " ON `ItemNameTextField` = godown_wise_stock.Item WHERE godown_wise_stock.godown = '$empName' ORDER BY ItemNameTextField ASC;");
        $data = $query->result_array();
        return $data;
    }

    public function getSalesDetailsForBillno($billNumber)
    {
        $query = $this->db->query("SELECT Item, Qty, Rate,Total,TaxA, NetV,local_app_user_entry_id FROM " . super_model::$table_sales_bill . " WHERE BillNo = '$billNumber' ");
        $data = $query->result_array();
        return $data;
    }

    public function getItemWiseSalesReport($date1, $date2)
    {
        $query = $this->db->query("SELECT   Item,SUM( Qty) AS Qty,SUM( Total) AS Total FROM " . super_model::$table_sales_bill . " WHERE SBDate BETWEEN '$date1' AND '$date2'  GROUP BY Item ");
        $data = $query->result_array();
        return $data;
    }
    public function intransReport($date1, $date2)
    {
        $query = $this->db->query("SELECT DISTINCT  inv_no,party,date1,SUM(qty),SUM(total),id FROM " . super_model::$table_intrans . " WHERE date1 BETWEEN '$date1' AND '$date2' AND type = 'CREDIT' GROUP BY inv_no ");
        $data = $query->result_array();
        return $data;
    }



    public function salesHolReport($date1, $date2)
    {
        $query = $this->db->query("SELECT BillPartyName, SUM(Sales) AS TotalSales, SUM(SalesReturn) AS TotalSalesReturn FROM ( SELECT BillPartyName, SUM(TotItWiseQty1) AS Sales, 0 AS SalesReturn FROM MasterDetails WHERE BillDate BETWEEN '$date1' AND '$date2'  GROUP BY BillPartyName 
        UNION ALL SELECT BillPartyName, 0 AS Sales, SUM(netQty) AS SalesReturn FROM Srmasterdetails WHERE BillDate BETWEEN '$date1' AND  '$date2' GROUP BY BillPartyName ) AS CombinedResults GROUP BY BillPartyName;");
        $data = $query->result_array();
        return $data;
    }

    public function employeeWiseSalesReportEdit($billNo, $employee)
    {
        $query = $this->db->query("SELECT s.*,m.BillPartyName AS party, m.BillDiscAmtField AS Discount , m.NewBillNo as prefix_no FROM " . super_model::$table_sales_bill . "  AS s INNER JOIN  " . super_model::$table_master_details . "  AS m WHERE s.billno = '$billNo' AND m.billno = '$billNo'  AND s.BillTyp = '8' AND m.lorry = '$employee'  AND s.GoodsOn = '$employee' ");
        // $query = $this->db->query("SELECT s.*,m.BillPartyName AS party, m.BillDiscAmtField AS Discount FROM " . super_model::$table_sales_bill . "  AS s INNER JOIN MasterDetails AS m WHERE s.billno = '$billNo' AND m.billno = '$billNo'  AND s.BillTyp = '8' ");
        $data = $query->result_array();
        return $data;
    }

    public function employeeWiseSalesReturnEdit($billNo)
    {
        // $query = $this->db->query("SELECT DISTINCT  * FROM " . super_model::$table_sales_bill . " WHERE BillNo='$billNo'");

        $query = $this->db->query("SELECT s.*,m.BillPartyName AS party FROM SalesReturn AS s INNER JOIN SRMasterDetails AS m WHERE s.RetNo = '$billNo' AND m.RetNo = '$billNo'");
        $data = $query->result_array();
        return $data;
    }

    public function employeeWiseSalesReportEditMaster($billNo)
    {
        $query = $this->db->query("SELECT DISTINCT  * FROM " . super_model::$table_master_details . " WHERE BillNo='$billNo'");
        $data = $query->result_array();
        return $data;
    }


    public function employeeWiseSalesReturnEditMaster($billNo)
    {
        $query = $this->db->query("SELECT DISTINCT  * FROM  SRMasterDetails WHERE RetNo='$billNo'");
        $data = $query->result_array();
        return $data;
    }

    public function employeeWiseSalesReportEditMasterBtoc($billNo)
    {
        $query = $this->db->query("SELECT DISTINCT  * FROM " . super_model::$table_master_details8Bnew . " WHERE BillNo='$billNo'");
        $data = $query->result_array();
        return $data;
    }

    public function employeeWiseSalesReportEditCollection($billNo)
    {
        $query = $this->db->query("SELECT DISTINCT  * FROM " . super_model::$table_collection . " WHERE BillNo='$billNo'");
        $data = $query->result_array();
        return $data;
    }

    public function employeeWiseSalesReturnEditCollection($billNo)
    {
        $query = $this->db->query("SELECT DISTINCT  * FROM " . super_model::$table_collection . " WHERE BillNo='$billNo' AND TransactionType='ToSalesReturn'");
        $data = $query->result_array();
        return $data;
    }

    public function intransReportEdit($billNo, $partyName)
    {
        $query = $this->db->query("SELECT DISTINCT  * FROM " . super_model::$table_intrans . " WHERE party='$partyName' AND inv_no = '$billNo' and type = 'CREDIT' ");
        $data = $query->result_array();
        return $data;
    }

    public function intransLedgerReport($date1, $date2, $party)
    {
        $query = $this->db->query("SELECT DISTINCT inv_no,itemname,qty,rate,total,credit FROM " . super_model::$table_intrans . " WHERE party = '$party' AND date1 BETWEEN '$date1' AND '$date2'");
        $data = $query->result_array();
        return $data;
    }

    public function getCashparty()
    {
        $query = $this->db->query("SELECT DISTINCT cashcardamt as contact ,cashp AS party  FROM " . super_model::$table_master_details);
        $data = $query->result_array();
        return $data;
    }

    public function getUpdateBillNo($inv_no, $emp)
    {
        $query = $this->db->query("SELECT BillNo FROM " . super_model::$table_master_details . " WHERE NewBillNo  = '$inv_no' AND Lorry = '$emp'");
        if ($query->num_rows() > 0) {
            if ($row = $query->result_array()) {
                return $row[0]["BillNo"];
            } else {
                return false;
            }
        }
    }


    public function getUpdatelocal($inv_no, $emp)
    {
        $query = $this->db->query("SELECT local_app_user_entry_id FROM " . super_model::$table_master_details . " WHERE NewBillNo  = '$inv_no' AND Lorry = '$emp'");
        if ($query->num_rows() > 0) {
            if ($row = $query->result_array()) {
                return $row[0]["local_app_user_entry_id"];
            } else {
                return false;
            }
        }
    }


    public function getUpdateBillNoNew($inv_no, $emp)
    {
        $query = $this->db->query("SELECT BillNo FROM " . super_model::$table_master_details . " WHERE BillNo  = '$inv_no' AND Lorry = '$emp'");
        if ($query->num_rows() > 0) {
            if ($row = $query->result_array()) {
                return $row[0]["BillNo"];
            } else {
                return false;
            }
        }
    }

    public function getInvNo()
    {
        $query = $this->db->query("SELECT MAX(InvoiceNo+1) AS BillNo FROM " . super_model::$table_Pbill);
        if ($query->num_rows() > 0) {
            if ($row = $query->result_array()) {
                return $row[0]["BillNo"];
            } else {
                return false;
            }
        }
    }
    public function getInvNo1()
    {
        $query = $this->db->query("SELECT MAX(InvoiceNo) AS BillNo FROM " . super_model::$table_Pbill);
        if ($query->num_rows() > 0) {
            if ($row = $query->result_array()) {
                return $row[0]["BillNo"];
            } else {
                return false;
            }
        }
    }

    public function getInvNoIntrans()
    {
        $query = $this->db->query("SELECT MAX(inv_no+1) AS BillNo FROM " . super_model::$table_intrans);
        if ($query->num_rows() > 0) {
            if ($row = $query->result_array()) {
                return $row[0]["BillNo"];
            } else {
                return false;
            }
        }
    }

    public function getInvNodamage()
    {
        $query = $this->db->query("SELECT MAX(Stock_No+1) AS BillNo FROM damagemaster");
        if ($query->num_rows() > 0) {
            if ($row = $query->result_array()) {
                return $row[0]["BillNo"];
            } else {
                return false;
            }
        }
    }

    public function getInvNoIntrans1()
    {
        $query = $this->db->query("SELECT MAX(inv_no) AS BillNo FROM " . super_model::$table_intrans);
        if ($query->num_rows() > 0) {
            if ($row = $query->result_array()) {
                return $row[0]["BillNo"];
            } else {
                return false;
            }
        }
    }

    public function getBillNo()
    {
        $query = $this->db->query("SELECT MAX(BillNo+1) AS BillNo FROM " . super_model::$table_master_details);
        if ($query->num_rows() > 0) {
            if ($row = $query->result_array()) {
                return $row[0]["BillNo"];
            } else {
                return false;
            }
        }
    }


    public function getMaxPrtBillNo()
    {
        $query = $this->db->query("SELECT MAX(RetNo+1) AS RetNo FROM " . super_model::$table_pr_rmasterdetails);
        if ($query->num_rows() > 0) {
            if ($row = $query->result_array()) {
                return $row[0]["RetNo"];
            } else {
                return false;
            }
        }
    }

    public function getPRTFinYear()
    {
        $query = $this->db->query("SELECT fin_year FROM PRMasterDetails ORDER BY RetNo DESC LIMIT 1");
        if ($query->num_rows() > 0) {
            if ($row = $query->result_array()) {
                return $row[0]["fin_year"];
            } else {
                return false;
            }
        }
    }


    public function getFinYear()
    {
        $query = $this->db->query("SELECT fin_year FROM MasterDetails ORDER BY BillNo DESC LIMIT 1");
        if ($query->num_rows() > 0) {
            if ($row = $query->result_array()) {
                return $row[0]["fin_year"];
            } else {
                return false;
            }
        }
    }


    public function getEnqNo()
    {
        $query = $this->db->query("SELECT MAX(enq_no+1) AS BillNo FROM enquiry");
        if ($query->num_rows() > 0) {
            if ($row = $query->result_array()) {
                return $row[0]["BillNo"];
            } else {
                return false;
            }
        }
    }

    public function getBillNo8b()
    {
        $query = $this->db->query("SELECT MAX(BillNo+1) AS BillNo FROM " . super_model::$table_master_details8Bnew);
        if ($query->num_rows() > 0) {
            if ($row = $query->result_array()) {
                return $row[0]["BillNo"];
            } else {
                return false;
            }
        }
    }

    public function getSiNo()
    {
        $query = $this->db->query("SELECT MAX(SiNo+1) AS SiNo FROM " . super_model::$table_collection);
        if ($query->num_rows() > 0) {
            if ($row = $query->result_array()) {
                return $row[0]["SiNo"];
            } else {
                return false;
            }
        }
    }

    public function getBillNoSalesBill()
    {
        $query = $this->db->query("SELECT MAX(BillNo+1) AS BillNo FROM " . super_model::$table_sales_bill);
        if ($query->num_rows() > 0) {
            if ($row = $query->result_array()) {
                return $row[0]["BillNo"];
            } else {
                return false;
            }
        }
    }


    // public function deleteFromMasterDetailsByBillNo($luserEntryID, $billNo)
    // {
    //     $this->db->where('local_app_user_entry_id', $luserEntryID);
    //     $this->db->where('BillNo!=', $billNo);
    //     $this->db->delete(super_model::$table_master_details);
    // }


    public function deleteFromMasterDetailsByBillNo($luserEntryID, $billNo)
    {
        $this->db->where('local_app_user_entry_id', $luserEntryID);
        $this->db->where('BillNo!=', $billNo);
        $this->db->where('local_app_user_entry_id IS NOT NULL', null, false);
        $this->db->delete(super_model::$table_master_details);
    }


    public function deleteFromSalesBillByBillNo($invno, $employee)
    {
        $this->db->where('BillNo =', $invno);
        $this->db->where('GoodsOn', $employee);
        $this->db->where('BillTyp', '8');
        $this->db->delete(super_model::$table_sales_bill);
    }


    public function deleteFromSalesReturnByBillNo($invno, $employee)
    {
        $this->db->where('RetNo =', $invno);
        $this->db->where('godown', $employee);
        $this->db->delete(super_model::$table_sales_return);
    }


    public function deleteFromMasterDetailsToSalesBillDelete($inv_no, $emp)
    {
        $this->db->where('BillNo =', $inv_no);
        $this->db->where('Lorry', $emp);
        $this->db->delete(super_model::$table_master_details);
    }


    public function deleteFromSRMasterDetailsDelete($inv_no, $emp)
    {
        $this->db->where('RetNo =', $inv_no);
        $this->db->where('Employee', $emp);
        $this->db->delete(super_model::$table_sr_master_details);
    }



    public function deleteFromMasterDetailsToSalesBillDeleteBtoc($inv_no, $emp)
    {
        $this->db->where('BillNo =', $inv_no);
        $this->db->where('Lorry', $emp);
        $this->db->delete(super_model::$table_master_details8Bnew);
    }

    public function deleteFromInTrans($inv_no, $emp)
    {
        $this->db->where('inv_no =', $inv_no);
        $this->db->where('party', $emp);
        $this->db->delete(super_model::$table_intrans);
    }

    // public function deleteFromCollectionToSaleBillDelete($billNo)
    // {
    //     $this->db->where('TransactionType', 'ToSales');
    //     $this->db->where('BillNo =', $billNo);
    //     $this->db->delete(super_model::$table_collection);
    // }

    public function deleteFromCollectionToSaleBillDelete($billNo)
    {
        $this->db->where_in('TransactionType', ['ToSales', 'Recieved ByCash']);
        $this->db->where('BillNo', $billNo);
        $this->db->where('BillForm', '8'); // <-- Add this condition
        $this->db->delete(super_model::$table_collection);
    }

    public function deleteFromCollectionSalesReturnDelete($billNo)
    {
        $this->db->where('TransactionType', 'ToSalesReturn');
        $this->db->where('BillNo =', $billNo);
        $this->db->delete(super_model::$table_collection);
    }



    public function deleteFromCollectionByBillNo($luserEntryID, $billNo)
    {
        $this->db->where('local_app_user_entry_id', $luserEntryID);
        $this->db->where('BillNo!=', $billNo);
        $this->db->delete(super_model::$table_collection);
    }
    public function deleteFromCollectionBySiNo($SiNo)
    {
        $this->db->where('SiNo=', $SiNo);
        $this->db->delete(super_model::$table_collection);
    }

    public function deleteFromPRTMasterDetailsByBillNo($luserEntryID, $billNo)
    {
        $this->db->where('local_app_user_entry_id', $luserEntryID);
        $this->db->where('RetNo!=', $billNo);
        $this->db->where('local_app_user_entry_id IS NOT NULL', null, false); // Raw where clause
        $this->db->delete(super_model::$table_pr_rmasterdetails);
    }

    // public function deleteFromPRTCollectionByBillNo($luserEntryID, $billNo)
    // {
    //     $this->db->where('local_app_user_entry_id', $luserEntryID);
    //     $this->db->where('BillNo !=', $billNo);
    //     $this->db->where('TransactionType', 'ToPurchaseReturn');
    //     $this->db->delete(super_model::$table_collection);
    // }

    public function deleteFromPRTCollectionByBillNo($luserEntryID, $billNo)
    {
        $sql = "DELETE FROM Collection 
            WHERE local_app_user_entry_id = '$luserEntryID' 
              AND BillNo != '$billNo' 
              AND TransactionType = 'ToPurchaseReturn' 
              AND local_app_user_entry_id IS NOT NULL  AND BillNo <> 0 ";

        return $this->db->query($sql);
    }


    public function getrowsaffect()
    {
        $val1 = $this->db->affected_rows();
        return $val1;
    }


    public function storeEnquiry($no, $name, $date, $description, $image, $diamondwt, $grosswt, $qty, $counter_name)
    {
        $data = array(
            'enq_no' => $no,
            'product' => $name,
            'enq_date' => $date,
            'description' => $description,
            'image' => $image,
            'diamondwt' => $diamondwt,
            'grosswt' => $grosswt,
            'qty' => $qty,
            'counter_name' => $counter_name

        );

        $this->db->insert('enquiry', $data);
        $insert_id = $this->db->insert_id();
        if ($this->db->affected_rows() == 1) {
            return TRUE;
        } else {
            return FALSE;
        }
    }

    public function storeUser($itemName, $price, $qty, $unit, $party, $godown, $employee, $date1, $invno, $local_app_user_entry_id, $billNo, $index, $taxAmt, $taxPerc, $itemC, $qty_in_pack, $cost, $disc, $sqft, $taxtyp, $netV)
    {
        $res = $this->db->query("DELETE FROM " . super_model::$table_sales_bill . " WHERE local_app_user_entry_id='$local_app_user_entry_id' AND  BillNo != '$billNo' AND local_app_user_entry_id IS NOT NULL AND BillTyp = '8' ");
        if ($res) {

            // $total = ($price - $disc) * $qty;

            $total = ($price * $qty) - $disc;

            // if ($taxtyp == "EXCLUDE") {
            //     $netV = $total + $taxAmt;
            // } else {
            //     $netV = $total;
            // }

            $data = array(
                'SiNo' => $index,
                'ItemC' => $itemC,
                'Item' => $itemName,
                'Qty' => $qty,
                'sqft' => $sqft,
                'Rate' => $price,
                'ItWiseDisAmt' => '0',
                'Dis' => $disc,
                'Total' => $total,
                'NetV' => $netV,
                'GoodsOn' => $employee,
                'BillNo' => $billNo,
                'SBDate' => $date1,
                'Cst' => $cost,
                'BillTyp' => '8',
                'Stat' => '0',
                'local_app_user_entry_id' => $local_app_user_entry_id,
                'local_app_invoice_id' => $invno,
                'TaxP' => $taxPerc,
                'TaxA' => $taxAmt,
                'Unit' => $unit,
                'Pack' => $qty_in_pack
            );


            $this->db->insert(super_model::$table_sales_bill, $data);
            // if ($this->db->error()) {
            //     print_r('ppppppppppppppppppppppppppp3');
            //     return FALSE; // Return FALSE if a database error occurs
            // }
            $insert_id = $this->db->insert_id();
            if ($this->db->affected_rows() == 1) {
                return TRUE;
                //  $this->MobileAPI->log_gen("uu");
            } else {
                return FALSE;
            }
        }

        return FALSE;
    }


    //     public function storeUser($itemName, $price, $qty, $unit, $party, $godown, $employee, $date1, $invno, $local_app_user_entry_id, $billNo, $index, $taxAmt, $taxPerc, $itemC, $qty_in_pack, $cost, $disc, $sqft, $taxtyp)
    // {
    //     try {

    //         $res = $this->db->query("DELETE FROM " . super_model::$table_sales_bill . " WHERE local_app_user_entry_id='$local_app_user_entry_id' AND  BillNo != '$billNo'");
    //         if ($res===true) {
    //             $total = ($price - $disc) * $qty;
    //             if ($taxtyp == "EXCLUDE") {
    //                 $netV = $total + $taxAmt;
    //             } else {
    //                 $netV = $total;  
    //             }

    //             $data = array(
    //                 'SiNo' => $index,
    //                 'ItemC' => $itemC,
    //                 'Item' => $itemName,
    //                 'Qty' => $qty,
    //                 'sqft' => $sqft,
    //                 'Rate' => $price,
    //                 'ItWiseDisAmt' => '0',
    //                 'Dis' => $disc,
    //                 'Total' => $total,
    //                 'NetV' => $netV,
    //                 'GoodsOn' => $employee,
    //                 'BillNo' => $billNo,
    //                 'SBDate' => $date1,
    //                 'Cst' => $cost,
    //                 'BillTyp' => '8',
    //                 'Stat' => '0',
    //                 'local_app_user_entry_id' => $local_app_user_entry_id,
    //                 'local_app_invoice_id' => $invno,
    //                 'TaxP' => $taxPerc,
    //                 'TaxA' => $taxAmt,
    //                 'Unit' => $unit,
    //                 'Pack' => $qty_in_pack
    //             );
    // try {
    //     try {
    //         $this->db->insert(super_model::$table_sales_bill, $data);
    //     } catch (Exception  $e) {
    //         //throw $th;
    //         return FALSE;
    //     }
    //     print_r('--sd-');
    //     // if ($this->db->error()) {
    //     //     $error = $this->db->error();
    //     //     echo 'Database Error: ' . $error['code'] . ' - ' . $error['message'];
    //     // }
    //     $insert_id = $this->db->insert_id();
    //     if ($this->db->affected_rows() == 1) {
    //         return TRUE;
    //     } else {
    //         return FALSE;
    //     }
    // } catch (Exception  $e) {
    //     echo 'An error occurred: ' . $e->getMessage();
    //     return FALSE;
    // }
    // // print_r('else 1');
    // // $this->db->trans_start(); // Start a transaction
    // // print_r('else2');
    // // $this->db->insert(super_model::$table_sales_bill, $data);
    // // print_r('else3');
    // // $insert_id = $this->db->insert_id();
    // // print_r('else4');

    // if ($this->db->trans_status() === FALSE) {
    //     // If a database error occurred
    //     $this->db->trans_rollback(); // Rollback the transaction
    //     return FALSE;
    // } else {
    //     $this->db->trans_commit(); // Commit the transaction
    //     return TRUE;
    // }
    //         }else{
    //             print_r('else');
    //             return FALSE; 
    //         }
    //         return FALSE; // Return false if the DELETE query doesn't execute successfully
    //     } catch (Exception  $e) {
    //         // Handle the exception and return false
    //         echo 'An error occurred: ' . $e->getMessage();
    //         return FALSE;
    //     }
    // }



    public function saveCollectionBank($billno, $transTyp, $sino, $date1, $party, $nettotal, $Typ, $cashflow, $local_app, $retno)
    {
        // if ($this->db->query("DELETE FROM " . super_model::$table_sales_bill . " WHERE local_app_user_entry_id='$local_app_user_entry_id' AND  BillNo != '$billNo'")) {
        //     $total = ($price - $disc) * $qty;
        //     if($taxtyp=="EXCLUDE"){
        //         $netV = $total + $taxAmt;
        //     }else{
        //         $netV = $total;  
        //     }

        $data = array(
            'BillNo' => $billno,
            'TransactionType' => $transTyp,
            'SiNo' => $sino,
            'Date1' => $date1,
            'PartyName' => $party,
            'NetTotal' => $nettotal,
            'Typ' => $Typ,
            'CashFlow' => $cashflow,
            'local_app_user_entry_id' => $local_app,
            'RetNo' => $retno
        );

        $this->db->insert(super_model::$table_collection, $data);
        $insert_id = $this->db->insert_id();
        if ($this->db->affected_rows() == 1) {
            return TRUE;
        } else {
            return FALSE;
        }
    }




    public function storeUser8b($itemName, $price, $qty, $unit, $party, $godown, $employee, $date1, $invno, $local_app_user_entry_id, $billNo, $index, $taxAmt, $taxPerc, $itemC, $qty_in_pack, $cost, $disc, $sqft)
    {
        if ($this->db->query("DELETE FROM " . super_model::$table_sales_bill . " WHERE local_app_user_entry_id='$local_app_user_entry_id' AND  BillNo != '$billNo'")) {
            $total = ($price - $disc) * $qty;
            $netV = $total + $taxAmt;
            $data = array(
                'SiNo' => $index,
                'ItemC' => $itemC,
                'Item' => $itemName,
                'Qty' => $qty,
                'sqft' => $sqft,
                'Rate' => $price,
                'ItWiseDisAmt' => '0',
                'Dis' => $disc,
                'Total' => $total,
                'NetV' => $netV,
                'GoodsOn' => $employee,
                'BillNo' => $billNo,
                'SBDate' => $date1,
                'Cst' => $cost,
                'BillTyp' => '8BNEW',
                'Stat' => '0',
                'local_app_user_entry_id' => $local_app_user_entry_id,
                'local_app_invoice_id' => $invno,
                'TaxP' => $taxPerc,
                'TaxA' => $taxAmt,
                'Unit' => $unit,
                'Pack' => $qty_in_pack
            );

            $this->db->insert(super_model::$table_sales_bill, $data);
            $insert_id = $this->db->insert_id();
            if ($this->db->affected_rows() == 1) {
                return TRUE;
            } else {
                return FALSE;
            }
        }
    }

    public function storeGPS($latitude, $longitude, $party_name, $action, $date1, $user, $godown)
    {
        $data = array(
            'latitude' => $latitude,
            'longitude' => $longitude,
            'party_name' => $party_name,
            'action' => $action,
            'date1' => $date1,
            'user' => $user,
            'godown' => $godown
        );
        $this->db->insert(super_model::$table_mobile_app_gps, $data);
        $insert_id = $this->db->insert_id();
        return $insert_id;
    }

    public function getSRBillNo()
    {
        $query = $this->db->query("SELECT MAX(RetNo+1) AS retNo FROM " . super_model::$table_sr_master_details);
        if ($query->num_rows() > 0) {
            if ($row = $query->result_array()) {
                if ($row[0]["retNo"] == "Null" || $row[0]["retNo"] == null || $row[0]["retNo"] == 0) {
                    return $row[0]["retNo"] = 1;
                } else {
                    return $row[0]["retNo"];
                }
            } else {
                return false;
            }
        }
    }

    public function deleteFromSRMasterDetailsByRetNo($luserEntryID, $retNo)
    {
        $this->db->where('local_app_user_entry_id', $luserEntryID);
        $this->db->where('RetNo!=', $retNo);
        $this->db->where('local_app_user_entry_id IS NOT NULL', null, false); // raw SQL
        $this->db->delete(super_model::$table_sr_master_details);
    }

    // public function deleteFromCollectionByRetNo($luserEntryID, $retNo)
    // {
    //     $this->db->where('local_app_user_entry_id', $luserEntryID);
    //     $this->db->where('RetNo!=', $retNo);
    //     $this->db->delete(super_model::$table_collection);
    // }


    //     public function deleteFromCollectionByRetNo($luserEntryID, $retNo)
// {
//     $this->db->where('local_app_user_entry_id', $luserEntryID);
//     $this->db->where('BillNo =', $retNo);
//     $this->db->where('TransactionType', 'ToSalesReturn');
//     $this->db->where('local_app_user_entry_id IS NOT NULL', null, false); // raw SQL
//     $this->db->delete(super_model::$table_collection); // or use 'collection' directly
// }

    public function deleteFromCollectionByRetNo($luserEntryID, $retNo)
    {
        $sql = "DELETE FROM Collection 
            WHERE local_app_user_entry_id = '$luserEntryID' 
              AND BillNo = '$retNo' 
              AND TransactionType = 'ToSalesReturn' 
              AND local_app_user_entry_id IS NOT NULL
              AND BillNo <> 0";

        return $this->db->query($sql);
    }

    public function storeSalesRetunCollection($RetNo, $dates, $BillPartyName, $BillTotalField, $BillNetTotalField, $Employee, $godown, $local_app_user_entry_id, $TaxAmt, $TaxBillNo, $fin_year)
    {
        if ($this->db->query("DELETE FROM " . super_model::$table_collection . " WHERE local_app_user_entry_id='$local_app_user_entry_id' AND  BillNo != '$RetNo' AND local_app_user_entry_id IS NOT NULL AND TransactionType = 'ToSalesReturn' AND BillForm = '8' ")) {
            $data = array(
                'BillNo' => $RetNo,
                'TransactionType' => 'ToSalesReturn',
                'Date1' => $dates,
                'PartyName' => $BillPartyName,
                'Amount' => $BillNetTotalField,
                'Employee' => $Employee,
                'Typ' => 'CUSTOMER',
                'BillForm' => 'SALES RETURNB2B', //updated on 10-10-2025 
                'godown' => $Employee,
                'local_app_user_entry_id' => $local_app_user_entry_id,
                'TaxBillNo' => $TaxBillNo,
                'fin_year' => $fin_year

            );
            $this->db->insert(super_model::$table_collection, $data);
            $insert_id = $this->db->insert_id();
            return $insert_id;
        } else {
            $data = array(
                'BillNo' => $OrderLines,
                'TransactionType' => 'ToSalesReturn',
                'Date1' => $dates,
                'PartyName' => $BillPartyName,
                'Amount' => $BillNetTotalField,
                'Employee' => $Employee,
                'Typ' => 'CUSTOMER',
                'BillForm' => '8',
                'godown' => $Employee,
                'local_app_user_entry_id' => $local_app_user_entry_id,
                'TaxBillNo' => $TaxBillNo,
                'fin_year' => $fin_year
            );
            $this->db->insert(super_model::$table_collection, $data);
            $insert_id = $this->db->insert_id();
            if ($this->db->affected_rows() == 1) {
                return TRUE;
            } else {
                return FALSE;
            }
        }
    }

    public function StorePurchaseCollection($BillNo, $dates, $BillPartyName, $amount, $godown, $local_app_user_entry_id, $billtime, $TaxBillNo, $fin_year)
    {
        $data = array(
            'BillNo' => $BillNo,
            'TransactionType' => 'ToCash',
            'Date1' => $dates,
            'PartyName' => $BillPartyName,
            'Amount' => $amount,
            'Typ' => 'PURCHASE PARTY',
            'godown' => $godown,
            'Stat' => '1',
            'local_app_user_entry_id' => $local_app_user_entry_id,
            'bill_time' => $billtime,
            'Employee' => $godown,
            'Reminder' => $dates,
            'BillForm' => 'PURCHASE BILL',
            'TaxBillNo' => $TaxBillNo,
            'fin_year' => $fin_year,

        );
        $data2 = array(
            'BillNo' => $BillNo,
            'TransactionType' => 'Cash',
            'Date1' => $dates,
            'PartyName' => $BillPartyName,
            'NetTotal' => $amount,
            'Typ' => 'PURCHASE PARTY',
            'godown' => $godown,
            'Stat' => '1',
            'local_app_user_entry_id' => $local_app_user_entry_id,
            'bill_time' => $billtime,
            'Reminder' => $dates,
            'TaxBillNo' => $TaxBillNo,
            'fin_year' => $fin_year,

        );
        $this->db->insert(super_model::$table_collection, $data);
        if ($BillPartyName == "CASH PARTY") {
            $this->db->insert(super_model::$table_collection, $data2);
        }
        // $insert_id = $this->db->insert_id();
    }

    public function getUpdateQueryMasterDetails($BillNo, $BillDate, $BillPartyName, $BillTotalField, $BillDiscAmtField, $BillDiscPercField, $BillTaxField, $BillPackageField, $BillNetTotalField, $BillTyp, $BillTime, $OrderNo, $TDiscAmt, $TaxAmt, $TItTaxAmt, $TAmt, $Cess, $Lorry, $DCNoTax, $TotDiscPercAmt, $CessP, $TotItWiseQty1, $CashP, $CashCard, $CashCardAmt, $godown, $del_date, $local_app_user_entry_id, $NewBillNo, $SystemId, $Profit)
    {
        $data['BillNo'] = $BillNo;
        //        $data['BillDate'] = $BillDate;
        $data['BillPartyName'] = $BillPartyName;
        $data['BillTotalField'] = $BillTotalField;
        $data['BillDiscAmtField'] = $BillDiscAmtField;
        $data['BillDiscPercField'] = $BillDiscPercField;
        $data['BillTaxField'] = $BillTaxField;
        $data['BillPackageField'] = $BillPackageField;
        $data['BillNetTotalField'] = $BillNetTotalField;
        $data['BillTyp'] = $BillTyp;
        //        $data['BillTime'] = $BillTime;
        $data['OrderNo'] = $OrderNo;
        $data['TDiscAmt'] = $TDiscAmt;
        $data['TaxAmt'] = $TaxAmt;
        $data['TItTaxAmt'] = $TItTaxAmt;
        $data['TAmt'] = $TAmt;
        $data['Cess'] = $Cess;
        $data['Lorry'] = $Lorry;
        $data['DCNoTax'] = $DCNoTax;
        $data['TotDiscPercAmt'] = $TotDiscPercAmt;
        $data['CessP'] = $CessP;
        $data['TotItWiseQty1'] = $TotItWiseQty1;
        $data['CashP'] = $CashP;
        $data['CashCard'] = $CashCard;
        $data['CashCardAmt'] = $CashCardAmt;
        $data['godown'] = $godown;
        //        $data['del_date'] = $del_date;
        $data['local_app_user_entry_id'] = $local_app_user_entry_id;
        // $data['EmpCode'] = $EmpCode;
        //        $data['NewBillNo'] = $NewBillNo;
        $data['SystemId'] = $SystemId;
        $data['Profit'] = $Profit;
        $this->db->where('Lorry', $Lorry);
        $this->db->where('NewBillNo', $NewBillNo);
        $this->db->update(super_model::$table_master_details, $data);
        if ($this->db->affected_rows() == 1) {
            return TRUE;
        } else {
            return FALSE;
        }
    }



    public function getUpdateQuerySRMasterDetails($BillNo, $BillDate, $BillPartyName, $BillTotalField, $BillDiscAmtField, $BillDiscPercField, $BillTaxField, $BillPackageField, $BillNetTotalField, $BillTyp, $TaxAmt, $Lorry, $godown, $local_app_user_entry_id, $netQty)
    {

        $data['BillDate'] = $BillDate;
        $data['BillPartyName'] = $BillPartyName;
        $data['BillTotalField'] = $BillTotalField;
        $data['BillDiscAmtField'] = $BillDiscAmtField;
        $data['BillDiscPercField'] = $BillDiscPercField;
        $data['BillTaxField'] = $BillTaxField;
        $data['BillPackageField'] = $BillPackageField;
        $data['BillNetTotalField'] = $BillNetTotalField;
        $data['BillTyp'] = $BillTyp;
        //        $data['BillTime'] = $BillTime;
        // $data['TDiscAmt'] = $TDiscAmt;
        $data['TItTaxAmt'] = $TaxAmt;

        // $data['TItTaxAmt'] = $TaxAmt;

        //        $data['del_date'] = $del_date;
        $data['local_app_user_entry_id'] = $local_app_user_entry_id;
        $data['netQty'] = $netQty;
        // $data['EmpCode'] = $EmpCode;
        //        $data['NewBillNo'] = $NewBillNo;

        $this->db->where('Employee', $Lorry);
        $this->db->where('RetNo', $BillNo);
        $this->db->update(super_model::$table_sr_master_details, $data);
        if ($this->db->affected_rows() == 1) {
            return TRUE;
        } else {
            return FALSE;
        }
    }

    // public function getUpdateQuerySRMasterDetails(
    //     $BillNo,
    //     $BillDate,
    //     $BillPartyName,
    //     $BillTotalField,
    //     $BillDiscAmtField,
    //     $BillDiscPercField,
    //     $BillTaxField,
    //     $BillPackageField,
    //     $BillNetTotalField,
    //     $BillTyp,
    //     $TaxAmt,
    //     $Lorry,
    //     $godown,
    //     $local_app_user_entry_id,
    //     $netQty
    // ) {
    //     // Prepare data array
    //     $data = [
    //         'BillDate' => $BillDate,
    //         'BillPartyName' => $BillPartyName,
    //         'BillTotalField' => $BillTotalField,
    //         'BillDiscAmtField' => $BillDiscAmtField,
    //         'BillDiscPercField' => $BillDiscPercField,
    //         'BillTaxField' => $BillTaxField,
    //         'BillPackageField' => $BillPackageField,
    //         'BillNetTotalField' => $BillNetTotalField,
    //         'BillTyp' => $BillTyp,
    //         'TItTaxAmt' => $TaxAmt, // Map TaxAmt to TItTaxAmt
    //         'local_app_user_entry_id' => $local_app_user_entry_id,
    //         'netQty' => $netQty
    //     ];

    //     // Set WHERE conditions
    //     $this->db->where('Employee', $Lorry);
    //     $this->db->where('RetNo', $BillNo);

    //     // Execute the update query
    //     $this->db->update(super_model::$table_sr_master_details, $data);

    //     // Check if the update affected any rows
    //     if ($this->db->affected_rows() > 0) {
    //         return true; // Update successful
    //     } else {
    //         return false; // Update failed (no rows affected)
    //     }
    // }




    public function getUpdateQueryMasterDetailsNew($BillNo, $BillDate, $BillPartyName, $BillTotalField, $BillDiscAmtField, $BillDiscPercField, $BillTaxField, $BillPackageField, $BillNetTotalField, $BillTyp, $BillTime, $OrderNo, $TDiscAmt, $TaxAmt, $TItTaxAmt, $TAmt, $Cess, $Lorry, $DCNoTax, $TotDiscPercAmt, $CessP, $TotItWiseQty1, $CashP, $CashCard, $CashCardAmt, $godown, $del_date, $local_app_user_entry_id, $NewBillNo, $SystemId, $Profit)
    {
        $data['BillNo'] = $BillNo;
        //        $data['BillDate'] = $BillDate;
        $data['BillPartyName'] = $BillPartyName;
        $data['BillTotalField'] = $BillTotalField;
        $data['BillDiscAmtField'] = $BillDiscAmtField;
        $data['BillDiscPercField'] = $BillDiscPercField;
        $data['BillTaxField'] = $BillTaxField;
        $data['BillPackageField'] = $BillPackageField;
        $data['BillNetTotalField'] = $BillNetTotalField;
        $data['BillTyp'] = $BillTyp;

        //    $data['BillTime'] = $BillTime;

        $data['OrderNo'] = $OrderNo;
        $data['TDiscAmt'] = $TDiscAmt;
        $data['TaxAmt'] = $TaxAmt;
        $data['TItTaxAmt'] = $TItTaxAmt;
        $data['TAmt'] = $TAmt;
        $data['Cess'] = $Cess;
        $data['Lorry'] = $Lorry;
        $data['DCNoTax'] = $DCNoTax;
        $data['TotDiscPercAmt'] = $TotDiscPercAmt;
        $data['CessP'] = $CessP;
        $data['TotItWiseQty1'] = $TotItWiseQty1;
        $data['CashP'] = $CashP;
        $data['CashCard'] = $CashCard;
        $data['CashCardAmt'] = $CashCardAmt;
        $data['godown'] = $godown;
        //        $data['del_date'] = $del_date;
        $data['local_app_user_entry_id'] = $local_app_user_entry_id;
        //   $data['EmpCode'] = $EmpCode;
        //        $data['NewBillNo'] = $NewBillNo;
        $data['SystemId'] = $SystemId;
        $data['Profit'] = $Profit;
        $this->db->where('Lorry', $Lorry);
        $this->db->where('BillNo', $NewBillNo);
        $this->db->update(super_model::$table_master_details, $data);
        if ($this->db->affected_rows() == 1) {
            return TRUE;
        } else {
            return FALSE;
        }
    }

    // public function getUpdateQueryCollection($BillNo, $BillDate, $BillPartyName, $BillNetTotalField, $Lorry)
    // {
    //     //        $data['BillNo'] = $BillNo;
    //     //        $data['Date1'] = $BillDate;
    //     $data['PartyName'] = $BillPartyName;
    //     $data['NetTotal'] = $BillNetTotalField;
    //     $data['Typ'] = 'CUSTOMER';
    //     $data['BillForm'] = '8';
    //     $data['godown'] = $Lorry;
    //     $data['Stat'] = '1';
    //     $this->db->where('BillNo', $BillNo);
    //     $this->db->where('TransactionType', 'ToSales');
    //     $this->db->where('Typ', 'CUSTOMER');
    //     $this->db->where('BillForm', '8');
    //     $this->db->update(super_model::$table_collection, $data);
    //     if ($this->db->affected_rows() == 1) {
    //         return TRUE;
    //     } else {
    //         return FALSE;
    //     }
    // }



    public function getUpdateQueryCollection($BillNo, $BillDate, $BillPartyName, $BillNetTotalField, $Lorry)
    {
        // Common fields
        $dataCommon = array(
            'Typ' => 'CUSTOMER',
            'BillForm' => '8',
            'godown' => $Lorry,
            'Stat' => '1'
        );

        // Update 'ToSales'
        $dataToSales = array_merge($dataCommon, array(
            'PartyName' => $BillPartyName,
            'NetTotal' => $BillNetTotalField
        ));

        $this->db->where('BillNo', $BillNo);
        $this->db->where('TransactionType', 'ToSales');
        $this->db->where('Typ', 'CUSTOMER');
        $this->db->where('BillForm', '8');
        $this->db->update(super_model::$table_collection, $dataToSales);

        $affected = $this->db->affected_rows();

        // Update 'Received by Cash' if PartyName is '3'
        if ($BillPartyName == '3') {
            $dataReceived = array_merge($dataCommon, array(
                'PartyName' => $BillPartyName,
                'Amount' => $BillNetTotalField
            ));

            $this->db->where('BillNo', $BillNo);
            $this->db->where('TransactionType', 'Recieved ByCash');
            $this->db->where('Typ', 'CUSTOMER');
            $this->db->where('BillForm', '8');
            $this->db->update(super_model::$table_collection, $dataReceived);

            $affected += $this->db->affected_rows();
        }

        // Return true if at least one row was updated
        return ($affected > 0);
    }



    public function getQuerymasterdetails($tableName, $dbData)
    {
        $isFirstItem = true;
        $query = "INSERT INTO " . $tableName . "(";
        $keyQuery = "";
        $valueQuery = ") VALUES(";
        foreach ($dbData as $key => $value) {
            if ($key == "upload_status") {
                continue;
            }

            if ($isFirstItem) {
                $keyQuery = $keyQuery . $key;
                $valueQuery = $valueQuery . "'" . $value . "'";
                $isFirstItem = false;
            } else {
                $keyQuery = $keyQuery . "," . $key;
                $valueQuery = $valueQuery . ",'" . $value . "'";
            }
        }
        $valueQuery = $valueQuery . ")";
        $query = $query . $keyQuery . $valueQuery;
        $data = $this->db->query($query);
        $insert_id = $this->db->insert_id();
        $cnt = $this->db->affected_rows();
        return $cnt;
    }

    public function getQuerySRmasterdetails($tableName, $dbData)
    {
        $isFirstItem = true;
        $query = "INSERT INTO " . $tableName . "(";
        $keyQuery = "";
        $valueQuery = ") VALUES(";

        foreach ($dbData as $key => $value) {
            // Skip 'upload_status'
            if ($key == "upload_status") {
                continue;
            }

            // Map 'TaxAmt' value to 'TItTaxAmt' column
            if ($key == "TaxAmt") {
                $key = "TItTaxAmt"; // Change the column name to TItTaxAmt
            }

            // Build the key and value parts of the query
            if ($isFirstItem) {
                $keyQuery .= $key; // Add the first column name
                $valueQuery .= "'" . $value . "'"; // Add the first value
                $isFirstItem = false; // No longer the first item
            } else {
                $keyQuery .= "," . $key; // Append subsequent column names
                $valueQuery .= ",'" . $value . "'"; // Append subsequent values
            }
        }

        $valueQuery .= ")";
        $query .= $keyQuery . $valueQuery;

        // Debugging: Log the query to ensure it's generated correctly
        error_log("Generated Query: " . $query);

        // Execute the query
        $data = $this->db->query($query);
        $insert_id = $this->db->insert_id();
        $cnt = $this->db->affected_rows();

        // Return the count of affected rows
        return $cnt;
    }




    public function getQuery($tableName, $dbData)
    {
        $isFirstItem = true;
        $query = "INSERT INTO " . $tableName . "(";
        $keyQuery = "";
        $valueQuery = ") VALUES(";
        foreach ($dbData as $key => $value) {
            if ($key == "upload_status") {
                continue;
            }
            if ($isFirstItem) {
                $keyQuery = $keyQuery . $key;
                $valueQuery = $valueQuery . "'" . $value . "'";
                $isFirstItem = false;
            } else {
                $keyQuery = $keyQuery . "," . $key;
                $valueQuery = $valueQuery . ",'" . $value . "'";
            }
        }
        $valueQuery = $valueQuery . ")";
        $query = $query . $keyQuery . $valueQuery;
        $data = $this->db->query($query);
        $insert_id = $this->db->insert_id();
        if ($this->db->affected_rows() == 1) {
            return TRUE;
        } else {
            return FALSE;
        }
    }


    public function getQueryZatca_Einv_Table($tableName, $dbData)
    {
        $isFirstItem = true;
        $query = "INSERT INTO " . $tableName . "(";
        $keyQuery = "";
        $valueQuery = ") VALUES(";
        foreach ($dbData as $key => $value) {
            if ($key == "upload_status") {
                continue;
            }

            // Escape single quotes to avoid SQL syntax error
            $value = str_replace("'", "''", $value);

            if ($isFirstItem) {
                $keyQuery = $keyQuery . $key;
                $valueQuery = $valueQuery . "'" . $value . "'";
                $isFirstItem = false;
            } else {
                $keyQuery = $keyQuery . "," . $key;
                $valueQuery = $valueQuery . ",'" . $value . "'";
            }
        }
        $valueQuery = $valueQuery . ")";
        $query = $query . $keyQuery . $valueQuery;
        $data = $this->db->query($query);
        $insert_id = $this->db->insert_id();
        if ($this->db->affected_rows() == 1) {
            return TRUE;
        } else {
            return FALSE;
        }
    }


    public function storeSalesRetun($itemName, $price, $qty, $unit, $party, $godown, $employee, $date1, $invno, $local_app_user_entry_id, $retNo, $index, $taxAmt, $taxPerc, $itemC, $qty_in_pack, $cost, $disc, $taxtyp)
    {
        if ($this->db->query("DELETE FROM " . super_model::$table_sales_return . " WHERE local_app_user_entry_id='$local_app_user_entry_id' AND  RetNo != '$retNo' AND local_app_user_entry_id IS NOT NULL  ")) {
            $total = ($price - $disc) * $qty;
            //  $netV = $total + $taxAmt;
            if ($taxtyp == "EXCLUDE") {
                $netV = $total + $taxAmt;
            } else {
                $netV = $total;
            }

            //      // Ensure `taxAmt` matches the JSON payload
            // $taxAmt = sprintf('%.2f', $taxAmt);

            $data = array(
                'SiNo' => $index,
                'ItemC' => $itemC,
                'Item' => $itemName,
                'Qty' => $qty,
                'sqft' => $cost,
                'Rate' => $price,
                'Dis' => $disc,
                'Tot' => $total,
                'TaxP' => $taxPerc,
                'TaxA' => $taxAmt,
                'Total' => $netV,
                'RetNo' => $retNo,
                'SBDate' => $date1,
                'Stat' => '0',
                'godown' => $employee,
                'local_app_user_entry_id' => $local_app_user_entry_id,
                'Unit' => $unit,
                'Pack' => $qty_in_pack
            );
            $this->db->insert(super_model::$table_sales_return, $data);
            $insert_id = $this->db->insert_id();
            if ($this->db->affected_rows() == 1) {
                return TRUE;
            } else {
                return FALSE;
            }
        }
    }

    public function getOrderBillNo()
    {
        $query = $this->db->query("SELECT MAX(BillNo+1) AS BillNo FROM " . super_model::$table_master_details8B);
        if ($query->num_rows() > 0) {
            if ($row = $query->result_array()) {
                return $row[0]["BillNo"];
            } else {
                return false;
            }
        }
    }

    public function deleteFromMasterDetails8BByBillNo($billNo, $luserEntryID)
    {
        $this->db->where('local_app_user_entry_id', $luserEntryID);
        $this->db->where('BillNo!=', $billNo);
        $this->db->delete(super_model::$table_master_details8B);
    }

    public function storeOrderUser($itemName, $price, $qty, $unit, $party, $godown, $employee, $date1, $invno, $local_app_user_entry_id, $billNo, $index, $taxAmt, $taxPerc, $itemC, $qty_in_pack, $cost)
    {
        if ($this->db->query("DELETE FROM " . super_model::$table_sales_bill8B . " WHERE local_app_user_entry_id='$local_app_user_entry_id' AND  BillNo != '$billNo'")) {
            $total = $price * $qty;
            $netV = $total + $taxAmt;
            $data = array(
                'SiNo' => $index,
                'ItemC' => $itemC,
                'Item' => $itemName,
                'Qty' => $qty,
                'sqft' => '0',
                'Rate' => $price,
                'ItWiseDisAmt' => '0',
                'Dis' => '0',
                'Total' => $total,
                'NetV' => $netV,
                'GoodsOn' => $godown,
                'BillNo' => $billNo,
                'SBDate' => $date1,
                'Cst' => '0',
                'BillTyp' => '8B',
                'Stat' => '0',
                'local_app_user_entry_id' => $local_app_user_entry_id,
                'local_app_invoice_id' => $invno,
                'TaxP' => $taxPerc,
                'TaxA' => $taxAmt,
                'Pack' => $qty_in_pack,
                'Unit' => $unit,
                'Cst' => $cost,
            );
            $this->db->insert(super_model::$table_sales_bill8B, $data);
            $insert_id = $this->db->insert_id();
            if ($this->db->affected_rows() == 1) {
                return TRUE;
            } else {
                return FALSE;
            }
        }
    }


    public function addNewParty($name, $code, $address1, $address2, $mobNo, $gstNumber, $stateAndCode, $balance, $user, $dateTime, $local_app_user_entry_id, $partyType, $location_cordinates, $oldName, $mid)
    {
        // Delete from table_master based on oldName
        $this->db->where('Name', $oldName);
        $this->db->delete(super_model::$table_master);

        // Delete corresponding data from table_collection based on PartyName and TransactionType
        $this->db->where('PartyName', $oldName);
        $this->db->where('TransactionType', 'Opening');
        $this->db->delete(super_model::$table_collection);

        $data = array(
            'Name' => $name,
            'Typ' => $partyType,
            'Code' => $code,
            'Address1' => $address1,
            'Address2' => $address2,
            'TinNo' => $gstNumber,
            'CstNo' => $stateAndCode,
            'Salary' => 'DAILY',
            'Bank' => 'CURRENT',
            'Opening' => $balance,
            'Stat' => '0',
            'emp' => $user,
            'Ph' => $mobNo,
            'local_app_user_entry_id' => $local_app_user_entry_id,
            'location' => $location_cordinates,
            'mid' => $mid
        );

        $this->db->db_debug = false;
        if (!$this->db->insert(super_model::$table_master, $data)) {
            $error = $this->db->error(); // Has keys 'code' and 'message'
            return FALSE;
        }

        $insert_id = $this->db->insert_id();
        if ($this->db->affected_rows() == 1) {
            $data2 = array(
                'Date1' => $dateTime,
                'PartyName' => $name,
                'TransactionType' => 'Opening',
                'Typ' => $partyType,
                'Stat' => '0',
                'Employee' => $user,
                'Amount' => '0'
            );

            if ($partyType == "PURCHASE PARTY") {
                $data2['Amount'] = $balance;
            } else {
                $data2['NetTotal'] = $balance;
            }

            $this->db->insert(super_model::$table_collection, $data2);
            $insert_id = $this->db->insert_id();
            if ($this->db->affected_rows() == 1) {
                return TRUE;
            } else {
                // Delete inserted master data if collection insert fails
                $this->db->where('Typ', 'CUSTOMER');
                $this->db->where('Name', $name);
                $this->db->delete(super_model::$table_master);

                // Ensure the collection record is also deleted to maintain consistency
                $this->db->where('PartyName', $name);
                $this->db->where('TransactionType', 'Opening');
                $this->db->delete(super_model::$table_collection);

                return FALSE;
            }
        } else {
            return FALSE;
        }
    }

    public function mid_find($Typ1, $ledgerTypes)
    {
        $mid = 0;

        $sql1 = "SELECT MAX(mid) + 1 AS mid FROM " . super_model::$table_master . " WHERE Typ = ?";
        $result1 = $this->db->query($sql1, array($Typ1))->row_array();

        if (!empty($result1['mid'])) {
            $mid = (int) $result1['mid'];
            // echo "aaaa<br>";
        } else {
            $sql2 = "SELECT MAX(CAST(Code1 AS SIGNED)) + 1 AS mid FROM " . super_model::$table_ledgertypes . " WHERE Description = ?";
            $result2 = $this->db->query($sql2, array($ledgerTypes))->row_array();

            if (!empty($result2['mid'])) {
                $mid = (int) $result2['mid'];
                // echo "bbbb<br>";
            }
        }

        if ($mid == 0) {
            $sql3 = "SELECT MAX(CAST(Code1 AS SIGNED)) + 1 AS mid FROM " . super_model::$table_ledgertypes . "  WHERE Description = ?";
            $result3 = $this->db->query($sql3, array($ledgerTypes))->row_array();

            if (!empty($result3['mid'])) {
                $mid = (int) $result3['mid'];
                // echo "bbbb<br>";
            }
        }

        return $mid;
    }




    // public function updateDebitReport($billNo,$empName)
    // {
    //     $query = $this->db->query("SELECT DISTINCT  * FROM " . super_model::$table_collection . " WHERE SiNo='$billNo' AND TransactionType = 'Cash'");
    //     $data = $query->result_array();
    //     return $data;
    // }


    public function updateDebitReport($billNo, $empName)
    {
        // Step 1: First check if any row exists with Employee = 'ABDUL AZEEZ'
        $checkQuery = $this->db->query("
        SELECT COUNT(*) AS cnt 
        FROM " . super_model::$table_collection . " 
        WHERE SiNo = ? AND Employee = '$empName' 
    ", array($billNo));

        $count = $checkQuery->row()->cnt;

        // Step 2: Decide which query to run
        if ($count > 0) {
            // print "aaaaaa";
            $query = $this->db->query("
            SELECT DISTINCT * 
            FROM " . super_model::$table_collection . " 
            WHERE SiNo = ? 
              AND Employee = '$empName'
        ", array($billNo));

        } else {
            //  print "bbbbbb";
            // If found, get RECEIPT with DEBIT
            $query = $this->db->query("
            SELECT DISTINCT * 
            FROM " . super_model::$table_collection . " 
            WHERE SiNo = ? 
              AND BillForm = 'RECEIPT' 
              AND CashFlow = 'DEBIT' AND Employee = '$empName'
        ", array($billNo));
        }

        return $query->result_array();
    }


    public function storeDebit($party, $amount, $date1, $user, $godown, $image_data, $transaction_type, $cheque_no, $narration, $local_app_user_entry_id, $SiNo, $prefix_val)
    {
        $billTime = date("h:i A", strtotime($date1));
        $date1 = date("Y-m-d", strtotime($date1)) . " 00:00:00";
        $query = $this->db->query("SELECT COUNT(*) AS cnt FROM " . super_model::$table_collection . " WHERE local_app_user_entry_id ='$local_app_user_entry_id'");
        if ($row = $query->result_array()) {
            if ($row[0]['cnt'] < 1) {
                if ($transaction_type == "PURCHASE PARTY") {
                    $data2 = array(
                        'SiNo' => $SiNo,
                        'TransactionType' => "Cash",
                        'Date1' => $date1,
                        'PartyName' => $party,
                        'NetTotal' => $amount,
                        'Employee' => $user,
                        'Typ' => 'PURCHASE PARTY',
                        'CashFlow' => 'DEBIT',
                        'godown' => 'MAIN',
                        'Stat' => '0',
                        'ChequeNo' => $cheque_no,
                        'Narration' => $narration,
                        'image_data' => $image_data,
                        'bill_time' => $billTime,
                        'prefix' => $prefix_val . $SiNo,
                        'local_app_user_entry_id' => $local_app_user_entry_id
                    );
                } elseif ($transaction_type == "EXPENSE") {
                    $data2 = array(
                        'SiNo' => $SiNo,
                        'TransactionType' => "Cash",
                        'Date1' => $date1,
                        'PartyName' => $party,
                        'NetTotal' => $amount,
                        'Employee' => $user,
                        'Typ' => 'EXPENSE',
                        'CashFlow' => 'DEBIT',
                        'godown' => 'MAIN',
                        'Stat' => '0',
                        'ChequeNo' => $cheque_no,
                        'Narration' => $narration,
                        'image_data' => $image_data,
                        'bill_time' => $billTime,
                        'prefix' => $prefix_val . $SiNo,
                        'local_app_user_entry_id' => $local_app_user_entry_id
                    );
                } else {
                    // $data2 = array(
                    //     'SiNo' => $SiNo,
                    //     'TransactionType' => $transaction_type,
                    //     'Date1' => $date1,
                    //     'PartyName' => $party,
                    //     'Amount' => $amount,
                    //     'Employee' => $user,
                    //     'Typ' => 'CUSTOMER',
                    //     'CashFlow' => 'DEBIT',
                    //     'godown' => 'MAIN',
                    //     'Stat' => '0',
                    //     'ChequeNo' => $cheque_no,
                    //     'Narration' => $narration,
                    //     'image_data' => $image_data,
                    //     'bill_time' => $billTime,
                    //     'local_app_user_entry_id' => $local_app_user_entry_id
                    // );

                    // // Set CashFlow conditionally
                    $cashFlowValue = in_array($transaction_type, ['RTGS', 'Cheque', 'DD']) ? '1' : 'DEBIT';
                    // $cashFlowValue  = 'DEBIT'

                    $data2 = array(
                        'SiNo' => $SiNo,
                        'TransactionType' => $transaction_type,
                        'Date1' => $date1,
                        'PartyName' => $party,
                        'Amount' => $amount,
                        'Employee' => $user,
                        'Typ' => 'CUSTOMER',
                        'CashFlow' => $cashFlowValue,
                        'godown' => $user,
                        'Stat' => '0',
                        'ChequeNo' => $cheque_no,
                        'Narration' => $narration,
                        'image_data' => $image_data,
                        'bill_time' => $billTime,
                        'BillNo' => '0',
                        'BillForm' => 'RECEIPT',
                        //'prefix' => $prefix_val . $SiNo,
                        'prefix' => !empty($prefix_val) ? $prefix_val . $SiNo : "",
                        'local_app_user_entry_id' => $local_app_user_entry_id
                    );
                }

                $this->db->insert(super_model::$table_collection, $data2);
                $insert_id = $this->db->insert_id();
                if ($this->db->affected_rows() == 1) {
                    return TRUE;
                } else {
                    return FALSE;
                }
            } else {
                return FALSE;
            }
        } else {
            return FALSE;
        }
    }


    // public function storeCollectionBank($party, $amount, $date1, $user, $godown, $image_data, $transaction_type, $cheque_no, $narration, $local_app_user_entry_id, $SiNo)
    // {
    //     // Ensure $date1 is parsed and formatted correctly
    //     $billTime = date("h:i A", strtotime($date1));
    //     $date1 = date("Y-m-d", strtotime($date1)) . " 00:00:00";

    //     // Build the data array
    //     $data2 = array(
    //         'SiNo' => $SiNo,
    //         'TransactionType' => $transaction_type,
    //         'Date1' => $date1,
    //         'PartyName' => $party,
    //         'NetTotal' => $amount,
    //         'Employee' => $user,
    //         'Typ' => $narration,
    //         'CashFlow' => '2',
    //         'godown' => $godown,
    //         'Stat' => '0',
    //         'ChequeNo' => $cheque_no,
    //         'Narration' => "",
    //         'image_data' => $image_data,
    //         'bill_time' => $billTime,
    //         'local_app_user_entry_id' => $local_app_user_entry_id
    //     );

    //     // Insert into DB
    //     $this->db->insert(super_model::$table_collection, $data2);
    //     $insert_id = $this->db->insert_id();

    //     // Check if insert was successful
    //     if ($this->db->affected_rows() == 1) {
    //         return TRUE;
    //     } else {
    //         return FALSE;
    //     }
    // }


    public function storeCollectionBank($party, $amount, $date1, $user, $godown, $image_data, $transaction_type, $cheque_no, $narration, $local_app_user_entry_id, $SiNo, $prefix_val, $party2)
    {
        // Check if record with local_app_user_entry_id already exists
        $query = $this->db->query("SELECT COUNT(*) AS cnt FROM " . super_model::$table_collection . " WHERE local_app_user_entry_id = ? AND CashFlow = '2' ", array($local_app_user_entry_id));
        $row = $query->row_array();

        // If count is 0, insert the data
        if ($row['cnt'] < 1) {
            // Format date and time
            $billTime = date("h:i A", strtotime($date1));
            $date1Formatted = date("Y-m-d", strtotime($date1)) . " 00:00:00";

            // Build insert data
            $data2 = array(
                'SiNo' => $SiNo,
                'TransactionType' => $transaction_type,
                'Date1' => $date1Formatted,
                'PartyName' => $party,
                'NetTotal' => $amount,
                'Employee' => $user,
                'Typ' => $narration,
                'CashFlow' => '2',
                'godown' => $godown,
                'Stat' => '0',
                'ChequeNo' => $cheque_no,
                'Narration' => $party2,
                'image_data' => $image_data,
                'bill_time' => $billTime,
                'BillForm' => 'PAYMENT',
                'prefix' => $prefix_val . $SiNo,
                'local_app_user_entry_id' => $local_app_user_entry_id
            );

            // Insert into DB
            $this->db->insert(super_model::$table_collection, $data2);

            // Return TRUE only if one row was inserted
            return ($this->db->affected_rows() == 1);
        } else {
            // Record already exists, do not insert
            return FALSE;
        }
    }






    public function storeCredit($party, $amount, $date1, $user, $godown, $transaction_type, $cheque_no, $narration, $local_app_user_entry_id, $SiNo)
    {
        $billTime = date("h:i A", strtotime($date1));
        $date1 = date("Y-m-d", strtotime($date1)) . " 00:00:00";
        $query = $this->db->query("SELECT COUNT(*) AS cnt FROM " . super_model::$table_collection . " WHERE local_app_user_entry_id ='$local_app_user_entry_id'");
        if ($row = $query->result_array()) {
            if ($row[0]['cnt'] < 1) {
                $data2 = array(
                    'SiNo' => $SiNo,
                    'TransactionType' => $transaction_type,
                    'Date1' => $date1,
                    'PartyName' => $party,
                    'NetTotal' => $amount,
                    'Employee' => $user,
                    'Typ' => 'PURCHASE PARTY',
                    'CashFlow' => 'CREDIT',
                    'godown' => $user,
                    'Stat' => '0',
                    'ChequeNo' => $cheque_no,
                    'Narration' => $narration,
                    // 'image_data' => $image_data,
                    'bill_time' => $billTime,
                    'BillForm' => 'PAYMENT',
                    'local_app_user_entry_id' => $local_app_user_entry_id
                );
                $this->db->insert(super_model::$table_collection, $data2);
                $insert_id = $this->db->insert_id();
                if ($this->db->affected_rows() == 1) {
                    return TRUE;
                } else {
                    return FALSE;
                }
            } else {
                return FALSE;
            }
        } else {
            return FALSE;
        }
    }



    public function storeExpense($party, $amount, $date1, $user, $godown, $transaction_type, $cheque_no, $narration, $local_app_user_entry_id, $SiNo, $TaxP, $TaxAmt, $prefix_val)
    {
        $billTime = date("h:i A", strtotime($date1));
        $date1 = date("Y-m-d", strtotime($date1)) . " 00:00:00";
        $query = $this->db->query("SELECT COUNT(*) AS cnt FROM " . super_model::$table_collection . " WHERE local_app_user_entry_id ='$local_app_user_entry_id'");
        if ($row = $query->result_array()) {
            if ($row[0]['cnt'] < 1) {
                $data2 = array(
                    'SiNo' => $SiNo,
                    'TransactionType' => $transaction_type,
                    'Date1' => $date1,
                    'PartyName' => $party,
                    'NetTotal' => $amount,
                    'Employee' => $user,
                    'Typ' => 'EXPENSE',
                    'CashFlow' => 'CREDIT',
                    'godown' => $godown,
                    'Stat' => '0',
                    'ChequeNo' => $cheque_no,
                    'Narration' => $narration,
                    'bill_time' => $billTime,
                    'BillForm' => 'PAYMENT',
                    'TaxP' => $TaxP,
                    'TaxAmt' => $TaxAmt,
                    'local_app_user_entry_id' => $local_app_user_entry_id,
                    'prefix' => !empty($prefix_val) ? $prefix_val . $SiNo : "",
                );
                $this->db->insert(super_model::$table_collection, $data2);
                $insert_id = $this->db->insert_id();
                if ($this->db->affected_rows() == 1) {
                    return TRUE;
                } else {
                    return FALSE;
                }
            } else {
                return FALSE;
            }
        } else {
            return FALSE;
        }
    }



    public function storeDamage($data, $billno)
    {
        $insert = $this->db->query("INSERT INTO damagemaster (Stock_No,TotalQty,NetTotal,Date1,Descri)VALUES($billno,'" . $data[0]["qty"] . "','" . $data[0]["total"] . "','" . $data[0]["Date"] . "','NIL')");
        // print_r($data[0]["itemcode"]);
        //$insert2 = $this->db->query("INSERT  INTO damagetable(SiNo,Barcode,ItemName,Qty,Rate,Total,Warhouse,Inv_no,Pack,Unit,batch_no) values(1,'".$data[0]["itemcode"]."','test',2,45,80,'USER',$billno,1,'PCS','NIL')");
        $insert2 = $this->db->query("INSERT  INTO damagetable(SiNo,Barcode,ItemName,Qty,Rate,Total,Warhouse,Inv_no,Pack,Unit,batch_no,ExpiryDate,Date1) values(1,'" . $data[0]["itemcode"] . "','" . $data[0]["itemname"] . "','" . $data[0]["qty"] . "','" . $data[0]["rate"] . "','" . $data[0]["total"] . "','" . $data[0]["godown"] . "',$billno,'" . $data[0]["pack"] . "','" . $data[0]["unit"] . "','NIL','" . $data[0]["Date"] . "','" . $data[0]["Date"] . "')");
        if ($this->db->affected_rows() == 1) {
            return TRUE;
        } else {
            return FALSE;
        }
    }



    public function storeProduct($itemname, $itemcode, $stock, $user, $godown, $base_rate_retail, $sec_rate_retail, $base_unit, $sec_unit, $category, $img, $tax, $base_rate_wholesale, $sec_rate_wholesale, $qty_in_pack, $local_app_user_entry_id, $Cost, $SecCostRate, $StockInMain, $Rate3, $prod_typ, $CostRs, $Disc, $DiscP, $Color, $ArabicName, $ThirdCost, $ThirdRate, $ThirdUnit, $ThirdPack, $barcode, $old_name, $upload_typ, $SecBarcode, $ThirdBarcode)
    {
        $billTime = date("h:i A");
        $date1 = date("Y-m-d") . " 00:00:00";
        $query2 = $this->db->query("SELECT COUNT(*) AS itemNameCount FROM " . super_model::$table_sales_item . " WHERE ItemNameTextField ='$itemname'");
        if ($itemName = $query2->result_array()) {
            // echo'aaaaaaaaaaa';
            if ($itemName[0]['itemNameCount'] < 1) {
                // echo'ddddddddddd';
                $query = $this->db->query("SELECT COUNT(*) AS cnt FROM " . super_model::$table_sales_item . " WHERE local_app_user_entry_id ='$local_app_user_entry_id'");
                $query1 = $this->db->query("SELECT MAX( ItemNo ) + 1 AS itemNo FROM " . super_model::$table_sales_item);
                $itemNo = $query1->result_array();
                if ($row = $query->result_array()) {
                    if ($row[0]['cnt'] < 1) {

                        $barcodeinsert = $this->db->query("INSERT INTO Barcode (ItemName,NewBarNo,NewBarText,Typ,BillNo,Stat)VALUES('$itemname','$barcode','$barcode','FromSalesItem','','')");

                        $data2 = array(
                            'ItemNo' => $itemNo[0]['itemNo'],
                            'ItemNameTextField' => $itemname,
                            // 'ItemC' => $itemcode,
                            'ItemC' => $barcode,
                            'StockInMain' => $StockInMain,
                            'StockInGoDown' => '0',
                            'Cost' => $Cost,
                            'Rate1' => $base_rate_retail,
                            'Rate2' => $base_rate_wholesale,
                            'Rate3' => $Rate3,
                            'Disc' => $Disc,
                            'Tax1' => $tax,
                            'DiscP' => $DiscP,
                            'Color' => $Color,
                            'Size' => $category,
                            'MfgDate' => $date1,
                            'CostRs' => $CostRs,
                            'Typ' => $base_unit,
                            'Stat' => '0',
                            'Pack' => $qty_in_pack,
                            'prod_typ' => $prod_typ,
                            'photo' => $img,
                            'RatePerInch' => '0',
                            'photo1' => '0',
                            'curr_stock' => $stock,
                            'SecUnit' => $sec_unit,
                            'SecCostRate' => $SecCostRate,
                            'SecRetailRate' => $sec_rate_retail,
                            'SecWholesaleRate' => $sec_rate_wholesale,
                            'local_app_user_entry_id' => $local_app_user_entry_id,
                            'empCode' => $user,
                            'ArabicName' => $ArabicName,
                            'ThirdCost' => $ThirdCost,
                            'ThirdRate1' => $ThirdRate,
                            'ThirdUnit' => $ThirdUnit,
                            'NewItemCode' => $itemcode,
                            'ThirdPack' => $ThirdPack,
                            'SecBarcode' => $SecBarcode,
                            'ThirdBarcode' => $ThirdBarcode,
                            'subCategory' => 'NIL',
                            'carmaker' => 'NIL',
                            'model' => 'NIL',
                            'year1' => 'NIL',
                            'varient' => 'NIL',
                            'printer' => 'ALL KOT'


                        );
                        $this->db->insert(super_model::$table_sales_item, $data2);
                        $insert_id = $this->db->insert_id();
                        if ($this->db->affected_rows() == 1) {
                            return TRUE;
                        } else {
                            return FALSE;
                        }
                    } else {
                        return FALSE;
                    }
                } else {
                    return FALSE;
                }
            } else {
                //echo 'wwwwwwwwwwww';

                if ($upload_typ == "DIRECT") {
                    // Delete from salesitem based on oldName
                    $this->db->where('ItemNameTextField', $old_name);
                    $this->db->delete(super_model::$table_sales_item);

                    $data2 = array(
                        'ItemNameTextField' => $itemname,
                        // 'ItemC' => $itemcode,
                        'ItemC' => $barcode,
                        'StockInMain' => $StockInMain,
                        'StockInGoDown' => '0',
                        'Cost' => $Cost,
                        'Rate1' => $base_rate_retail,
                        'Rate2' => $base_rate_wholesale,
                        'Rate3' => $Rate3,
                        'Disc' => $Disc,
                        'Tax1' => $tax,
                        'DiscP' => $DiscP,
                        'Color' => $Color,
                        'Size' => $category,
                        'MfgDate' => $date1,
                        'CostRs' => $CostRs,
                        'Typ' => $base_unit,
                        'Stat' => '0',
                        'Pack' => $qty_in_pack,
                        'prod_typ' => $prod_typ,
                        'photo' => $img,
                        'RatePerInch' => '0',
                        'photo1' => '0',
                        'curr_stock' => $stock,
                        'SecUnit' => $sec_unit,
                        'SecCostRate' => $SecCostRate,
                        'SecRetailRate' => $sec_rate_retail,
                        'SecWholesaleRate' => $sec_rate_wholesale,
                        'local_app_user_entry_id' => $local_app_user_entry_id,
                        'empCode' => $user,
                        'ArabicName' => $ArabicName,
                        'ThirdCost' => $ThirdCost,
                        'ThirdRate1' => $ThirdRate,
                        'ThirdUnit' => $ThirdUnit,
                        'NewItemCode' => $itemcode,
                        'ThirdPack' => $ThirdPack,
                        'printer' => 'ALL KOT'


                    );
                    $this->db->insert(super_model::$table_sales_item, $data2);
                    $insert_id = $this->db->insert_id();
                    if ($this->db->affected_rows() == 1) {
                        return TRUE;
                    } else {
                        return FALSE;
                    }

                } else {
                    //  echo 'zzzzz';
                    return true;
                }

            }
        } else {
            return FALSE;
        }
    }

    public function getPurchaseInvNo()
    {
        $query = $this->db->query("SELECT MAX(InvoiceNo+1) AS invNo FROM " . super_model::$table_Pbill);
        if ($query->num_rows() > 0) {
            if ($row = $query->result_array()) {
                return $row[0]["invNo"];
            } else {
                return false;
            }
        }
    }

    public function deleteFromPBillByInvoNo($luserEntryID, $billNo)
    {
        $this->db->where('local_app_user_entry_id', $luserEntryID);
        $this->db->where('PBillNo!=', $billNo);
        $this->db->where('local_app_user_entry_id IS NOT NULL', null, false); // Raw where clause
        $this->db->delete(super_model::$table_purchase_bill);
    }

    public function storePurchaseBill($itemName, $price, $qty, $unit, $party, $godown, $employee, $date1, $invno, $local_app_user_entry_id, $invNO, $index, $taxAmt, $taxPerc, $itemC, $qty_in_pack)
    {
        if ($this->db->query("DELETE FROM " . super_model::$table_purchase_bill . " WHERE local_app_user_entry_id='$local_app_user_entry_id' AND  PBillNo != '$invNO' AND local_app_user_entry_id IS NOT NULL  ")) {
            $total = $price * $qty;
            $netV = $total + $taxAmt;
            $data = array(
                'PBillNo' => $invNO,
                'PSiNo' => $index,
                'ItemC' => $itemC,
                'PItem' => $itemName,
                'PQty' => $qty,
                'sqft' => '0',
                'PRate' => $price,
                'PDis' => '0',
                'PTotal' => $total,
                'PTaxP' => $taxPerc,
                'PTaxA' => $taxAmt,
                'PNetV' => $total,
                'Perc' => '0',
                'MRP' => '0',
                'SRP' => '0',
                'PGoodsOn' => 'MAIN',
                'PBDate' => $date1,
                'Stat' => '0',
                'Pack' => $qty_in_pack,
                'Unit' => $unit,
                'local_app_user_entry_id' => $local_app_user_entry_id

            );
            $this->db->insert(super_model::$table_purchase_bill, $data);
            $insert_id = $this->db->insert_id();
            if ($this->db->affected_rows() == 1) {
                return TRUE;
            } else {
                return FALSE;
            }
        }
    }

    public function listParty()
    {
        $query = $this->db->query("SELECT Name, Code, Ph, (SUM(NetTotal)-SUM(Amount)) AS Opening FROM " . super_model::$table_master . " LEFT JOIN " . super_model::$table_collection . " ON Master.Name = Collection.PartyName WHERE  Master.Typ = 'CUSTOMER'  GROUP BY Master.Name ORDER BY NAME ASC");
        $data = $query->result_array();
        for ($i = 0; $i < count($data); $i++) {
            if ($data[$i]["Opening"] == null) {
                $data[$i]["Opening"] = "";
            }
        }
        return $data;
    }

    public function deleteFromMaster($typ, $name)
    {
        $this->db->where('Typ', $typ);
        $this->db->where('Name', $name);
        $this->db->delete(super_model::$table_master);
    }

    public function deleteFromCollection($TransactionType, $typ, $name)
    {
        $this->db->where('TransactionType', $TransactionType);
        $this->db->where('Typ', $typ);
        $this->db->where('PartyName', $name);
        $this->db->delete(super_model::$table_collection);
    }

    public function getPartyByName($name)
    {
        $query = $this->db->query("SELECT * FROM " . super_model::$table_master . " WHERE Typ='CUSTOMER' AND Name='$name'");
        $data = $query->result_array();
        return $data;
    }



    public function getPurchaseBarcode($name)
    {
        $query = $this->db->query("SELECT PItem,PRate,PRate,SRP,Pack,Unit,PTaxP,PTaxA,PNetV,MRP FROM purchasebill WHERE ItemC = '$name' ORDER BY PBillNo DESC");
        $data = $query->result_array();
        return $data;
    }




    public function getBarcodeStock($name)
    {
        $query = $this->db->query("SELECT SUM(PQty) AS qty FROM PurchaseBill WHERE ItemC = '$name'");
        $data = $query->result_array();
        $pqty = $data[0]['qty'];

        $query = $this->db->query("SELECT SUM(Qty) AS qty FROM PurchaseReturn WHERE ItemC = '$name'");
        $data2 = $query->result_array();
        $prqty = $data2[0]['qty'];

        $query = $this->db->query("SELECT SUM(Qty) AS qty  FROM SalesBill WHERE ItemC ='$name'");
        $data3 = $query->result_array();
        $sqty = $data3[0]['qty'];

        $query = $this->db->query("SELECT SUM(Qty) AS qty FROM SalesReturn WHERE ItemC  ='$name'");
        $data4 = $query->result_array();
        $srqty = $data4[0]['qty'];

        $query = $this->db->query("SELECT sum(Qty) as qty from damagetable where Barcode='$name'");
        $data5 = $query->result_array();
        $dmgqty = $data5[0]['qty'];

        $stock = (($pqty - $prqty) - ($sqty - $srqty) - $dmgqty);


        return $stock;
    }


    public function getBarcodeStockForTakeStock($barcode)
    {
        $a = [];
        $b = [];

        $br = json_decode($barcode, true);
        // $a=array();
        for ($i = 0; $i < count($br); $i++) {

            $bar = $br[$i]['barcode'];

            $query = $this->db->query("SELECT SUM(Qty) AS qty  FROM SalesBill WHERE ItemC = $bar");
            $data3 = $query->result_array();
            $sqty = $data3[0]['qty'];

            $query = $this->db->query("SELECT SUM(Qty) AS qty FROM SalesReturn WHERE ItemC  = $bar");
            $data4 = $query->result_array();
            $srqty = $data4[0]['qty'];
            $stock = ($sqty - $srqty);


            $b['qty'] = $stock;
            $b['barcode'] = $bar;


            array_push($a, $b);
            //   array_push($a,$stock,$bar);


        }



        // return $a;
        echo json_encode($a);
    }



    public function getEnquiryDescription($name, $no)
    {
        $query = $this->db->query("SELECT DESCRIPTION AS descr FROM enquiry WHERE enq_no='$no' AND product='$name'");
        $data = $query->result_array();
        $descr = $data[0]['descr'];

        return $descr;
    }


    public function getBaseBarcode($name)
    {
        $query = $this->db->query("SELECT ItemNameTextField,Cost,Rate1,Rate2,Typ,CostRs FROM salesitem WHERE ItemC = '$name'");
        $data = $query->result_array();
        return $data;
    }

    public function getSecBarcode($name)
    {
        $query = $this->db->query("SELECT ItemNameTextField,SecCostRate,SecRetailRate,SecWholesaleRate,Pack,SecUnit,CostRs FROM salesitem WHERE SecBarcode = '$name'");
        $data = $query->result_array();
        return $data;
    }
    public function getThirdBarcode($name)
    {
        $query = $this->db->query("SELECT ItemNameTextField,ThirdCost,ThirdRate1,ThirdRate2,ThirdPack,ThirdUnit,CostRs FROM salesitem WHERE ThirdBarcode = '$name'");
        $data = $query->result_array();
        return $data;
    }

    public function storeTakeStockToPBill($invNO, $party, $netTotal, $billTime, $invDate, $totalQuantity, $local_app_user_entry_id, $godown, $pNetV, $tltTax, $TaxBillNo, $fin_year)
    {
        $query = $this->db->query("SELECT COUNT(*) AS cnt FROM " . super_model::$table_Pbill . " WHERE local_app_user_entry_id ='$local_app_user_entry_id'");
        if ($row = $query->result_array()) {
            if ($row[0]['cnt'] < 1) {
                $data2 = array(
                    'InvoiceNo' => $invNO,
                    'PartyName' => $party,
                    'Total' => $pNetV,
                    'BillTime' => $billTime,
                    'InvoiceDat' => $invDate,
                    'OrderNo' => '0',
                    'Lorry' => '',
                    'NTot' => $pNetV,
                    'TAmt' => $netTotal,
                    'godown' => $godown,
                    'TotItWiseQty' => $totalQuantity,
                    'careof' => 'NIL',
                    'SystemId' => 'SYS1',
                    'tax_mode' => 'CGST',
                    'local_app_user_entry_id' => $local_app_user_entry_id,
                    //'TItTaxAmt' => '0',
                    'TItTaxAmt' => $tltTax,
                    'TaxBillNo' => $TaxBillNo,
                    'fin_year' => $fin_year

                );
                $this->db->insert(super_model::$table_Pbill, $data2);
                $insert_id = $this->db->insert_id();
                if ($this->db->affected_rows() == 1) {
                    return TRUE;
                } else {
                    return FALSE;
                }
            } else {
                return FALSE;
            }
        } else {
            return FALSE;
        }
    }

    public function storeTakeStock($id, $itemname, $price, $qty, $unit, $itemcode, $pack, $cost, $MRP, $total, $PBDate, $EXDate, $local_app_user_entry_id, $employee, $pTaxP, $pTaxA, $pNetV, $si, $sold_qty, $BillNo2)
    {

        $si1 = $si + 1;
        $query = $this->db->query("SELECT COUNT(*) AS cnt FROM " . super_model::$table_purchase_bill . " WHERE local_app_user_entry_id ='$local_app_user_entry_id'");
        $query1 = $this->db->query("SELECT MAX(InvoiceNo) AS BillNo FROM " . super_model::$table_Pbill);
        if ($row1 = $query1->result_array()) {
            $invNO = $row1[0]['BillNo'];
        }
        if ($row = $query->result_array()) {
            if ($row[0]['cnt'] < 1) {
                $data2 = array(
                    'PSiNo' => $si1,
                    'PItem' => $itemname,
                    'PRate' => $cost,
                    'MRP' => $price,
                    'SRP' => $MRP,
                    'Pack' => $pack,
                    'Unit' => $unit,
                    'PQty' => $qty,
                    'sqft' => '07',
                    'ItemC' => $itemcode,
                    'PTotal' => $total,
                    // 'PBillNo' => $invNO,
                    'PBillNo' => $BillNo2,
                    'PBDate' => $PBDate,
                    'Ex_date' => $EXDate,
                    'PGoodsOn' => $employee,
                    'local_app_user_entry_id' => $local_app_user_entry_id,
                    'PTaxP' => $pTaxP,
                    'PTaxA' => $pTaxA,
                    'PNetV' => $pNetV,
                    'sold_qty' => $sold_qty
                );
                $this->db->insert(super_model::$table_purchase_bill, $data2);
                $insert_id = $this->db->insert_id();
                if ($this->db->affected_rows() == 1) {

                    return TRUE;
                } else {
                    return FALSE;
                }
            } else {
                return FALSE;
            }
        } else {
            return FALSE;
        }
    }


    public function SyncTakeStockPurchaseBill($id, $itemname, $price, $qty, $unit, $itemcode, $pack, $cost, $MRP, $total, $PBDate, $EXDate, $local_app_user_entry_id, $employee, $pTaxP, $pTaxA, $pNetV, $si, $sold_qty, $billno)
    {

        $si1 = $si + 1;
        $query = $this->db->query("SELECT COUNT(*) AS cnt FROM " . super_model::$table_purchase_bill . " WHERE local_app_user_entry_id ='$local_app_user_entry_id'");
        // $query1 = $this->db->query("SELECT MAX(InvoiceNo) AS BillNo FROM " . super_model::$table_Pbill);
        // if ($row1 = $query1->result_array()) {
        //     $invNO = $row1[0]['BillNo'];
        // }
        if ($row = $query->result_array()) {
            if ($row[0]['cnt'] < 1) {
                $data2 = array(
                    'PSiNo' => $si1,
                    'PItem' => $itemname,
                    'PRate' => $cost,
                    'MRP' => $price,
                    'SRP' => $MRP,
                    'Pack' => $pack,
                    'Unit' => $unit,
                    'PQty' => $qty,
                    'sqft' => '0',
                    'ItemC' => $itemcode,
                    'PTotal' => $total,
                    'PBillNo' => $billno,
                    'PBDate' => $PBDate,
                    'Ex_date' => $EXDate,
                    'PGoodsOn' => $employee,
                    'local_app_user_entry_id' => $local_app_user_entry_id,
                    'PTaxP' => $pTaxP,
                    'PTaxA' => $pTaxA,
                    'PNetV' => $pNetV,
                    'sold_qty' => $sold_qty
                );
                $this->db->insert(super_model::$table_purchase_bill, $data2);
                $insert_id = $this->db->insert_id();
                if ($this->db->affected_rows() == 1) {

                    return TRUE;
                } else {
                    return FALSE;
                }
            } else {
                return FALSE;
            }
        } else {
            return FALSE;
        }
    }



    public function saveTakeStockToCollection($date1, $party, $netTotal, $employee, $local_app_user_entry_id, $billTime, $TaxBillNo, $fin_year)
    {
        $query = $this->db->query("SELECT COUNT(*) AS cnt FROM " . super_model::$table_collection . " WHERE local_app_user_entry_id ='$local_app_user_entry_id'");
        $query1 = $this->db->query("SELECT MAX(InvoiceNo) AS BillNo FROM " . super_model::$table_Pbill);
        if ($row1 = $query1->result_array()) {
            $invNO = $row1[0]['BillNo'];
        }
        if ($row = $query->result_array()) {
            if ($row[0]['cnt'] < 1) {
                $data2 = array(
                    'BillNo' => $invNO,
                    'TransactionType' => 'ToCash',
                    'Date1' => $date1,
                    'PartyName' => $party,
                    'Amount' => $netTotal,
                    'Employee' => $employee,
                    'Typ' => 'PURCHASE PARTY',
                    'godown' => $employee,
                    'local_app_user_entry_id' => $local_app_user_entry_id,
                    'bill_time' => $billTime,
                    'BillForm' => 'PURCHASE BILL',
                    'Stat' => '1',
                    'TaxBillNo' => $TaxBillNo,
                    'fin_year' => $fin_year
                );
                $this->db->insert(super_model::$table_collection, $data2);
                $insert_id = $this->db->insert_id();
                if ($this->db->affected_rows() == 1) {
                    return TRUE;
                } else {
                    return FALSE;
                }
            } else {
                return FALSE;
            }
        } else {
            return FALSE;
        }
    }

    public function saveintrans($itemname, $qty, $rate, $total, $party, $net_qty, $net_amnt, $godown, $employee, $date1, $inv_no, $local_app_user_entry_id, $credit, $inv_no_str, $type)
    {
        $data2 = array(
            'itemname' => $itemname,
            'qty' => $qty,
            'rate' => $rate,
            'total' => $total,
            'party' => $party,
            'net_qty' => $net_qty,
            'net_amnt' => $net_amnt,
            'godown' => $godown,
            'employee' => $employee,
            'date1' => $date1,
            'inv_no' => $inv_no,
            'local_app_user_entry_id' => $local_app_user_entry_id,
            'credit' => $credit,
            'inv_no_str' => $inv_no_str,
            'typ' => $type
        );
        $this->db->insert(super_model::$table_intrans, $data2);
        $insert_id = $this->db->insert_id();
    }
    public function saveCategory($itemname)
    {
        $data2 = array(
            'Typ' => $itemname,
            'Description' => 'PRODUCT GROUP',
        );
        $this->db->insert(super_model::$table_other, $data2);
        $insert_id = $this->db->insert_id();
    }

    public function updateCategory($itemname, $oldName)
    {
        $data['Typ'] = $itemname;
        $this->db->where('Typ', $oldName);
        $this->db->where('Description', 'PRODUCT GROUP');
        $this->db->update(super_model::$table_other, $data);
    }

    public function getCategory()
    {
        $query = $this->db->query("SELECT DISTINCT Typ AS categoryName FROM other WHERE DESCRIPTION = 'PRODUCT GROUP' ");
        $data = $query->result_array();
        return $data;
    }

    public function priceChart($val1, $val2, $val3)
    {
        $data = array(
            'Typ' => '1-49',
            'Description' => $val1
        );
        $data2 = array(
            'Typ' => '50-74',
            'Description' => $val2
        );
        $data3 = array(
            'Typ' => '75-above',
            'Description' => $val3
        );
        $this->db->replace(super_model::$table_other, $data);
        $this->db->replace(super_model::$table_other, $data2);
        $this->db->replace(super_model::$table_other, $data3);
        if ($this->db->affected_rows() == 1) {
            return TRUE;
        } else {
            return FALSE;
        }
    }

    public function getPriceOneToFiftynine()
    {
        $query = $this->db->query("SELECT Description AS desc1 FROM " . super_model::$table_other . " Where Typ = '1-49'");
        if ($query->num_rows() > 0) {
            if ($row = $query->result_array()) {
                return $row[0]["desc1"];
            } else {
                return false;
            }
        }
    }

    public function getPriceFiftyToSevenFour()
    {
        $query = $this->db->query("SELECT Description AS desc2 FROM " . super_model::$table_other . " Where Typ = '50-74'");
        if ($query->num_rows() > 0) {
            if ($row = $query->result_array()) {
                return $row[0]["desc2"];
            } else {
                return false;
            }
        }
    }
    public function getPriceSevenficeAbove()
    {
        $query = $this->db->query("SELECT Description AS desc3 FROM " . super_model::$table_other . " Where Typ = '75-above'");
        if ($query->num_rows() > 0) {
            if ($row = $query->result_array()) {
                return $row[0]["desc3"];
            } else {
                return false;
            }
        }
    }

    public function beginTransaction()
    {
        $this->db->trans_begin();
    }

    public function commit()
    {
        $this->db->trans_commit();
    }

    public function rollBack()
    {
        $this->db->trans_rollback();
    }


    public function getothertableData()
    {
        $query = $this->db->query(" SELECT Typ FROM Other WHERE Description ='CREDIT_LIMIT_DROID'");
        $data = $query->result_array();
        if (empty($data)) {
            $data[0]['Typ'] = "NO_CRD";
            $data[0]['Description'] = "CREDIT_LIMIT_DROID";
        }
        return $data;
    }

    public function Item_Report($date1, $date2, $empName)
    {
        $query = $this->db->query("SELECT BillNo,SBDate,Item,Qty,Rate,Qty * Rate AS Total FROM SalesBill WHERE SBDate BETWEEN '$date1' AND '$date2' AND  GoodsOn = '$empName' ORDER BY BillNo ASC ");
        $data = $query->result_array();
        return $data;
    }

    public function Item_wise_Data($date1, $date2, $item, $empName)
    {
        $query = $this->db->query("SELECT BillNo,SBDate,Item,Qty,Rate,Qty * Rate AS Total FROM SalesBill WHERE SBDate BETWEEN '$date1' AND '$date2' AND Item = '$item' AND  GoodsOn = '$empName'  ORDER BY BillNo ASC ");
        $data = $query->result_array();
        return $data;
    }



    // public function storeHold($data)
    // {
    //     foreach ($data as $index => $item) {
    //         // Prepare data for each item
    //         $party = $item['party'];
    //         $itemName = $item['itemname'];
    //         $qty = $item['qty'];
    //         $unit = $item['unit'];
    //         $employee = $item['employee'];
    //         $upload_status = $item['upload_status'];
    //         $serial_no = $item['serial_no'];
    //         $date1 = $item['date1'];
    //         $bill_qty = $item['bill_qty'];
    //         $bill_totItems = $item['bill_totItems'];

    //         // Fetch the current qty for the given party and item
    //         $currentQtyQuery = $this->db->query("SELECT qty, date1 FROM hold_master_tbl WHERE party = '$party' AND item = '$itemName'");
    //         $currentQtyData = $currentQtyQuery->row();

    //         // If current qty does not exist, insert the new data
    //         if (!$currentQtyData) {
    //             $this->db->query("
    //             INSERT INTO hold_master_tbl (party, item, qty, unit, slno, emp, date1, bill_tot, items_tot)
    //             VALUES 
    //                 ('$party', '$itemName', '$qty', '$unit', '$serial_no', '$employee', '$date1', '$bill_qty', '$bill_totItems')
    //         ");
    //         } else {
    //             // If qty has changed, update the date1
    //             if ($currentQtyData->qty != $qty) {
    //                 $this->db->query("
    //                 INSERT INTO hold_master_tbl (party, item, qty, unit, slno, emp, date1, bill_tot, items_tot)
    //                 VALUES 
    //                     ('$party', '$itemName', '$qty', '$unit', '$serial_no', '$employee', '$date1', '$bill_qty', '$bill_totItems')
    //                 ON DUPLICATE KEY UPDATE 
    //                     qty = VALUES(qty), 
    //                     slno = VALUES(slno),
    //                     emp = VALUES(emp),
    //                     bill_tot = VALUES(bill_tot),
    //                     items_tot = VALUES(items_tot),
    //                     date1 = VALUES(date1)  -- Update date1 only if qty has changed
    //             ");
    //             } else {
    //                 // If qty hasn't changed, keep the old date1
    //                 $this->db->query("
    //                 INSERT INTO hold_master_tbl (party, item, qty, unit, slno, emp, date1, bill_tot, items_tot)
    //                 VALUES 
    //                     ('$party', '$itemName', '$qty', '$unit', '$serial_no', '$employee', '$date1', '$bill_qty', '$bill_totItems')
    //                 ON DUPLICATE KEY UPDATE 
    //                     qty = VALUES(qty), 
    //                     slno = VALUES(slno),
    //                     emp = VALUES(emp),
    //                     bill_tot = VALUES(bill_tot),
    //                     items_tot = VALUES(items_tot),
    //                     date1 = '$currentQtyData->date1'  -- Keep the old date1 if qty is the same
    //             ");
    //             }
    //         }
    //     }

    //     if ($this->db->affected_rows() > 0) {
    //         return TRUE;
    //     } else {
    //         return FALSE;
    //     }
    // }



    // public function storeHold($data)
// {
//     try {
//         foreach ($data as $index => $item) {
//             // Prepare data for each item
//             $party = $item['party'];
//             $itemName = $item['itemname'];
//             $qty = $item['qty'];
//             $unit = $item['unit'];
//             $employee = $item['employee'];
//             $upload_status = $item['upload_status'];
//             $serial_no = $item['serial_no'];
//             $date1 = $item['date1'];
//             $bill_qty = $item['bill_qty'];
//             $bill_totItems = $item['bill_totItems'];

    //             // Fetch the current qty for the given party and item
//             $currentQtyQuery = $this->db->query("
//                 SELECT qty, date1 
//                 FROM hold_master_tbl 
//                 WHERE party = '$party' AND item = '$itemName'
//             ");
//             $currentQtyData = $currentQtyQuery->row();

    //             if (!$currentQtyData) {
//                 // Insert if no record exists
//                 $this->db->query("
//                     INSERT INTO hold_master_tbl 
//                         (party, item, qty, unit, slno, emp, date1, bill_tot, items_tot)
//                     VALUES 
//                         ('$party', '$itemName', '$qty', '$unit', '$serial_no', '$employee', '$date1', '$bill_qty', '$bill_totItems')
//                 ");
//             } else {
//                 // If qty has changed, update date1
//                 if ($currentQtyData->qty != $qty) {
//                     $this->db->query("
//                         INSERT INTO hold_master_tbl 
//                             (party, item, qty, unit, slno, emp, date1, bill_tot, items_tot)
//                         VALUES 
//                             ('$party', '$itemName', '$qty', '$unit', '$serial_no', '$employee', '$date1', '$bill_qty', '$bill_totItems')
//                         ON DUPLICATE KEY UPDATE 
//                             qty = VALUES(qty), 
//                             slno = VALUES(slno),
//                             emp = VALUES(emp),
//                             bill_tot = VALUES(bill_tot),
//                             items_tot = VALUES(items_tot),
//                             date1 = VALUES(date1)
//                     ");
//                 } else {
//                     // If qty is same, keep old date1
//                     $this->db->query("
//                         INSERT INTO hold_master_tbl 
//                             (party, item, qty, unit, slno, emp, date1, bill_tot, items_tot)
//                         VALUES 
//                             ('$party', '$itemName', '$qty', '$unit', '$serial_no', '$employee', '$date1', '$bill_qty', '$bill_totItems')
//                         ON DUPLICATE KEY UPDATE 
//                             qty = VALUES(qty), 
//                             slno = VALUES(slno),
//                             emp = VALUES(emp),
//                             bill_tot = VALUES(bill_tot),
//                             items_tot = VALUES(items_tot),
//                             date1 = '$currentQtyData->date1'
//                     ");
//                 }
//             }
//         }

    //         if ($this->db->affected_rows() > 0) {
//             return json_encode([
//                 "success" => 1,
//                 "message" => "Hold items stored successfully"
//             ]);
//         } else {
//             throw new Exception("No rows affected. Possibly duplicate data or no changes.");
//         }

    //     } catch (Exception $e) {
//         // Catch PHP or manual exceptions
//         return json_encode([
//             "success" => 0,
//             "message" => "Error in storing hold items: " . $e->getMessage()
//         ]);
//     } catch (Throwable $t) {
//         // Catch PHP 7+ fatal errors
//         return json_encode([
//             "success" => 0,
//             "message" => "Unexpected Error: " . $t->getMessage()
//         ]);
//     }
// }


    // public function storeHold($data)
    // {
    //     try {
    //         foreach ($data as $index => $item) {
    //             // Prepare data for each item
    //             $party = $item['party'];
    //             $itemName = $item['itemname'];
    //             $qty = $item['qty'];
    //             $unit = $item['unit'];
    //             $employee = $item['employee'];
    //             $upload_status = $item['upload_status'];
    //             $serial_no = $item['serial_no'];
    //             $date1 = $item['date1'];
    //             $bill_qty = $item['bill_qty'];
    //             $bill_totItems = $item['bill_totItems'];

    //             // Fetch the current qty and date1 for the given party and item
    //             $currentDataQuery = $this->db->query("
    //             SELECT qty, date1 
    //             FROM hold_master_tbl 
    //             WHERE party = '$party' AND item = '$itemName' AND emp = '$employee'
    //         ");
    //             $currentData = $currentDataQuery->row();

    //             if (!$currentData) {
    //                 // No record exists → Insert
    //                 $this->db->query("
    //                 INSERT INTO hold_master_tbl 
    //                     (party, item, qty, unit, slno, emp, date1, bill_tot, items_tot)
    //                 VALUES 
    //                     ('$party', '$itemName', '$qty', '$unit', '$serial_no', '$employee', '$date1', '$bill_qty', '$bill_totItems')
    //             ");
    //             } else {
    //                 // Record exists → check changes
    //                 if ($currentData->qty != $qty || $currentData->date1 != $date1) {
    //                     // 👉 Either Qty or Date changed → update
    //                     //  echo "Party: $party | Old Qty: {$currentData->qty}, New Qty: $qty | Old Date: {$currentData->date1}, New Date: $date1<br>";

    //                     $this->db->query("
    //                  UPDATE hold_master_tbl 
    //                   SET qty = '$qty',
    //                  unit = '$unit',
    //                  slno = '$serial_no',
    //                  emp = '$employee',
    //                 bill_tot = '$bill_qty',
    //                  items_tot = '$bill_totItems',
    //                   date1 = '$date1'
    //                  WHERE party = '$party' AND item = '$itemName' AND emp = '$employee'
    //              ");
    //                 }
    //             }
    //         }

    //         if ($this->db->affected_rows() > 0) {
    //             return json_encode([
    //                 "success" => 1,
    //                 "message" => "Hold items stored successfully"
    //             ]);
    //         } else {
    //             return json_encode([
    //                 "success" => 0,
    //                 "message" => "No rows updated. Data already same."
    //             ]);
    //         }

    //     } catch (Exception $e) {
    //         return json_encode([
    //             "success" => 0,
    //             "message" => "Error in storing hold items: " . $e->getMessage()
    //         ]);
    //     } catch (Throwable $t) {
    //         return json_encode([
    //             "success" => 0,
    //             "message" => "Unexpected Error: " . $t->getMessage()
    //         ]);
    //     }
    // }


    public function storeHold($data)
    {
        try {
            foreach ($data as $index => $item) {
                // Prepare data for each item
                $party = $item['party'];
                $itemName = $item['itemname'];
                $qty = $item['qty'];
                $unit = $item['unit'];
                $employee = $item['employee'];
                $serial_no = $item['serial_no'];
                $date1 = $item['date1'];
                $bill_qty = $item['bill_qty'];
                $bill_totItems = $item['bill_totItems'];

                // ✅ First check if party + item exists
                $existsQuery = $this->db->query("
                SELECT 1 
                FROM hold_master_tbl 
                WHERE party = '$party' AND item = '$itemName'
                LIMIT 1
            ");
                $exists = $existsQuery->num_rows() > 0; // true if record found

                if ($exists) {
                    //  echo "aaaaaaaaaaaaaaaa";
                    // 🚀 Record exists → UPDATE
                    $this->db->query("
                    UPDATE hold_master_tbl 
                    SET qty = '$qty',
                        unit = '$unit',
                        slno = '$serial_no',
                        emp = '$employee',
                        bill_tot = '$bill_qty',
                        items_tot = '$bill_totItems',
                        date1 = '$date1'
                    WHERE party = '$party' AND item = '$itemName' 
                ");
                } else {
                    // 🚀 Record does not exist → INSERT
                    // echo "bbbbbbb";

                    $this->db->query("
                    INSERT INTO hold_master_tbl 
                        (party, item, qty, unit, slno, emp, date1, bill_tot, items_tot)
                    VALUES 
                        ('$party', '$itemName', '$qty', '$unit', '$serial_no', '$employee', '$date1', '$bill_qty', '$bill_totItems')
                ");
                }
            }

            if ($this->db->affected_rows() > 0) {
                return json_encode([
                    "success" => 1,
                    "message" => "Hold items stored successfully"
                ]);
            } else {
                return json_encode([
                    "success" => 0,
                    "message" => "No rows updated. Data already same."
                ]);
            }

        } catch (Exception $e) {
            return json_encode([
                "success" => 0,
                "message" => "Error in storing hold items: " . $e->getMessage()
            ]);
        } catch (Throwable $t) {
            return json_encode([
                "success" => 0,
                "message" => "Unexpected Error: " . $t->getMessage()
            ]);
        }
    }



    public function getholditems()
    {
        $data = array();
        $query1 = $this->db->query("SELECT party,item,qty,unit,slno,emp,date1,bill_tot,items_tot FROM hold_master_tbl ORDER BY party ASC ");
        $data = $query1->result_array();
        return $data;
    }

    public function SalesData($billNumber, $bill_typ, $empName)
    {
        $query = $this->db->query("SELECT Item,Qty FROM SalesBill WHERE BillNo = '$billNumber' AND BillTyp = '$bill_typ' AND GoodsOn = '$empName' ORDER BY Item ASC ");
        $data = $query->result_array();
        return $data;
    }

    public function getProductsGodown($username)
    {
        $data = array();
        $query = $this->db->query(" SELECT ItemNameTextField,ItemC,Cost,SecCostRate,curr_stock,Rate1,SecRetailRate,Typ,SecUnit,Size,Tax1,Rate1,Rate2,SecRetailRate,SecRate2,
        RatePerInch,Pack,Company,ArabicName,ThirdUnit,ThirdCost,ThirdRate1,ThirdRate2,ThirdPack,NewItemCode,SecBarcode,ThirdBarcode,CostRs FROM 
        SalesItem ST INNER JOIN godown_wise_stock  GW ON ST.ItemNameTextField = GW.Item
        WHERE GW.godown = '$username' ");
        $data = $query->result_array();
        return $data;
    }


    public function getPRT_RetNo()
    {
        $query = $this->db->query("SELECT MAX(RetNo+1) AS retNo FROM " . super_model::$table_pr_rmasterdetails);
        if ($query->num_rows() > 0) {
            if ($row = $query->result_array()) {
                if ($row[0]["retNo"] == "Null" || $row[0]["retNo"] == null || $row[0]["retNo"] == 0) {
                    return $row[0]["retNo"] = 1;
                } else {
                    return $row[0]["retNo"];
                }
            } else {
                return false;
            }
        }
    }

    public function deleteFromPRT_MasterDetailsByRetNo($luserEntryID, $retNo)
    {
        $this->db->where('local_app_user_entry_id', $luserEntryID);
        $this->db->where('RetNo!=', $retNo);
        $this->db->delete(super_model::$table_pr_rmasterdetails);
    }

    public function deleteFromCollectionByPrRetNo($luserEntryID, $retNo)
    {
        $this->db->where('local_app_user_entry_id', $luserEntryID);
        $this->db->where('BillNo!=', $retNo);
        $this->db->delete(super_model::$table_collection); //NOT USED
    }

    public function storePurcase_RetunCollection($RetNo, $dates, $BillPartyName, $BillTotalField, $BillNetTotalField, $Employee, $godown, $local_app_user_entry_id, $TaxAmt)
    {
        if ($this->db->query("DELETE FROM " . super_model::$table_collection . " WHERE local_app_user_entry_id='$local_app_user_entry_id' ")) {
            $data = array(
                'BillNo' => $RetNo,
                'TransactionType' => 'ToPurchaseReturn',
                'Date1' => $dates,
                'PartyName' => $BillPartyName,
                'NetTotal' => $BillNetTotalField,
                'Employee' => $Employee,
                'Typ' => 'PURCHASE PARTY',
                'godown' => $Employee,
                'local_app_user_entry_id' => $local_app_user_entry_id
            );
            $this->db->insert(super_model::$table_collection, $data);
            $insert_id = $this->db->insert_id();
            return $insert_id;
        } else {
            $data = array(
                'BillNo' => $OrderLines,
                'TransactionType' => 'ToPurchaseReturn',
                'Date1' => $dates,
                'PartyName' => $BillPartyName,
                'NetTotal' => $BillNetTotalField,
                'Employee' => $Employee,
                'Typ' => 'PURCHASE PARTY',
                'godown' => $Employee,
                'local_app_user_entry_id' => $local_app_user_entry_id
            );
            $this->db->insert(super_model::$table_collection, $data);
            $insert_id = $this->db->insert_id();
            if ($this->db->affected_rows() == 1) {
                return TRUE;
            } else {
                return FALSE;
            }
        }
    }

    public function storePurchaseReturn_COLLECTION($retNo, $dates, $BillPartyName, $BillNetTotalField, $Employee, $local_app_user_entry_id)
    {
        // Optional: Uncomment and ensure the DELETE query is safe
        // $this->db->query("DELETE FROM " . super_model::$table_collection . " WHERE local_app_user_entry_id=?", [$local_app_user_entry_id]);

        $data = array(
            'BillNo' => $retNo, // Corrected variable name
            'TransactionType' => 'ToPurchaseReturn', // Consider making this dynamic or a constant
            'Date1' => $dates,
            'PartyName' => $BillPartyName,
            'NetTotal' => $BillNetTotalField,
            'Employee' => $Employee,
            'Typ' => 'PURCHASE PARTY', // Consider making this dynamic or a constant
            'godown' => $Employee, // Ensure this is intentional
            'local_app_user_entry_id' => $local_app_user_entry_id
        );

        if ($this->db->insert(super_model::$table_collection, $data)) {
            return $this->db->insert_id(); // Return the insert ID on success
        } else {
            // Handle failure case
            return false;
        }
    }


    public function getUpdateQueryPRT_MasterDetails($BillNo, $BillDate, $BillPartyName, $BillTotalField, $BillDiscAmtField, $BillDiscPercField, $BillTaxField, $BillPackageField, $BillNetTotalField, $BillTyp, $TaxAmt, $Lorry, $godown, $local_app_user_entry_id, $netQty)
    {

        $data['BillDate'] = $BillDate;
        $data['BillPartyName'] = $BillPartyName;
        $data['BillTotalField'] = $BillTotalField;
        $data['BillDiscAmtField'] = $BillDiscAmtField;
        $data['BillDiscPercField'] = $BillDiscPercField;
        $data['BillTaxField'] = $BillTaxField;
        $data['BillPackageField'] = $BillPackageField;
        $data['BillNetTotalField'] = $BillNetTotalField;
        $data['BillTyp'] = $BillTyp;
        //        $data['BillTime'] = $BillTime;
        // $data['TDiscAmt'] = $TDiscAmt;
        $data['TaxAmt'] = $TaxAmt;

        //        $data['del_date'] = $del_date;
        $data['local_app_user_entry_id'] = $local_app_user_entry_id;


        // $this->db->where('Employee', $Lorry);
        $this->db->where('RetNo', $BillNo);
        $this->db->update(super_model::$table_pr_rmasterdetails, $data);
        if ($this->db->affected_rows() == 1) {
            return TRUE;
        } else {
            return FALSE;
        }
    }

    public function storePurchaseRetun($itemName, $price, $qty, $unit, $party, $godown, $employee, $date1, $invno, $local_app_user_entry_id, $retNo, $index, $taxAmt, $taxPerc, $itemC, $qty_in_pack)
    {
        if ($this->db->query("DELETE FROM " . super_model::$table_purchase_return . " WHERE local_app_user_entry_id='$local_app_user_entry_id' AND  RetNo != '$retNo' AND local_app_user_entry_id IS NOT NULL ")) {
            $total = $price * $qty;
            $netV = $total + $taxAmt;
            $data = array(
                'SiNo' => $index,
                'ItemC' => $itemC,
                'Item' => $itemName,
                'Qty' => $qty,
                'Rate' => $price,
                'Tot' => $total,
                'TaxP' => $taxPerc,
                'TaxA' => $taxAmt,
                'Total' => $netV,
                'RetNo' => $retNo,
                'SBDate' => $date1,
                'Stat' => '0',
                'godown' => $employee,
                'Pack' => $qty_in_pack,
                'Unit' => $unit,
                'local_app_user_entry_id' => $local_app_user_entry_id

            );
            $this->db->insert(super_model::$table_purchase_return, $data);
            $insert_id = $this->db->insert_id();
            if ($this->db->affected_rows() == 1) {
                return TRUE;
            } else {
                return FALSE;
            }
        }
    }

    // Alternative Rec

    public function checkExistingRecordDebit($lip_id, $CashFlow)
    {
        $this->db->select('SiNo');
        $this->db->where('local_app_user_entry_id', $lip_id);
        $this->db->where('CashFlow', $CashFlow);
        $query = $this->db->get('Collection');

        return $query->row_array(); // Return row if exists, else null
    }

    public function checkExistingRecordCredit($lip_id)
    {
        $this->db->select('SiNo');
        $this->db->where('local_app_user_entry_id', $lip_id);
        $this->db->where('CashFlow', 'CREDIT');
        $query = $this->db->get('Collection');

        return $query->row_array(); // Return row if exists, else null
    }

    public function deleteSinoDebitCollection($lip_id, $sino)
    {
        $this->db->where('local_app_user_entry_id', $lip_id);
        $this->db->where('SiNo', $sino);
        $this->db->where('CashFlow', 'DEBIT'); // Add this line
        $this->db->where('local_app_user_entry_id IS NOT NULL', null, false); // raw SQL
        $this->db->delete('Collection');

        return $this->db->affected_rows();
    }

    public function deleteSinoCreditCollection($lip_id, $sino)
    {
        $this->db->where('local_app_user_entry_id', $lip_id);
        $this->db->where('SiNo', $sino);
        $this->db->where('CashFlow', 'CREDIT'); // Add this line
        $this->db->where('local_app_user_entry_id IS NOT NULL', null, false); // raw SQL
        $this->db->delete('Collection');

        return $this->db->affected_rows();
    }


    // public function deleteSinoDebitCollection($lip_id, $sino) {
    //     $this->db->where('local_app_user_entry_id', $lip_id);
    //     $this->db->where('SiNo', $sino);
    //     $this->db->delete('Collection');

    //     return $this->db->affected_rows();
    // }

    public function insertDebit($tableName, $dbData)
    {
        if (isset($dbData['upload_status'])) {
            unset($dbData['upload_status']); // Remove upload_status if exists
        }

        $this->db->insert($tableName, $dbData);

        return $this->db->affected_rows();
    }

    //pnlreport


    public function setpnlrpt($date1, $date2, $empName)
    {
        $query = $this->db->query("SELECT 
    (SELECT COALESCE(SUM(Qty * Cst), 0) FROM SalesBill 
        WHERE SBDate BETWEEN '$date1' AND '$date2' 
        AND GoodsOn = '$empName') AS total_SB,

    (SELECT COALESCE(SUM(Qty * sqft), 0) FROM SalesReturn 
        WHERE SBDate BETWEEN '$date1' AND '$date2' 
        AND godown = '$empName') AS total_SR,

    (SELECT COALESCE(SUM(NetTotal), 0) - COALESCE(SUM(Amount), 0) FROM Collection 
        WHERE Typ = 'EXPENSE' 
        AND Date1 BETWEEN '$date1' AND '$date2' 
        AND godown = '$empName') AS EXP,

     (SELECT COALESCE(SUM(Amount), 0) - COALESCE(SUM(NetTotal), 0) FROM Collection 
        WHERE Typ = 'INCOME' 
        AND Date1 BETWEEN '$date1' AND '$date2' 
        AND godown = '$empName') AS INCOME,

    (SELECT COALESCE(SUM(BillNetTotalField), 0) FROM MasterDetails 
        WHERE BillDate BETWEEN '$date1' AND '$date2' 
        AND godown = '$empName') AS total_master,

    (SELECT COALESCE(SUM(BillNetTotalField), 0) FROM MasterDetails8BNew 
        WHERE BillDate BETWEEN '$date1' AND '$date2' 
        AND godown = '$empName') AS total_masterb2c,

    (SELECT COALESCE(SUM(BillNetTotalField), 0) FROM SRMasterDetails 
        WHERE BillDate BETWEEN '$date1' AND '$date2' 
        AND Employee = '$empName') AS total_srmaster,

    (SELECT COALESCE(SUM(BillDiscAmtField), 0) FROM MasterDetails 
        WHERE BillDate BETWEEN '$date1' AND '$date2' 
        AND godown = '$empName') AS total_discount,

           (SELECT COALESCE(SUM(BillDiscAmtField), 0) FROM MasterDetails8BNew 
        WHERE BillDate BETWEEN '$date1' AND '$date2' 
        AND godown = '$empName') AS total_discountb2c;
");
        $data = $query->result_array();
        return $data;
    }

    public function storecompany($data)
    {
        // Delete existing row based on NAME (or another unique identifier)
        $delete_sql = "DELETE FROM Company";
        $this->db->query($delete_sql);

        // Insert new row
        $insert_sql = "INSERT INTO Company (NAME, Place, Add1, Add2, company_details, EMail, identific_no, city_name, post_code, Web, Country) 
                       VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

        $this->db->query($insert_sql, [
            $data['NAME'],
            $data['Place'],
            $data['Add1'],
            $data['Add2'],
            $data['company_details'],
            $data['EMail'],
            $data['identific_no'],
            $data['city_name'],
            $data['post_code'],
            $data['Web'],
            "CRN" // Corrected Country value
        ]);

        return $this->db->affected_rows(); // Return number of affected rows
    }


    // public function storeprevillage($data)
    // {
    //     $apk_user = $data['apk_user'];

    //     // Check if the apk_user exists in the table
    //     $this->db->where('apk_user', $apk_user);
    //     $query = $this->db->get('userprevillage_apk');

    //     if ($query->num_rows() > 0) {
    //         // apk_user exists, perform an UPDATE
    //         $this->db->where('apk_user', $apk_user);
    //         $this->db->update('userprevillage_apk', $data);

    //         $response = ["status" => "success", "message" => "Record updated successfully"];
    //     } else {
    //         // apk_user does not exist, perform an INSERT with apk_sync_stat = 1
    //         $data['apk_sync_stat'] = 1;  // Hardcoded value
    //         $this->db->insert('userprevillage_apk', $data);

    //         if ($this->db->affected_rows() > 0) {
    //             $response = ["status" => "success", "message" => "Record inserted successfully"];
    //         } else {
    //             $response = ["status" => "error", "message" => "Failed to insert record"];
    //         }
    //     }

    //     // Print the response
    //     //  print_r($response);

    //     return $response;
    // }


    public function storeprevillage($data)
    {
        $apk_user = $data['apk_user'];

        // Loop through $data and encode arrays to JSON
        foreach ($data as $key => $value) {
            if (is_array($value)) {
                //  Convert associative arrays to JSON strings
                $data[$key] = json_encode($value);
            }
        }

        // Check if apk_user exists
        $this->db->where('apk_user', $apk_user);
        $query = $this->db->get('userprevillage_apk');

        if ($query->num_rows() > 0) {
            // Update existing row
            $this->db->where('apk_user', $apk_user);
            $this->db->update('userprevillage_apk', $data);
            $response = ["status" => "success", "message" => "Record updated successfully"];
        } else {
            // Insert new row
            $data['apk_sync_stat'] = 1;
            $this->db->insert('userprevillage_apk', $data);
            if ($this->db->affected_rows() > 0) {
                $response = ["status" => "success", "message" => "Record inserted successfully"];
            } else {
                $response = ["status" => "error", "message" => "Failed to insert record"];
            }
        }

        return $response;
    }


    public function getUserAccess_apk($username)
    {
        $this->db->select('*');
        $this->db->where('apk_user', $username);
        $this->db->from(super_model::$table_userprevillage_apk);
        $query = $this->db->get();
        $data = $query->result_array();
        return $data;
    }

    //getstatus_table

    public function get_status_table_Data()
    {
        $query = $this->db->query("
        SELECT params AS param, VALUE AS config_val 
        FROM " . super_model::$table_status_table . " 
        WHERE (
            params = 'SALESBILL_DECLARATION' OR 
            params = 'CURRENCY_SHORTNAME1' OR 
            params LIKE 'bill_Wise_Tax%' OR 
            params = 'RATE_FONTSIZE_APK' OR 
            params = 'INVOICE_PREFIX'OR
            params  = 'EXPENSE_TAX%_APK'OR
            params  = 'WEB_LINK_APK' OR
            params  = 'ITEM_WISE_TAX'
        ) 
        AND typ = 'CONFIG'
    ");

        $result = $query->result_array();

        // Initialize default values
        $output = array(
            "CURRENCY_SHORTNAME1" => "",
            "SALESBILL_DECLARATION" => "",
            "RATE_FONTSIZE_APK" => "",
            "INVOICE_PREFIX" => ""
            // Optional: you can add a placeholder key for bill_Wise_Tax entries if needed
        );

        // Map DB results into output
        foreach ($result as $row) {
            $output[$row['param']] = $row['config_val'];
        }

        return array("data" => $output);
    }


    //B2C

    public function getB2CBillNo()
    {
        $query = $this->db->query("SELECT MAX(BillNo+1) AS BillNo FROM " . super_model::$table_master_details8Bnew);
        if ($query->num_rows() > 0) {
            if ($row = $query->result_array()) {
                return $row[0]["BillNo"];
            } else {
                return false;
            }
        }
    }

    public function getFinYearB2C()
    {
        $query = $this->db->query("SELECT fin_year FROM MasterDetails8BNew ORDER BY BillNo DESC LIMIT 1");
        if ($query->num_rows() > 0) {
            if ($row = $query->result_array()) {
                return $row[0]["fin_year"];
            } else {
                return false;
            }
        }
    }




    public function deleteFromMasterDetails8BNEWByBillNo($luserEntryID, $billNo)
    {
        $this->db->where('local_app_user_entry_id', $luserEntryID);
        $this->db->where('BillNo!=', $billNo);
        $this->db->delete(super_model::$table_master_details8Bnew);
    }


    public function deletezatca_master($luserEntryID, $billNo)
    {
        $this->db->where('local_app_user_entry_id', $luserEntryID);
        $this->db->where('bill_no!=', $billNo);
        $this->db->delete(super_model::$zatca_einv_stat);
    }

    //


    public function storeUserB2B($itemName, $price, $qty, $unit, $party, $godown, $employee, $date1, $invno, $local_app_user_entry_id, $billNo, $index, $taxAmt, $taxPerc, $itemC, $qty_in_pack, $cost, $disc, $sqft, $taxtyp, $netV)
    {
        // Calculate total
        // $total = ($price - $disc) * $qty;

        $total = ($price * $qty) - $disc;

        // // If tax is EXCLUDE, add it to the total
        // if ($taxtyp == "EXCLUDE") {
        //     $netV = $total + $taxAmt;
        // } else { // Tax is already included in price
        //     $netV = $total;
        // }

        // Prepare data for insertion
        $data = array(
            'SiNo' => $index,
            'ItemC' => $itemC,
            'Item' => $itemName,
            'Qty' => $qty,
            'sqft' => $sqft,
            'Rate' => $price,
            'ItWiseDisAmt' => '0',
            'Dis' => $disc,
            'Total' => $total,
            'NetV' => $netV,
            'GoodsOn' => $employee,
            'BillNo' => $billNo,
            'SBDate' => $date1,
            'Cst' => $cost,
            'BillTyp' => '8',
            'Stat' => '0',
            'local_app_user_entry_id' => $local_app_user_entry_id,
            'local_app_invoice_id' => $invno,
            'TaxP' => $taxPerc,
            'TaxA' => $taxAmt,
            'Unit' => $unit,
            'Pack' => $qty_in_pack
        );

        // Insert into DB
        $this->db->insert(super_model::$table_sales_bill, $data);
        $insert_id = $this->db->insert_id();

        if ($this->db->affected_rows() == 1) {
            return TRUE;
        } else {
            return FALSE;
        }
    }


    public function storeUserB2C($itemName, $price, $qty, $unit, $party, $godown, $employee, $date1, $invno, $local_app_user_entry_id, $billNo, $index, $taxAmt, $taxPerc, $itemC, $qty_in_pack, $cost, $disc, $sqft, $taxtyp, $netV)
    {
        // Calculate total
        //$total = ($price - $disc) * $qty;

        $total = ($price * $qty) - $disc;

        // If tax is EXCLUDE, add it to the total
        // if ($taxtyp == "EXCLUDE") {
        //     $netV = $total + $taxAmt;
        // } else { // Tax is already included in price
        //     $netV = $total;
        // }

        $data = array(
            'SiNo' => $index,
            'ItemC' => $itemC,
            'Item' => $itemName,
            'Qty' => $qty,
            'sqft' => $sqft,
            'Rate' => $price,
            'ItWiseDisAmt' => '0',
            'Dis' => $disc,
            'Total' => $total,
            'NetV' => $netV,
            'GoodsOn' => $employee,
            'BillNo' => $billNo,
            'SBDate' => $date1,
            'Cst' => $cost,
            'BillTyp' => '8BNEW',
            'Stat' => '0',
            'local_app_user_entry_id' => $local_app_user_entry_id,
            'local_app_invoice_id' => $invno,
            'TaxP' => $taxPerc,
            'TaxA' => $taxAmt,
            'Unit' => $unit,
            'Pack' => $qty_in_pack
        );


        // Insert into DB
        $this->db->insert(super_model::$table_sales_bill, $data);
        $insert_id = $this->db->insert_id();

        if ($this->db->affected_rows() == 1) {
            return TRUE;
        } else {
            return FALSE;
        }
    }

    public function getMax_SiNoZtca()
    {
        $query = $this->db->query("SELECT MAX(sino+1) AS sino FROM " . super_model::$zatca_einv_stat);
        if ($query->num_rows() > 0) {
            if ($row = $query->result_array()) {
                return $row[0]["sino"];
            } else {
                return false;
            }
        }
    }

    public function getFinYearSRT()
    {
        $query = $this->db->query("SELECT fin_year FROM SRMasterDetails ORDER BY RetNo DESC LIMIT 1");
        if ($query->num_rows() > 0) {
            if ($row = $query->result_array()) {
                return $row[0]["fin_year"];
            } else {
                return false;
            }
        }
    }



    public function SaveSalesReturnBills($itemName, $price, $qty, $unit, $party, $godown, $employee, $date1, $invno, $local_app_user_entry_id, $retNo, $index, $taxAmt, $taxPerc, $itemC, $qty_in_pack, $cost, $disc, $taxtyp)
    {
        // Calculate total
        $total = ($price - $disc) * $qty;

        // If tax is EXCLUDE, add it to the total
        if ($taxtyp == "EXCLUDE") {
            $netV = $total + $taxAmt;
        } else { // Tax is already included in price
            $netV = $total;
        }

        $data = array(
            'SiNo' => $index,
            'ItemC' => $itemC,
            'Item' => $itemName,
            'Qty' => $qty,
            'sqft' => $cost,
            'Rate' => $price,
            'Dis' => $disc,
            'Tot' => $total,
            'TaxP' => $taxPerc,
            'TaxA' => $taxAmt,
            'Total' => $netV,
            'RetNo' => $retNo,
            'SBDate' => $date1,
            'Stat' => '0',
            'godown' => $employee,
            'local_app_user_entry_id' => $local_app_user_entry_id,
            'Unit' => $unit,
            'Pack' => $qty_in_pack
        );


        // Insert into DB
        $this->db->insert(super_model::$table_sales_return, $data);
        $insert_id = $this->db->insert_id();

        if ($this->db->affected_rows() == 1) {
            return TRUE;
        } else {
            return FALSE;
        }
    }


    public function SaveSalesRetunCollection($RetNo, $dates, $BillPartyName, $BillTotalField, $BillNetTotalField, $Employee, $godown, $local_app_user_entry_id, $TaxAmt, $fin_year)
    {
        $data = array(
            'BillNo' => $RetNo,
            'TransactionType' => 'ToSalesReturn',
            'Date1' => $dates,
            'PartyName' => $BillPartyName,
            'Amount' => $BillNetTotalField,
            'Employee' => $Employee,
            'Typ' => 'CUSTOMER',
            'BillForm' => '8',
            'godown' => $godown,
            'local_app_user_entry_id' => $local_app_user_entry_id,
            'fin_year' => $fin_year,
            'TaxBillNo' => $RetNo
        );

        $this->db->insert(super_model::$table_collection, $data);

        if ($this->db->affected_rows() === 1) {
            return $this->db->insert_id();
        } else {
            return FALSE;
        }
    }

    public function getSRT_TAXBillNo()
    {
        $query = $this->db->query("SELECT MAX(TaxBillNo+1) AS TaxBillNo FROM " . super_model::$table_sr_master_details);
        if ($query->num_rows() > 0) {
            if ($row = $query->result_array()) {
                if ($row[0]["TaxBillNo"] == "Null" || $row[0]["TaxBillNo"] == null || $row[0]["TaxBillNo"] == 0) {
                    return $row[0]["TaxBillNo"] = 1;
                } else {
                    return $row[0]["TaxBillNo"];
                }
            } else {
                return false;
            }
        }
    }


    public function getB2B_TAXBillNo()
    {
        $query = $this->db->query("SELECT MAX(TaxBillNo+1) AS TaxBillNo FROM " . super_model::$table_master_details);
        if ($query->num_rows() > 0) {
            if ($row = $query->result_array()) {
                if ($row[0]["TaxBillNo"] == "Null" || $row[0]["TaxBillNo"] == null || $row[0]["TaxBillNo"] == 0) {
                    return $row[0]["retNo"] = 1;
                } else {
                    return $row[0]["TaxBillNo"];
                }
            } else {
                return false;
            }
        }
    }

    public function getB2C_TAXBillNo()
    {
        $query = $this->db->query("SELECT MAX(TaxBillNo+1) AS TaxBillNo FROM " . super_model::$table_master_details8Bnew);
        if ($query->num_rows() > 0) {
            if ($row = $query->result_array()) {
                if ($row[0]["TaxBillNo"] == "Null" || $row[0]["TaxBillNo"] == null || $row[0]["TaxBillNo"] == 0) {
                    return $row[0]["retNo"] = 1;
                } else {
                    return $row[0]["TaxBillNo"];
                }
            } else {
                return false;
            }
        }
    }


    public function deleteFromMasterDetails8BNEW_ByBillNo($luserEntryID, $billNo)
    {
        $this->db->where('local_app_user_entry_id', $luserEntryID);
        $this->db->where('BillNo!=', $billNo);
        $this->db->where('local_app_user_entry_id IS NOT NULL', null, false);
        $this->db->delete(super_model::$table_master_details8Bnew);
    }


    public function storeUserB2Cdata($itemName, $price, $qty, $unit, $party, $godown, $employee, $date1, $invno, $local_app_user_entry_id, $billNo, $index, $taxAmt, $taxPerc, $itemC, $qty_in_pack, $cost, $disc, $sqft, $taxtyp, $netV)
    {
        $res = $this->db->query("DELETE FROM " . super_model::$table_sales_bill . " WHERE local_app_user_entry_id='$local_app_user_entry_id' AND  BillNo != '$billNo' AND local_app_user_entry_id IS NOT NULL AND BillTyp = '8BNEW' ");
        if ($res) {

            // $total = ($price - $disc) * $qty;

            $total = ($price * $qty) - $disc;

            // if ($taxtyp == "EXCLUDE") {
            //     $netV = $total + $taxAmt;
            // } else {
            //     $netV = $total;
            // }

            $data = array(
                'SiNo' => $index,
                'ItemC' => $itemC,
                'Item' => $itemName,
                'Qty' => $qty,
                'sqft' => $sqft,
                'Rate' => $price,
                'ItWiseDisAmt' => '0',
                'Dis' => $disc,
                'Total' => $total,
                'NetV' => $netV,
                'GoodsOn' => $employee,
                'BillNo' => $billNo,
                'SBDate' => $date1,
                'Cst' => $cost,
                'BillTyp' => '8BNEW',
                'Stat' => '0',
                'local_app_user_entry_id' => $local_app_user_entry_id,
                'local_app_invoice_id' => $invno,
                'TaxP' => $taxPerc,
                'TaxA' => $taxAmt,
                'Unit' => $unit,
                'Pack' => $qty_in_pack
            );


            $this->db->insert(super_model::$table_sales_bill, $data);
            // if ($this->db->error()) {
            //     print_r('ppppppppppppppppppppppppppp3');
            //     return FALSE; // Return FALSE if a database error occurs
            // }
            $insert_id = $this->db->insert_id();
            if ($this->db->affected_rows() == 1) {
                return TRUE;
                //  $this->MobileAPI->log_gen("uu");
            } else {
                return FALSE;
            }
        }

        return FALSE;
    }


    public function salesReportBtoc($date1, $date2)
    {
        // $query = $this->db->query("SELECT DISTINCT BillNo,bill_time,PartyName,NetTotal, DATE_FORMAT(Date1, '%d-%m-%Y') AS Date1 FROM " . super_model::$table_collection . " WHERE Date1 BETWEEN '$date1 00:00:00' AND '$date2 23:59:59' AND TransactionType='ToSales' AND BillForm ='8BNEW'  ORDER BY BillNo ASC");
        $query = $this->db->query("SELECT 
        c.BillNo,
        c.bill_time,
        c.PartyName,
        c.NetTotal,
        DATE_FORMAT(c.Date1, '%d-%m-%Y') AS Date1,
    CASE 
        WHEN sb.BillNo IS NOT NULL THEN 'uploaded'
        ELSE 'partial'
    END AS STATUS
    FROM " . super_model::$table_collection . " c
        LEFT JOIN (
        SELECT DISTINCT BillNo, BillTyp FROM " . super_model::$table_sales_bill . " WHERE BillTyp = '8BNEW'
        ) sb ON sb.BillNo = c.BillNo
        WHERE c.Date1 BETWEEN '$date1 00:00:00' AND '$date2 23:59:59'
        AND c.TransactionType = 'ToSales'
        AND c.BillForm = '8BNEW'
        ORDER BY c.BillNo ASC");

        $data = $query->result_array();
        for ($i = 0; $i < count($data); $i++) {
            if ($data[$i]["bill_time"] == null) {
                $data[$i]["bill_time"] = "";
            }
            $data[$i]["dateTime"] = $data[$i]["Date1"] . " " . $data[$i]["bill_time"];
        }
        return $data;
    }


    public function get_order_items($billNumber, $bill_typ, $empName)
    {
        $query = $this->db->query("SELECT Item,Qty FROM " . super_model::$table_sales_bill8B . " WHERE BillNo = '$billNumber' AND BillTyp = '8B' AND GoodsOn = '$empName'  ORDER BY Item ASC ");
        $data = $query->result_array();
        return $data;
    }

    public function get_prefix_val()
    {
        $query = $this->db->query("SELECT VALUE FROM " . super_model::$table_status_table . " WHERE params = 'INVOICE_PREFIX' AND Typ = 'CONFIG'");
        if ($query->num_rows() > 0) {
            $row = $query->result_array();
            return $row[0]["VALUE"]; // Use the correct column name
        } else {
            return false;
        }
    }

    public function get_b2c_print_items($billNo, $bill_typ, $empName)
    {
        $query = $this->db->query("SELECT s.*, m.BillPartyName AS party, m.BillDiscAmtField AS Discount , m.NewBillNo AS prefix_no 
        FROM " . super_model::$table_sales_bill . " AS s 
        INNER JOIN " . super_model::$table_master_details8Bnew . " AS m 
        ON s.billno = m.billno
        WHERE s.billno = '$billNo' 
        AND s.BillTyp = '8BNEW' 
        AND m.lorry = '$empName' 
        AND s.GoodsOn = '$empName'");
        $data = $query->result_array();
        return $data;
    }

    public function get_b2c_zatca_print_items($billNo, $empName, $bill_form)
    {
        $query = $this->db->query("SELECT zt.* FROM " . super_model::$zatca_einv_stat . " AS zt INNER JOIN 
        " . super_model::$table_master_details8Bnew . "  AS m WHERE zt.bill_no = '$billNo' AND m.billno = '$billNo'  
        AND zt.bill_form = '$bill_form' AND m.lorry = '$empName'  AND zt.curr_usr = '$empName' ");
        $data = $query->result_array();
        return $data;
    }

    public function get_b2b_zatca_print_items($billNo, $empName, $bill_form)
    {
        $query = $this->db->query("SELECT zt.* FROM " . super_model::$zatca_einv_stat . " AS zt INNER JOIN 
        " . super_model::$table_master_details . "  AS m WHERE zt.bill_no = '$billNo' AND m.billno = '$billNo'  
        AND zt.bill_form = '$bill_form' AND m.lorry = '$empName'  AND zt.curr_usr = '$empName' ");
        $data = $query->result_array();
        return $data;
    }

    public function get_srt_print($billNo, $employee)
    {
        $query = $this->db->query("SELECT s.*,m.BillPartyName AS party,m.local_app_user_entry_id AS BillTime FROM " . super_model::$table_sales_return . "  AS s INNER JOIN " . super_model::$table_sr_master_details . " AS m WHERE s.RetNo = '$billNo' AND m.RetNo = '$billNo'  AND m.Employee = '$employee'  AND s.godown = '$employee' ");
        $data = $query->result_array();
        return $data;
    }

    public function get_srt_zatca_print($billNo, $employee, $bill_form)
    {
        $query = $this->db->query("SELECT zt.* FROM " . super_model::$zatca_einv_stat . "  AS zt INNER JOIN 
        " . super_model::$table_sr_master_details . "  AS m WHERE zt.bill_no = '$billNo' AND m.RetNo = '$billNo'  
        AND zt.bill_form = '$bill_form' AND m.Employee = '$employee'  AND zt.curr_usr = '$employee' ");
        $data = $query->result_array();
        return $data;
    }


    public function purchaseReturnReport($date1, $date2, $empName)
    {
        $query = $this->db->query("SELECT BillNo,bill_time,DATE_FORMAT(Date1, '%d-%m-%Y') AS Date1,PartyName, NetTotal AS Amount  FROM " . super_model::$table_collection . " WHERE Date1 BETWEEN '$date1' AND '$date2' AND TransactionType = 'ToPurchaseReturn'  AND  Typ ='PURCHASE PARTY'  AND Employee = '$empName' ORDER BY BillNo ASC ");
        $data = $query->result_array();
        for ($i = 0; $i < count($data); $i++) {
            if ($data[$i]["bill_time"] == null) {
                $data[$i]["bill_time"] = "";
            }
            $data[$i]["dateTime"] = $data[$i]["Date1"] . " " . $data[$i]["bill_time"];
            $data[$i]["NetTotal"] = $data[$i]["Amount"];
        }
        return $data;
    }


    public function getPBILL_TAXBillNo()
    {
        $query = $this->db->query("SELECT MAX(TaxBillNo+1) AS TaxBillNo FROM " . super_model::$table_Pbill);
        if ($query->num_rows() > 0) {
            if ($row = $query->result_array()) {
                if ($row[0]["TaxBillNo"] == "Null" || $row[0]["TaxBillNo"] == null || $row[0]["TaxBillNo"] == 0) {
                    return $row[0]["TaxBillNo"] = 1;
                } else {
                    return $row[0]["TaxBillNo"];
                }
            } else {
                return false;
            }
        }
    }


    public function getFinYearPBill()
    {
        $query = $this->db->query("SELECT fin_year FROM " . super_model::$table_Pbill . "  ORDER BY InvoiceNo DESC LIMIT 1");
        if ($query->num_rows() > 0) {
            if ($row = $query->result_array()) {
                return $row[0]["fin_year"];
            } else {
                return false;
            }
        }
    }


    public function getholditems_party($party)
    {
        $data = array();
        $query1 = $this->db->query("SELECT party,item,qty,unit,slno,emp,date1,bill_tot,items_tot FROM hold_master_tbl WHERE party = '$party'  ORDER BY party ASC ");
        $data = $query1->result_array();
        return $data;
    }

    public function delete_product_cloud($itemname)
    {
        $query = $this->db->query("DELETE FROM " . super_model::$table_sales_item . " WHERE ItemNameTextField = " . $this->db->escape($itemname));

        if ($query) {
            return ['status' => true, 'message' => 'Product deleted successfully'];
        } else {
            return ['status' => false, 'message' => 'Failed to delete product'];
        }
    }


    public function DeleteCategory($itemname)
    {
        $this->db->where('Description', 'PRODUCT GROUP');
        $this->db->where('Typ', $itemname);
        $this->db->delete(super_model::$table_other);

    }


    public function update_Product($itemname, $itemcode, $stock, $user, $godown, $base_rate_retail, $sec_rate_retail, $base_unit, $sec_unit, $category, $img, $tax, $base_rate_wholesale, $sec_rate_wholesale, $qty_in_pack, $local_app_user_entry_id, $Cost, $SecCostRate, $StockInMain, $Rate3, $prod_typ, $CostRs, $Disc, $DiscP, $Color, $ArabicName, $ThirdCost, $ThirdRate, $ThirdUnit, $ThirdPack, $barcode, $old_name, $upload_typ, $SecBarcode, $ThirdBarcode)
    {
        $billTime = date("h:i A");
        $date1 = date("Y-m-d") . " 00:00:00";

        if ($upload_typ == "DIRECT") {
            // Delete from salesitem based on oldName
            $this->db->where('ItemNameTextField', $old_name);
            $this->db->delete(super_model::$table_sales_item);

            $this->db->where('ItemName', $old_name);
            $this->db->delete(super_model::$table_barcode);


            $this->db->insert("Barcode", [
                'ItemName' => $itemname,
                'NewBarNo' => $barcode,
                'NewBarText' => $barcode,
                'Typ' => 'FromSalesItem',
                'BillNo' => '',
                'Stat' => ''
            ]);

            $data2 = array(
                'ItemNameTextField' => $itemname,
                'ItemC' => $barcode,
                'StockInMain' => $StockInMain,
                'StockInGoDown' => '0',
                'Cost' => $Cost,
                'Rate1' => $base_rate_retail,
                'Rate2' => $base_rate_wholesale,
                'Rate3' => $Rate3,
                'Disc' => $Disc,
                'Tax1' => $tax,
                'DiscP' => $DiscP,
                'Color' => $Color,
                'Size' => $category,
                'MfgDate' => $date1,
                'CostRs' => $CostRs,
                'Typ' => $base_unit,
                'Stat' => '0',
                'Pack' => $qty_in_pack,
                'prod_typ' => $prod_typ,
                'photo' => $img,
                'RatePerInch' => '0',
                'photo1' => '0',
                'curr_stock' => $stock,
                'SecUnit' => $sec_unit,
                'SecCostRate' => $SecCostRate,
                'SecRetailRate' => $sec_rate_retail,
                'SecWholesaleRate' => $sec_rate_wholesale,
                'local_app_user_entry_id' => $local_app_user_entry_id,
                'empCode' => $user,
                'ArabicName' => $ArabicName,
                'ThirdCost' => $ThirdCost,
                'ThirdRate1' => $ThirdRate,
                'ThirdUnit' => $ThirdUnit,
                'NewItemCode' => $itemcode,
                'ThirdPack' => $ThirdPack,
                'SecBarcode' => $SecBarcode,
                'ThirdBarcode' => $ThirdBarcode,
                'subCategory' => 'NIL',
                'carmaker' => 'NIL',
                'model' => 'NIL',
                'year1' => 'NIL',
                'varient' => 'NIL',
                'printer' => 'ALL KOT'


            );
            // 5 Insert new salesitem row
            $this->db->insert(super_model::$table_sales_item, $data2);

            return ($this->db->affected_rows() == 1);

        }
        return TRUE; // Non-direct update (skip) 
    }




}
