<!DOCTYPE html>
<html>

<head>
    <style>
        /* General table styles */
        body {
            width: 100%;
            display: flex;
            justify-content: center;

        }

        table {
            border-collapse: collapse;
            margin: 25px 0;
            font-size: 0.9cm;
            min-width: 400px;
            border-radius: 5px;
            overflow: hidden;
            box-shadow: 0 0 20px rgba(0, 0, 0, 0.15);
            width: 80%;
            margin-top: 40px;
            margin-left: 50px;
        }

        /* Header row styles */
        thead tr {
            background-color: #009879;
            color: #ffffff;
            /* Change this to white for better visibility */
            text-align: left;
            font-weight: bold;
        }

        /* Table cell padding */
        table th,
        table td {
            padding: 10px 13px;
            font-size: 15px;
        }

        table td {
            font-size: 12px;
        }

        /* Body row styles */
        tbody tr {
            border-bottom: 1px solid #dddddd;
        }

        /* Even row styles */
        tbody tr:nth-of-type(even) {
            background-color: #f3f3f3;
        }

        /* Last row styles */
        tbody tr:last-of-type {
            border-bottom: 2px solid #009879;
        }

        button {
            width: 40%;
            border-radius: 5px;
            border-color: transparent;
            padding: 5px;
            text-decoration: underline;
            font-family: Arial, Helvetica, sans-serif;

        }

        div {
            width: 100%;
            display: flex;
            justify-content: space-around;
        }

        .center {
            text-align: center;
        }
    </style>

    <link rel="stylesheet" href="<?php echo base_url() . 'jr_resources/bootstrap/css/bootstrap.min.css'; ?>">
    <title>Database Backups</title>
</head>

<body>
    <table>
        <thead>
            <tr>
                <th>Sl No</th>
                <th>Date</th>
                <th>Database Name</th>
                <th>Action</th>
            </tr>
        </thead>
        <tbody>
            <?php
            $i = 0;
            foreach ($data as $db) {
                $i++;       ?>
                <tr>
                    <td><?= $i; ?></td>
                    <td><?= substr($db, 0, 10); ?></td>
                    <td><?= $db ?></td>
                    <td>
                        <div>
                            <a href="<?= base_url() . 'home/downloadDb?file=' . $db; ?>"><button class="btn btn-success btn-block">Download</button></a>
                            <a href="<?= base_url() . 'home/deleteDb?file=' . $db; ?>"><button class="btn btn-danger btn-block">Delete</button></a>
                        </div>
                    </td>
                </tr>
            <?php }
            ?>

        </tbody>
    </table>

    <script>
        // JavaScript alert for success message
        <?php if ($this->session->flashdata('message')) { ?>
            alert('<?= $this->session->flashdata('message') ?>');
        <?php  } ?>
    </script>
</body>


</html>